//
// ac68_exe_regfile.v
//
// ac68 processor core
//
// Version 0.6
//
// Copyright 2008, Hideyuki Abe. All rights reserved.
// Distributed under the terms of the MIT License.
//

`include "ac68_defs.v"

module ac68_exe_regfile(
	clk,
	rst,
	raddr,
	ren,
	rwen,
	rwdata,
	rrdata,
	ccr_i,
	ccr_o,
	ibase
);

input	clk;
input	rst;
input [`REG_LEN - 1:0]	raddr;
input	ren;
input	rwen;
input [15:0]	rwdata;
output [15:0]	rrdata;
input [7:0]	ccr_i;
output [7:0]	ccr_o;
output [15:0]	ibase;

reg [`REG_LEN - 1:0]	raddr_d;
reg [15:0]	rrdata;

wire	dpr_wen;
reg [7:0]	dpr;

wire	ccr_wen;
reg [7:0]	ccr_o;

wire	acca_wen;
wire	accb_wen;
reg	[7:0]	acca;
reg [7:0]	accb;

wire	ix_wen;
reg [15:0]	ix;

wire	sp_wen;
reg [15:0]	sp;


assign	ccr_wen = (raddr == `REG_CCR) & ren & rwen;

always @(ccr_wen or rwdata or ccr_i) begin
	if(ccr_wen)
		ccr_o = rwdata[7:0];
	else
		ccr_o = ccr_i;
end	// always comb

assign	acca_wen = (raddr == `REG_ACCA) & ren & rwen;
assign	accb_wen = (raddr == `REG_ACCB) & ren & rwen;

always @(posedge clk or negedge rst) begin
	if(~rst)
		acca <= 8'h00;
	else if(acca_wen)
		acca <= rwdata[7:0];
end

always @(posedge clk or negedge rst) begin
	if(~rst)
		accb <= 8'h00;
	else if(accb_wen)
		accb <= rwdata[7:0];
end

assign	ix_wen = (raddr == `REG_IX) & ren & rwen;

always @(posedge clk or negedge rst) begin
	if(~rst)
		ix <= 16'h0000;
	else if(ix_wen)
		ix <= rwdata;
end

assign	sp_wen = (raddr == `REG_SP) & ren & rwen;

always @(posedge clk or negedge rst) begin
	if(~rst)
		sp <= 16'h0000;
	else if(sp_wen)
		sp <= rwdata;
end

always @(posedge clk or negedge rst) begin
	if(~rst)
		raddr_d <= `REG_ACCA;
	else
		raddr_d <= raddr;
end

always @(
	raddr_d or ccr_i or acca or accb
	or ix or sp
) begin
	case(raddr_d)
	`REG_CCR:
		rrdata = {8'h00,ccr_i};
	`REG_ACCA:
		rrdata = {8'h00,acca};
	`REG_ACCB:
		rrdata = {8'h00,accb};
	`REG_IX:
		rrdata = ix;
	`REG_SP:
		rrdata = sp;
	default:
		rrdata = 16'h0000;
	endcase
end	// always comb

assign	ibase = ix;

endmodule

// End of ac68_exe_regfile.v
