//
// ac68_defs.v
//
// ac68 processor core
//
// Version 0.6
//
// Copyright 2008, Hideyuki Abe. All rights reserved.
// Distributed under the terms of the MIT License.
//

// opcode
`define	OPC_BOPR	4'b0001_____
`define	OPC_BOP		1'b1________
`define	OPC_UOPR	3'b010______
`define	OPC_UOP		3'b011______
`define	OPC_BCC		4'b0010_____
`define	OPC_BIT		5'b1____0101
`define	OPC_BSR		8'b1000_1101
`define	OPC_CLC		8'b0000_1100
`define	OPC_CLI		8'b0000_1110
`define	OPC_CLV		8'b0000_1010
`define	OPC_CLRR	7'b010__1111
`define	OPC_CLR		7'b011__1111
`define	OPC_CBA		8'b0001_0001
`define	OPC_CMP		5'b1____0001
`define	OPC_CMP16	6'b10___1100
`define	OPC_DAA		8'b0001_1001
`define	OPC_INDCS	5'b0011_0___
`define	OPC_INDCX	7'b0000_100_
`define	OPC_JMP		7'b011__1110
`define	OPC_JSR		7'b101__1101
`define	OPC_LD		5'b1____0110
`define	OPC_LD16	5'b1____1110
`define	OPC_NOP		8'b0000_0001
`define	OPC_PUSH	7'b0011_011_
`define	OPC_PULL	7'b0011_001_
`define	OPC_RTI		8'b0011_1011
`define	OPC_RTS		8'b0011_1001
`define	OPC_SEC		8'b0000_1101
`define	OPC_SEI		8'b0000_1111
`define	OPC_SEV		8'b0000_1011
`define	OPC_ST		5'b1____0111
`define	OPC_ST16	5'b1____1111
`define	OPC_SWI		8'b0011_1111
`define	OPC_TFR		7'b0001_011_
`define	OPC_TFR2	7'b0000_011_
`define	OPC_TSX		8'b0011_0000
`define	OPC_TXS		8'b0011_0101
`define	OPC_TSTR	7'b010__1101
`define	OPC_TST		7'b011__1101
`define	OPC_WAI		8'b0011_1110

`define	OPC_UNDEF	8'h00

// register number
`define	REG_LEN		3
`define	REG_IX		3'b000
`define	REG_SP		3'b001
`define	REG_ACCA	3'b100
`define	REG_ACCB	3'b101
`define	REG_CCR		3'b110

// amode
`define	AMODE_LEN	3
`define	AMODE_NONE	3'b000
`define	AMODE_IMM8	3'b001
`define	AMODE_IMM16	3'b010
`define	AMODE_DIR	3'b011
`define	AMODE_IDX	3'b100
`define	AMODE_EXT	3'b101
`define	AMODE_REL	3'b110

// ea_mux
`define	EAMUX_LEN	3
`define	EAMUX_NULL	3'b000
`define	EAMUX_OUTA	3'b001
`define	EAMUX_DDAT	3'b010
`define	EAMUX_IBASE	3'b011
`define	EAMUX_RDAT	3'b100

// pc_mux
`define	PCMUX_LEN	3
`define	PCMUX_ZERO	3'b000
`define	PCMUX_TMP	3'b001
`define	PCMUX_OUTA	3'b010
`define	PCMUX_EA	3'b011

// cpc_mux
`define	CPCMUX_LEN	2
`define	CPCMUX_NULL	2'b00
`define	CPCMUX_PCN	2'b01
`define	CPCMUX_PCR	2'b10

// tmp_mux
`define	TMUX_LEN	3
`define	TMUX_NULL	3'b000
`define	TMUX_DDAT	3'b001
`define	TMUX_RDAT	3'b010
`define	TMUX_PSHINI	3'b011
`define	TMUX_PSHNXT	3'b100
`define	TMUX_PULINI	3'b101
`define	TMUX_PULNXT	3'b110

// op_sel
`define	ALUOP_LEN	5
`define	ALUOP_NONE	5'b0_0000
`define	ALUOP_THRU	5'b0_0001
`define	ALUOP_ADD	5'b0_0010
`define	ALUOP_SUB	5'b0_0011
`define	ALUOP_ADD16	5'b0_0100
`define	ALUOP_SUB16	5'b0_0101
`define	ALUOP_AND	5'b0_0110
`define	ALUOP_EOR	5'b0_0111
`define	ALUOP_OR	5'b0_1000
`define	ALUOP_COM	5'b0_1001
`define	ALUOP_NEG	5'b0_1010
`define	ALUOP_ADC	5'b0_1011
`define	ALUOP_SBC	5'b0_1100
`define	ALUOP_DAA	5'b0_1101
`define	ALUOP_TST	5'b0_1110
`define	ALUOP_ASR	5'b0_1111
`define	ALUOP_LSR	5'b1_0000
`define	ALUOP_ASL	5'b1_0001
`define	ALUOP_ROR	5'b1_0010
`define	ALUOP_ROL	5'b1_0011
`define	ALUOP_MUL	5'b1_0100
`define	ALUOP_PSH	5'b1_0101
`define	ALUOP_PUL	5'b1_0110
`define	ALUOP_INC	5'b1_0111
`define	ALUOP_DEC	5'b1_1000

`define	ALUOP_MAIN	5'b1_1111

// ina_mux
`define	AMUX_LEN	3
`define	AMUX_ZERO	3'b000
`define	AMUX_OPRND	3'b001
`define	AMUX_RDAT	3'b010
`define	AMUX_PC		3'b011
`define	AMUX_DDAT	3'b100
`define	AMUX_EA		3'b101
`define	AMUX_IBASE	3'b110
`define	AMUX_TMP	3'b111

// inb_mux
`define	BMUX_LEN		4
`define	BMUX_ZERO		4'b0000
`define	BMUX_OPRND		4'b0001
`define	BMUX_OPRND8SE	4'b0010
`define	BMUX_DDAT		4'b0011
`define	BMUX_ONE		4'b0100
`define	BMUX_TWO		4'b0101
`define	BMUX_TMP		4'b0110
`define	BMUX_OPRND8ZE	4'b0111
`define	BMUX_RDAT		4'b1000
`define	BMUX_PSH		4'b1001
`define	BMUX_PUL		4'b1010

// cc_mux
`define	CCMUX_LEN	4
`define	CCMUX_NULL	4'b0000
`define	CCMUX_LOP	4'b0001
`define	CCMUX_AOP	4'b0010
`define	CCMUX_AOP2	4'b0011
`define	CCMUX_ZBIT	4'b0100
`define	CCMUX_AOP3	4'b0101
`define	CCMUX_CLC	4'b0110
`define	CCMUX_CLI	4'b0111
`define	CCMUX_CLV	4'b1000
`define	CCMUX_SEC	4'b1001
`define	CCMUX_SEI	4'b1010
`define	CCMUX_SEV	4'b1011

// rbus_mux
`define	RMUX_LEN	2
`define	RMUX_NULL	2'b00
`define	RMUX_WR		2'b01
`define	RMUX_RD		2'b10

// rnum_mux
`define	RNUM_LEN	3
`define	RNUM_ZERO	3'b000
`define	RNUM_OPREG	3'b001
`define	RNUM_OPREG2	3'b010
`define	RNUM_TMP	3'b011
`define	RNUM_SP		3'b100

// rwd_mux
`define	RWDMUX_LEN	3
`define	RWDMUX_ZERO	3'b000
`define	RWDMUX_OUTA	3'b001
`define	RWDMUX_RDAT	3'b010
`define	RWDMUX_TMP	3'b011
`define	RWDMUX_EA	3'b100
`define	RWDMUX_DDAT	3'b101

// dbus_mux
`define	DMUX_LEN	4
`define	DMUX_NULL	4'b0000
`define	DMUX_RD16	4'b0001
`define	DMUX_RD		4'b0010
`define	DMUX_WR		4'b0011
`define	DMUX_WR16	4'b0100
`define	DMUX_WRT	4'b0101
`define	DMUX_RDT	4'b0110
`define	DMUX_RD8	4'b0111
`define	DMUX_WR8	4'b1000

// da_mux
`define	DAMUX_LEN	4
`define	DAMUX_ZERO	4'b0000
`define	DAMUX_RSTV	4'b0001
`define	DAMUX_EA	4'b0010
`define	DAMUX_OUTA	4'b0011
`define	DAMUX_RDAT	4'b0100
`define	DAMUX_NMIV	4'b0101
`define	DAMUX_IRQV	4'b0110
`define	DAMUX_SWIV	4'b0111

// dwd_mux
`define	DWDMUX_LEN	3
`define	DWDMUX_ZERO	3'b000
`define	DWDMUX_OUTA	3'b001
`define	DWDMUX_PC	3'b010
`define	DWDMUX_RDAT	3'b011
`define	DWDMUX_CPC	3'b100

// End of ac68_defs.v
