//
// ac68_core.v
//
// ac68 processor core
//
// Version 0.6
//
// Copyright 2008, Hideyuki Abe. All rights reserved.
// Distributed under the terms of the MIT License.
//

`include "ac68_defs.v"

module ac68_core(
	clk,
	rst,
	paddr,
	pen,
	prdata,
	pack,
	daddr,
	den,
	dwen,
	dwdata,
	drdata,
	dack,
	irq,
	nmi
);

input	clk;
input	rst;
output [15:0]	paddr;
output	pen;
input [7:0]	prdata;
input	pack;
output [15:0]	daddr;
output	den;
output	dwen;
output [7:0]	dwdata;
input [7:0]	drdata;
input	dack;
input	irq;
input	nmi;

wire	inst_rdy;
wire	inst_ack;
wire [15:0]	pc_nxt;
wire	jmp_req;
wire	jmp_ack;
wire [15:0]	new_pc;

wire [7:0]	opcode;
wire [`AMODE_LEN - 1:0]	amode;
wire [15:0]	oprnd;


ac68_fetch fetch0(
	.clk(clk),
	.rst(rst),
	.inst_rdy(inst_rdy),
	.inst_ack(inst_ack),
	.pc_nxt(pc_nxt),
	.jmp_req(jmp_req),
	.jmp_ack(jmp_ack),
	.new_pc(new_pc),
	.opcode(opcode),
	.amode(amode),
	.oprnd(oprnd),
	.calc_ea(calc_ea),
	.paddr(paddr),
	.pen(pen),
	.prdata(prdata),
	.pack(pack)
);

ac68_exe exe0(
	.clk(clk),
	.rst(rst),
	.inst_rdy(inst_rdy),
	.inst_ack(inst_ack),
	.pc(pc_nxt),
	.jmp_req(jmp_req),
	.jmp_ack(jmp_ack),
	.new_pc(new_pc),
	.opcode(opcode),
	.amode(amode),
	.oprnd(oprnd),
	.calc_ea(calc_ea),
	.daddr(daddr),
	.den(den),
	.dwen(dwen),
	.dwdata(dwdata),
	.drdata(drdata),
	.dack(dack),
	.irq(irq),
	.nmi(nmi)
);

endmodule

// End of ac68_core.v
