//
// xmem_mux.v
//
// ac51 microcontroller core
//
// Version 0.6
//
// Copyright 2008, Hideyuki Abe. All rights reserved.
// Distributed under the terms of the MIT License.
//

module xmem_mux(
	clk,
	rst,
	paddr,
	pen,
	prdata,
	pack,
	xaddr,
	xen,
	xwdata,
	xrdata,
	xwen,
	xack,
	sram_addr,
	sram_wdata,
	sram_rdata,
	sram_en,
	sram_wen,
	pram_addr,
	pram_wdata,
	pram_rdata,
	pram_en,
	pram_wen
);

input	clk;
input	rst;
input [15:0]	paddr;
input	pen;
output [7:0]	prdata;
output	pack;
input [15:0]	xaddr;
input	xen;
input [7:0]	xwdata;
output [7:0]	xrdata;
input	xwen;
output	xack;
output [17:0]	sram_addr;
output [7:0]	sram_wdata;
input [7:0]	sram_rdata;
output	sram_en;
output	sram_wen;
output [12:0]	pram_addr;
output [7:0]	pram_wdata;
input [7:0]	pram_rdata;
output	pram_en;
output	pram_wen;

reg [17:0]	sram_addr;
reg	sram_en;
reg	sram_wen;
reg [7:0]	sram_wdata;

reg	pen_d;
reg	xen_d;
wire [15:0]	addr_i;
wire	en_i;
wire	wen_i;
wire [7:0]	wdata_i;
wire [7:0]	rdata_i;
reg	ack_i;

reg	pram_en_d;

always @(posedge clk or negedge rst) begin
	if(~rst) begin
		pen_d <= 1'b0;
		xen_d <= 1'b0;
	end
	else begin
		pen_d <= pen;
		xen_d <= xen;
	end
end	// always

assign	addr_i = xen ? xaddr : paddr;
assign	en_i = pen | xen;
assign	wen_i = xwen;
assign	wdata_i = xen ? xwdata : 8'h00;
assign	prdata = rdata_i;
assign	xrdata = rdata_i;
assign	pack = (~xen_d) ? ack_i : 1'b0;
assign	xack = xen_d ? ack_i : 1'b0;

always @(posedge clk or negedge rst) begin
	if(~rst)
		ack_i <= 1'b0;
	else
		ack_i <= en_i;
end	// always

assign	pram_addr = addr_i[12:0];
assign	pram_en = en_i & (addr_i[15:13] == 3'b000);
assign	pram_wen = pram_en & wen_i;
assign	pram_wdata = wdata_i;

always @(posedge clk or negedge rst) begin
	if(~rst)
		pram_en_d <= 1'b0;
	else
		pram_en_d <= pram_en;
end	// always

assign	rdata_i = pram_en_d ? pram_rdata : sram_rdata;

always @(posedge clk or negedge rst) begin
	if(~rst) begin
		sram_addr <= 18'h0_0000;
		sram_en <= 1'b0;
		sram_wen <= 1'b0;
		sram_wdata <= 8'h00;
	end
	else begin
		sram_addr <= {2'b00, addr_i};
		sram_en <= en_i & (addr_i[15:13] != 3'b000);
		sram_wen <= en_i & (addr_i[15:13] != 3'b000) & wen_i;
		sram_wdata <= wdata_i;
	end
end	// always

endmodule

// End of xmem_mux.v
