//
// cyc2.v
//
// cycloneII for Terasic DE1
//

module cyc2(
	clk24_0,
	clk24_1,
	clk27_0,
	clk27_1,
	clk50,
	ext_clk,
	flash_addr,
	flash_data,
	flash_rst,
	flash_ce,
	flash_oe,
	flash_we,
	sram_addr,
	sram_data,
	sram_ce,
	sram_oe,
	sram_we,
	sram_ub,
	sram_lb,
	dram_addr,
	dram_data,
	dram_clk,
	dram_cke,
	dram_cs,
	dram_we,
	dram_ba1,
	dram_ba0,
	dram_ras,
	dram_cas,
	dram_udqm,
	dram_ldqm,
	ps2_clk,
	ps2_dat,
	uart_txd,
	uart_rxd,
	ac_mclk,
	ac_bclk,
	ac_adlrck,
	ac_addat,
	ac_dalrck,
	ac_dadat,
	i2c_scl,
	i2c_sda,
	vga_r,
	vga_g,
	vga_b,
	vga_hsync,
	vga_vsync,
	sd_clk,
	sd_cmd,
	sd_dat,
	sd_dat3,
	hex0,
	hex1,
	hex2,
	hex3,
	ledr,
	ledg,
	sw,
	key,
	gpio0,
	gpio1,
	tck,
	tcs,
	tdi,
	tdo
);

// clock
input	clk24_0;	// 24MHz from USB Blaster
input	clk24_1;	// 24MHz from USB Blaster
input	clk27_0;	// 27MHz
input	clk27_1;	// 27MHz
input	clk50;	// 50MHz
input	ext_clk;	// external clock

// memory interface
// Flash
output [21:0]	flash_addr;
inout [7:0]		flash_data;
output	flash_rst;
output	flash_ce;
output	flash_oe;
output	flash_we;
// SRAM
output [17:0]	sram_addr;
inout [15:0]	sram_data;
output	sram_ce;
output	sram_oe;
output	sram_we;
output	sram_ub;
output	sram_lb;
// SDRAM
output [11:0]	dram_addr;
inout [15:0]	dram_data;
output	dram_clk;
output	dram_cke;
output	dram_cs;
output	dram_we;
output	dram_ba1;
output	dram_ba0;
output	dram_ras;
output	dram_cas;
output	dram_udqm;
output	dram_ldqm;

// PS/2 KB/Mouse interface
output	ps2_clk;
inout	ps2_dat;

// UART interface
output	uart_txd;
input	uart_rxd;

// Audio Codec interface
output	ac_mclk;	// master clock
output	ac_bclk;	// bit clock (inout ???)
output	ac_adlrck;
input	ac_addat;
output	ac_dalrck;
output	ac_dadat;
output	i2c_scl;
inout	i2c_sda;

// VGA interface
output [3:0]	vga_r;
output [3:0]	vga_g;
output [3:0]	vga_b;
output	vga_hsync;
output	vga_vsync;

// SD Card interface
output	sd_clk;
inout	sd_cmd;
inout	sd_dat;
inout	sd_dat3;

// 7segment LED
output [6:0]	hex0;	// L : on
output [6:0]	hex1;	// L : on
output [6:0]	hex2;	// L : on
output [6:0]	hex3;	// L : on

// LED
output [9:0]	ledr;	// H : on
output [7:0]	ledg;	// H : on

// Slide Switch
input [9:0]		sw;		// Down : L, Up : H

// Key Switch
input [3:0]		key;	// pressed : L, released : H

// GPIO
inout [35:0]	gpio0;
inout [35:0]	gpio1;

// JTAG interface
input	tck;
input	tcs;
input	tdi;
output	tdo;

//
// default signal definitions
//

// memory interface
// Flash
//assign	flash_data = 8'hzz;
assign	flash_rst = 1'b1;
//assign	flash_ce = 1'b1;
//assign	flash_oe = 1'b1;
//assign	flash_we = 1'b1;
// SRAM
//assign	sram_addr = 18'h00000;
//assign	sram_data = 16'hzzzz;
//assign	sram_ce = 1'b1;
//assign	sram_oe = 1'b1;
//assign	sram_we = 1'b1;
assign	sram_ub = 1'b1;
//assign	sram_lb = 1'b1;
// SDRAM
assign	dram_addr = 12'h000;
assign	dram_data = 16'hzzzz;
assign	dram_clk = 1'b0;
assign	dram_cke = 1'b0;
assign	dram_cs = 1'b1;
assign	dram_we = 1'b1;
assign	dram_ba0 = 1'b0;
assign	dram_ba1 = 1'b0;
assign	dram_ras = 1'b1;
assign	dram_cas = 1'b1;
assign	dram_udqm = 1'b0;
assign	dram_ldqm = 1'b0;

// PS/2 KB/Mouse interface
assign	ps2_clk = 1'b0;
assign	ps2_dat = 1'bz;

// UART interface
//assign	uart_txd = 1'b1;

// Audio Codec interface
assign	ac_mclk = 1'b0;
assign	ac_bclk = 1'b0;
assign	ac_adlrck = 1'b0;
assign	ac_dalrck = 1'b0;
assign	ac_dadat = 1'b0;
assign	i2c_sda = 1'bz;

// VGA interface
assign	vga_r = 4'h0;
assign	vga_g = 4'h0;
assign	vga_b = 4'h0;
assign	vga_hsync = 1'b1;
assign	vga_vsync = 1'b1;

// SD Card interface
assign	sd_clk = 1'b0;
assign	sd_cmd = 1'bz;
assign	sd_dat = 1'bz;

// 7segment LED
assign	hex0 = 7'b111_1111;	// L : on
assign	hex1 = 7'b111_1111;	// L : on
assign	hex2 = 7'b111_1111;	// L : on
assign	hex3 = 7'b111_1111;	// L : on

// LED
assign	ledr = 10'b00_0000_0000;	// H : on
//assign	ledg = 8'b0000_0000;	// H : on

// GPIO
assign	gpio0 = 36'hzzzzzzzzz;
assign	gpio1 = 36'hzzzzzzzzz;

// JTAG interface
assign	tdo = 1'b0;

wire	clk11;
wire	locked;
wire	async_rst;
reg	rst;
wire [15:0]	paddr;
wire [7:0]	prdata;
wire [7:0]	iaddr;
wire [7:0]	iwdata;
wire [7:0]	irdata;
wire	iwen;
wire [15:0]	xaddr;
wire [7:0]	xwdata;
wire [7:0]	xrdata;
wire	xwen;
wire [7:0]	p0_i;
wire [7:0]	p0_o;
wire [7:0]	p1_i;
wire [7:0]	p1_o;
wire [7:0]	p2_i;
wire [7:0]	p2_o;
wire [7:0]	p3_i;
wire [7:0]	p3_o;
wire [1:0]	eint_i;
wire [1:0]	tc_i;
wire	tc2_i;
wire	tc2_o;
wire	t2ex_i;
wire	rxd_i;
wire	rxd_o;
wire	txd;

reg [15:0]	paddr_d;

assign	async_rst = key[0] & locked;
assign	p0_i = 8'hff;
assign	p1_i = 8'hff;
assign	p2_i = 8'hff;
//assign	p3_i = 8'hff;
assign	p3_i = sw[7:0];
assign	eint_i = 2'b11;
assign	tc_i = 2'b11;
assign	tc2_i = 1'b1;
assign	t2ex_i = 1'b1;

assign	rxd_i = uart_rxd;
assign	uart_txd = txd;

assign	ledg = p3_o;

always @(posedge clk11) begin
	rst <= async_rst;
end


wire [7:0]	flash_wdata;
wire	flash_en;
wire	flash_wen;

assign	flash_addr = 22'h00_0000;
assign	flash_data = 8'hzz;
assign	flash_ce = 1'b1;
assign	flash_oe = 1'b1;
assign	flash_we = 1'b1;


wire [7:0]	sram_wdata;
wire	sram_en;
wire	sram_wen;

assign	sram_data = (sram_en & sram_wen & ~clk11) ? {8'h00, sram_wdata} : 16'hzzzz;
assign	sram_ce = 1'b0;
assign	sram_oe = ~(sram_en & ~sram_wen);
assign	sram_we = ~(sram_en & sram_wen & ~clk11);
assign	sram_lb = ~(sram_en);


pll11 pll11_0(
	.inclk0(clk27_0),
	.c0(clk11),
	.locked(locked)
);

ac51_top ac51_top0(
	.clk(clk11),
	.rst(rst),
	.paddr(paddr),
	.pen(pen),
	.prdata(prdata),
	.pack(pack),
	.iaddr(iaddr),
	.iwdata(iwdata),
	.irdata(irdata),
	.iwen(iwen),
	.xaddr(xaddr),
	.xen(xen),
	.xwdata(xwdata),
	.xrdata(xrdata),
	.xwen(xwen),
	.xack(xack),
	.p0_i(p0_i),
	.p0_o(p0_o),
	.p1_i(p1_i),
	.p1_o(p1_o),
	.p2_i(p2_i),
	.p2_o(p2_o),
	.p3_i(p3_i),
	.p3_o(p3_o),
	.eint_i(eint_i),
	.tc_i(tc_i),
	.tc2_i(tc2_i),
	.tc2_o(tc2_o),
	.t2ex_i(t2ex_i),
	.rxd_i(rxd_i),
	.rxd_o(rxd_o),
	.txd(txd)
);

wire [12:0]	pram_addr;
wire [7:0]	pram_wdata;
wire [7:0]	pram_data;
wire	pram_en;
wire	pram_wen;

xmem_mux xmem_mux0(
	.clk(clk11),
	.rst(rst),
	.paddr(paddr),
	.pen(pen),
	.prdata(prdata),
	.pack(pack),
	.xaddr(xaddr),
	.xen(xen),
	.xwdata(xwdata),
	.xrdata(xrdata),
	.xwen(xwen),
	.xack(xack),
	.sram_addr(sram_addr),
	.sram_wdata(sram_wdata),
	.sram_rdata(sram_data[7:0]),
	.sram_en(sram_en),
	.sram_wen(sram_wen),
	.pram_addr(pram_addr),
	.pram_wdata(pram_wdata),
	.pram_rdata(pram_data),
	.pram_en(pram_en),
	.pram_wen(pram_wen)
);

ssram iram0(
	.address(iaddr),
	.clock(clk11),
	.data(iwdata),
	.wren(iwen),
	.q(irdata)
);

pram pram0(
	.address(pram_addr),
	.clock(clk11),
	.data(pram_wdata),
	.wren(pram_wen),
	.q(pram_data)
);

endmodule

// End of cyc2.v
