//
// ac51_top.v
//
// ac51 microcontroller core
//
// Version 0.6
//
// Copyright 2008, Hideyuki Abe. All rights reserved.
// Distributed under the terms of the MIT License.
//

`include "ac51_defs.v"

module ac51_top(
	clk,
	rst,
	paddr,
	pen,
	prdata,
	pack,
	iaddr,
	iwdata,
	irdata,
	iwen,
	xaddr,
	xen,
	xwdata,
	xrdata,
	xwen,
	xack,
	p0_i,
	p0_o,
	p1_i,
	p1_o,
	p2_i,
	p2_o,
	p3_i,
	p3_o,
	eint_i,
	tc_i,
	tc2_i,
	tc2_o,
	t2ex_i,
	rxd_i,
	rxd_o,
	txd
);

input clk;
input rst;
output [15:0]	paddr;
output	pen;
input [7:0]	prdata;
input	pack;
output [7:0]	iaddr;
output [7:0]	iwdata;
input [7:0]	irdata;
output	iwen;
output [15:0]	xaddr;
output	xen;
output [7:0]	xwdata;
input [7:0]	xrdata;
output	xwen;
input	xack;
input [7:0]	p0_i;
output [7:0]	p0_o;
input [7:0]	p1_i;
output [7:0]	p1_o;
input [7:0]	p2_i;
output [7:0]	p2_o;
input [7:0]	p3_i;
output [7:0]	p3_o;
input [1:0]	eint_i;
input [1:0]	tc_i;
input	tc2_i;
output	tc2_o;
input	t2ex_i;
input	rxd_i;
output	rxd_o;
output	txd;

wire [15:0]	paddra;
wire	packa;
wire [7:0]	prdata_o;
wire [15:0]	pc_nxt;
wire [7:0]	inst1;
wire [7:0]	inst2;
wire [7:0]	inst3;

wire [15:0]	new_pc;

wire [15:0]	paddrb;
wire	penb;

wire [7:0]	iaddr;
wire [7:0]	iwdata;
wire [7:0]	irdata;
wire	iwen;

wire [15:0]	xaddr;
wire	xen;
wire [7:0]	xwdata;
wire [7:0]	xrdata;
wire	xwen;
wire	xack;

wire [7:0]	p0_i;
wire [7:0]	p0_o;
wire [7:0]	p1_i;
wire [7:0]	p1_o;
wire [7:0]	p2_i;
wire [7:0]	p2_o;
wire [7:0]	p3_i;
wire [7:0]	p3_o;

wire [1:0]	eint_i;
wire [1:0]	tc_i;

wire	rxd_i;
wire	rxd_o;
wire	txd;


ac51_pbus_mux pbus_mux0(
	.clk(clk),
	.rst(rst),
	.paddr(paddr),
	.pen(pen),
	.prdata_i(prdata),
	.pack(pack),
	.paddra(paddra),
	.pena(pena),
	.packa(packa),
	.paddrb(paddrb),
	.penb(penb),
	.packb(packb),
	.prdata_o(prdata_o)
);

ac51_fetch fetch0(
	.clk(clk),
	.rst(rst),
	.paddr(paddra),
	.pen(pena),
	.pack(packa),
	.prdata(prdata_o),
	.pc_nxt(pc_nxt),
	.inst1(inst1),
	.inst2(inst2),
	.inst3(inst3),
	.inst_rdy(inst_rdy),
	.inst_ack(inst_ack),
	.jmp_req(jmp_req),
	.jmp_ack(jmp_ack),
	.new_pc(new_pc)
);

ac51_exe exe0(
	.clk(clk),
	.rst(rst),
	.pc_nxt(pc_nxt),
	.inst1(inst1),
	.inst2(inst2),
	.inst3(inst3),
	.inst_rdy(inst_rdy),
	.inst_ack(inst_ack),
	.jmp_req(jmp_req),
	.jmp_ack(jmp_ack),
	.new_pc(new_pc),
	.iaddr(iaddr),
	.iwdata(iwdata),
	.irdata(irdata),
	.iwen(iwen),
	.paddr(paddrb),
	.pen(penb),
	.prdata(prdata_o),
	.pack(packb),
	.xaddr(xaddr),
	.xen(xen),
	.xwdata(xwdata),
	.xrdata(xrdata),
	.xwen(xwen),
	.xack(xack),
	.p0_i(p0_i),
	.p0_o(p0_o),
	.p1_i(p1_i),
	.p1_o(p1_o),
	.p2_i(p2_i),
	.p2_o(p2_o),
	.p3_i(p3_i),
	.p3_o(p3_o),
	.eint_i(eint_i),
	.tc_i(tc_i),
	.tc2_i(tc2_i),
	.tc2_o(tc2_o),
	.t2ex_i(t2ex_i),
	.rxd_i(rxd_i),
	.rxd_o(rxd_o),
	.txd(txd)
);

endmodule

// End of ac51_top.v
