//
// ac51_port.v
//
// ac51 microcontroller core
//
// Version 0.6
//
// Copyright 2008, Hideyuki Abe. All rights reserved.
// Distributed under the terms of the MIT License.
//

module ac51_port(
	clk,
	rst,
	ioaddr,
	iowdata,
	iordata,
	iormw,
	iowen,
	port_i,
	port_o
);

parameter	PORT_ADDR = 7'h00;

input	clk;
input	rst;
input [6:0]	ioaddr;
input [7:0]	iowdata;
output [7:0]	iordata;
input	iormw;
input	iowen;
input [7:0]	port_i;
output [7:0]	port_o;

reg [6:0]	ioaddr_d;
reg	iormw_d;

reg [7:0]	port_o;

wire	port_i_enb;
wire	port_o_enb;

always @(posedge clk or negedge rst) begin
	if(~rst)
		port_o <= 8'hff;
	else if((ioaddr == PORT_ADDR) & iowen)
		port_o <= iowdata;
end	// always

always @(posedge clk or negedge rst) begin
	if(~rst) begin
		ioaddr_d <= 7'h00;
		iormw_d <= 1'b0;
	end
	else begin
		ioaddr_d <= ioaddr;
		iormw_d <= iormw;
	end
end	// always

assign	port_i_enb = ((ioaddr_d == PORT_ADDR) & ~iormw_d);
assign	port_o_enb = ((ioaddr_d == PORT_ADDR) & iormw_d);

assign	iordata = ({8{port_i_enb}} & port_i)
					| ({8{port_o_enb}} & port_o);

endmodule

// End of ac51_port.v
