//
// ac51_daa.v
//
// ac51 microcontroller core
//
// Version 0.6
//
// Copyright 2008, Hideyuki Abe. All rights reserved.
// Distributed under the terms of the MIT License.
//

module ac51_daa(
	in,
	cy_bit,
	ac_bit,
	out,
	new_cy
);

input [7:0]	in;
input	cy_bit;
input	ac_bit;
output [7:0]	out;
output	new_cy;

wire	vld_l;
wire	vld_h;
reg [7:0]	da_reg;


assign	vld_l = (in[3:0] <= 4'h9);
assign	vld_h = (in[7:4] <= 4'h9);

always @(vld_l or vld_h or cy_bit or ac_bit or in) begin
	if(cy_bit) begin
		if(ac_bit) begin
			da_reg = 8'h66;
		end
		else begin
			if(vld_l) da_reg = 8'h60;
			else da_reg = 8'h66;
		end
	end
	else begin
		if(ac_bit) begin
			if(vld_h) da_reg = 8'h06;
			else da_reg = 8'h66;
		end
		else begin
			if(vld_l) begin
				if(vld_h) da_reg = 8'h00;
				else da_reg = 8'h60;
			end
			else begin
				if(in[7:4] <= 4'h8) da_reg = 8'h06;
				else da_reg = 8'h66;
			end
		end
	end
end	// always

// result
assign	out = in + da_reg;

// carry
assign	new_cy = (da_reg[7:4] == 4'h6);

endmodule

// End of ac51_daa.v
