//
// ast09_mux.v
//
// Copyright 2008, Hideyuki Abe. All rights reserved.
// Distributed under the terms of the MIT License.
//

module ast09_mux(
	clk,
	rst,
	addr,
	en,
	wen,
	wdata,
	rdata,
	ram_addr,
	ram_en,
	ram_wen,
	ram_wdata,
	ram_rdata,
	rom0_addr,
	rom0_en,
	rom0_rdata,
	rom1_addr,
	rom1_en,
	rom1_rdata,
	acia_addr,
	acia_en,
	acia_wen,
	acia_wdata,
	acia_rdata
);

input	clk;
input	rst;
input [15:0]	addr;
input	en;
input	wen;
input [7:0]	wdata;
output [7:0]	rdata;
output [15:0]	ram_addr;
output	ram_en;
output	ram_wen;
output [7:0]	ram_wdata;
input [7:0]	ram_rdata;
output [10:0]	rom0_addr;
output	rom0_en;
input [7:0]	rom0_rdata;
output [10:0]	rom1_addr;
output	rom1_en;
input [7:0]	rom1_rdata;
output	acia_addr;
output	acia_en;
output	acia_wen;
output [7:0]	acia_wdata;
input [7:0]	acia_rdata;

reg [7:0]	rdata;

reg	ram_en_d;
reg [7:0]	ram_rdata_d;

reg	rom0_en_d;
reg	rom1_en_d;

wire	io_en;
wire	acia_en;
reg	acia_en_d;
reg [7:0]	acia_rdata_d;


assign	ram_addr = addr;
assign	ram_en = (en & ~rom0_en & ~rom1_en & ~io_en);
assign	ram_wen = ram_en & wen;
assign	ram_wdata = wdata;

always @(posedge clk or negedge rst) begin
	if(~rst)
		ram_en_d <= 1'b0;
	else
		ram_en_d <= ram_en;
end

always @(posedge clk or negedge rst) begin
	if(~rst)
		ram_rdata_d <= 8'h00;
	else if(ram_en)
		ram_rdata_d <= ram_rdata;
end

assign	rom0_addr = addr[10:0];
assign	rom1_addr = addr[10:0];
assign	rom0_en = (addr[15:11] == 5'b1111_1) & en;
assign	rom1_en = (addr[15:11] == 5'b1111_0) & en;

always @(posedge clk or negedge rst) begin
	if(~rst) begin
		rom0_en_d <= 1'b0;
		rom1_en_d <= 1'b0;
	end
	else begin
		rom0_en_d <= rom0_en;
		rom1_en_d <= rom1_en;
	end
end

assign	acia_addr = addr[0];
assign	io_en = (addr[15:12] == 4'b1110) & en;
assign	acia_en = (addr[11:1] == 11'b0000_0000_100) & io_en;
assign	acia_wen = acia_en & wen;
assign	acia_wdata = wdata;

always @(posedge clk or negedge rst) begin
	if(~rst)
		acia_en_d <= 1'b0;
	else
		acia_en_d <= acia_en;
end

always @(posedge clk or negedge rst) begin
	if(~rst)
		acia_rdata_d <= 8'h00;
	else if(acia_en)
		acia_rdata_d <= acia_rdata;
end

always @(
	ram_en_d or ram_rdata_d
	or rom0_en_d or rom1_en_d or rom0_rdata or rom1_rdata
	or acia_en_d or acia_rdata_d
) begin
	if(rom0_en_d)
		rdata = rom0_rdata;
	else if(rom1_en_d)
		rdata = rom1_rdata;
	else if(acia_en_d)
		rdata = acia_rdata_d;
	else if(ram_en_d)
		rdata = ram_rdata_d;
	else
		rdata = 8'h00;
end	// always comb

endmodule

// End of ast09_mux.v
