//
// adder4.v
//
// ac09 processor core
//
// Version 0.6
//
// Copyright 2008, Hideyuki Abe. All rights reserved.
// Distributed under the terms of the MIT License.
//

module adder4(
	ina,
	inb,
	cy_in,
	out,
	cy_out
);

input [3:0]	ina;
input [3:0]	inb;
input	cy_in;
output [3:0]	out;
output	cy_out;

reg [3:0]	out;
reg	cy_out;

always @(ina or inb or cy_in) begin
	{cy_out, out} = {1'b0, ina} + {1'b0, inb} + {4'h0, cy_in};
end	// always comb

endmodule

// End of adder4.v
