//
// ac09_tb_ast.v
//

module ac09_tb;

reg	clk;
reg	rst;

wire [15:0]	addr;
wire	en;
wire	wen;
wire [7:0]	wdata;
wire [7:0]	rdata;
reg	ack;
wire [15:0]	ram_addr;
wire	ram_en;
wire	ram_wen;
wire [7:0]	ram_wdata;
wire [7:0]	ram_rdata;
wire [7:0]	ram_data;
wire [10:0]	rom0_addr;
wire	rom0_en;
wire [7:0]	rom0_rdata;
wire [10:0]	rom1_addr;
wire	rom1_en;
wire [7:0]	rom1_rdata;
wire	acia_addr;
wire	acia_en;
wire	acia_wen;
wire [7:0]	acia_wdata;
wire [7:0]	acia_rdata;

wire	irq;
wire	fiq;
wire	nmi;


always begin
	#5	clk = ~clk;
end

initial begin
	clk = 1'b1;
	rst = 1'b0;
	#10	;
	#1	rst = 1'b1;
	#(10 * 8000)	;
	$finish;
end

ac09_top ac09_top0(
	.clk(clk),
	.rst(rst),
	.addr(addr),
	.en(en),
	.wen(wen),
	.wdata(wdata),
	.rdata(rdata),
	.ack(ack),
	.irq(irq),
	.fiq(fiq),
	.nmi(nmi)
);

always @(posedge clk or negedge rst) begin
	if(~rst)
		ack <= 1'b0;
	else
		ack <= en;
end

ast09_mux mux0(
	.clk(clk),
	.rst(rst),
	.addr(addr),
	.en(en),
	.wen(wen),
	.wdata(wdata),
	.rdata(rdata),
	.ram_addr(ram_addr),
	.ram_en(ram_en),
	.ram_wen(ram_wen),
	.ram_wdata(ram_wdata),
	.ram_rdata(ram_rdata),
	.rom0_addr(rom0_addr),
	.rom0_en(rom0_en),
	.rom0_rdata(rom0_rdata),
	.rom1_addr(rom1_addr),
	.rom1_en(rom1_en),
	.rom1_rdata(rom1_rdata),
	.acia_addr(acia_addr),
	.acia_en(acia_en),
	.acia_wen(acia_wen),
	.acia_rdata(acia_rdata),
	.acia_wdata(acia_wdata)
);

async_ram ram0(
	.addr(ram_addr),
	.data(ram_data),
	.ceb(~ram_en),
	.web(~ram_wen | clk),
	.oeb(ram_wen)
);

assign	ram_rdata = ram_data;
assign	ram_data = (ram_wen) ? ram_wdata : 8'hzz;

sync_ram #(11) rom0(
	.clk(clk),
	.addr(rom0_addr),
	.wdata(8'h00),
	.ceb(~rom0_en),
	.web(1'b1),
	.rdata(rom0_rdata)
);

assign	rom1_rdata = 8'h00;

acia #(16'h0001,16'h0000) acia0(
	.clk(clk),
	.rst(rst),
	.addr(acia_addr),
	.en(acia_en),
	.wen(acia_wen),
	.wdata(acia_wdata),
	.rdata(acia_rdata),
	.irq(acia_irq),
	.txd(txd),
	.rxd(rxd),
	.adiv_sel(2'b01)
);

assign	irq = 1'b0;
assign	fiq = 1'b0;
assign	nmi = 1'b0;

integer i;

initial begin
//	$readmemh("test.dat", ram0.mem);
//	$readmemh("ast09.dat", ram0.mem);
	$readmemh("assist09.dat", rom0.mem);
end

initial begin
	$dumpfile("ac09_tb.vcd");
	$dumpvars(0, ac09_tb);
end

reg	ioaddr;
reg	ioen;
reg	iowen;
reg [7:0]	iowdata;
wire [7:0]	iordata;
wire	ioren;
reg [7:0]	iordata_r;

initial begin
	ioaddr = 1'b0;
	ioen = 1'b0;
	iowen = 1'b0;
	iowdata = 8'h00;
	#10	;
	#1	;

	io_write(1'b0,{1'b1,2'b01,3'b101,2'b00});	// 8bit,no parity,1stopbit

	#(10 * 4307)	;
	io_write(1'b1,8'h52);	// TDR 'R'
	wt_iobit(1'b0,8'h02);	// wait TDRE
	io_write(1'b1,8'h0d);	// TDR
end

acia #(16'h0001,16'h0000) acia1(
	.clk(clk),
	.rst(rst),
	.addr(ioaddr),
	.en(ioen),
	.wen(iowen),
	.wdata(iowdata),
	.rdata(iordata),
	.irq(/*open*/),
	.txd(rxd),
	.rxd(txd),
	.adiv_sel(2'b01)
);

assign	ioren = ioen & ~wen;

always @(posedge clk or negedge rst) begin
	if(~rst)
		iordata_r <= 8'h00;
	else if(ioren)
		iordata_r <= iordata;
end

// io write task
task io_write;
	input	ioaddr_;
	input [7:0]	iodata_;
begin
	ioaddr = ioaddr_;
	iowdata = iodata_;
	ioen = 1'b1;
	iowen = 1'b1;
	#10	;
	ioen = 1'b0;
	iowen = 1'b0;
end
endtask

// io read task
task io_read;
	input	ioaddr_;
begin
	ioaddr = ioaddr_;
	ioen = 1'b1;
	iowen = 1'b0;
	#10	;
	ioen = 1'b0;
	iowen = 1'b0;
end
endtask

// check io data task
task chk_iodata;
	input [7:0]	iodata_;
	input [7:0]	mask_;
begin
	$display("chk_iodata : %h (mask %h)", iodata_, mask_);
	if((iordata_r & mask_) !== iodata_)
		$display("%t: error! actual iodata : %h", $time, iordata);
end
endtask

// wait io data bit
task wt_iobit;
	input	ioaddr_;
	input [7:0]	iodata_;
begin
	io_read(ioaddr_);
	while((iordata_r & iodata_) == 8'h00) io_read(ioaddr_);
end
endtask

endmodule

// End of ac09_tb_ast.v
