//
// ac09_exe_regfile.v
//
// ac09 processor core
//
// Version 0.6
//
// Copyright 2008, Hideyuki Abe. All rights reserved.
// Distributed under the terms of the MIT License.
//

`include "ac09_defs.v"

module ac09_exe_regfile(
	clk,
	rst,
	raddr,
	ren,
	rwen,
	rwdata,
	rrdata,
	dpr_o,
	accd_o,
	ccr_i,
	ccr_o,
	pc_i,
	pc_o,
	pc_wen,
	ibase_sel,
	ibase
);

input	clk;
input	rst;
input [`REG_LEN - 1:0]	raddr;
input	ren;
input	rwen;
input [15:0]	rwdata;
output [15:0]	rrdata;
output [7:0]	dpr_o;
output [15:0]	accd_o;
input [7:0]	ccr_i;
output [7:0]	ccr_o;
input [15:0]	pc_i;
output [15:0]	pc_o;
output	pc_wen;
input [1:0]	ibase_sel;
output [15:0]	ibase;

reg [`REG_LEN - 1:0]	raddr_d;
reg [15:0]	rrdata;

reg [15:0]	ibase;

wire	dpr_wen;
reg [7:0]	dpr;

wire	ccr_wen;
reg [7:0]	ccr_o;

wire	acca_wen;
wire	accb_wen;
wire	accd_wen;
reg	[15:0]	accd;

wire	ix_wen;
reg [15:0]	ix;

wire	iy_wen;
reg [15:0]	iy;

wire	ssp_wen;
reg [15:0]	ssp;

wire	usp_wen;
reg [15:0]	usp;

wire	pc_wen;
reg [15:0]	pc_o;


assign	dpr_wen = (raddr == `REG_DPR) & ren & rwen;

always @(posedge clk or negedge rst) begin
	if(~rst)
		dpr <= 8'h00;
	else if(dpr_wen)
		dpr <= rwdata[7:0];
end

assign	dpr_o = dpr_wen ? rwdata[7:0] : dpr;

assign	ccr_wen = (raddr == `REG_CCR) & ren & rwen;

always @(ccr_wen or rwdata or ccr_i) begin
	if(ccr_wen)
		ccr_o = rwdata[7:0];
	else
		ccr_o = ccr_i;
end	// always comb

assign	acca_wen = (raddr == `REG_ACCA) & ren & rwen;
assign	accb_wen = (raddr == `REG_ACCB) & ren & rwen;
assign	accd_wen = (raddr == `REG_ACCD) & ren & rwen;

always @(posedge clk or negedge rst) begin
	if(~rst)
		accd <= 16'h0000;
	else if(accd_wen)
		accd <= rwdata;
	else if(acca_wen)
		accd[15:8] <= rwdata[7:0];
	else if(accb_wen)
		accd[7:0] <= rwdata[7:0];
end

assign	accd_o = accd;

assign	ix_wen = (raddr == `REG_IX) & ren & rwen;

always @(posedge clk or negedge rst) begin
	if(~rst)
		ix <= 16'h0000;
	else if(ix_wen)
		ix <= rwdata;
end

assign	iy_wen = (raddr == `REG_IY) & ren & rwen;

always @(posedge clk or negedge rst) begin
	if(~rst)
		iy <= 16'h0000;
	else if(iy_wen)
		iy <= rwdata;
end

assign	ssp_wen = (raddr == `REG_SSP) & ren & rwen;

always @(posedge clk or negedge rst) begin
	if(~rst)
		ssp <= 16'h0000;
	else if(ssp_wen)
		ssp <= rwdata;
end

assign	usp_wen = (raddr == `REG_USP) & ren & rwen;

always @(posedge clk or negedge rst) begin
	if(~rst)
		usp <= 16'h0000;
	else if(usp_wen)
		usp <= rwdata;
end

assign	pc_wen = (raddr == `REG_PC) & ren & rwen;

always @(posedge clk or negedge rst) begin
	if(~rst)
		pc_o <= 16'h0000;
	else if(pc_wen)
		pc_o <= rwdata;
end

always @(posedge clk or negedge rst) begin
	if(~rst)
		raddr_d <= `REG_ACCD;
	else
		raddr_d <= raddr;
end

always @(
	raddr_d or dpr or ccr_i or accd
	or ix or iy or ssp or usp or pc_i
) begin
	case(raddr_d)
	`REG_DPR:
		rrdata = dpr;
	`REG_CCR:
		rrdata = ccr_i;
	`REG_ACCA:
		rrdata = accd[15:8];
	`REG_ACCB:
		rrdata = accd[7:0];
	`REG_ACCD:
		rrdata = accd;
	`REG_IX:
		rrdata = ix;
	`REG_IY:
		rrdata = iy;
	`REG_SSP:
		rrdata = ssp;
	`REG_USP:
		rrdata = usp;
	`REG_PC:
		rrdata = pc_i;
	default:
		rrdata = 16'h0000;
	endcase
end	// always comb

always @(
	ibase_sel or ix or iy or ssp or usp
) begin
	case(ibase_sel)
	2'b00:		// IX
		ibase = ix;
	2'b01:		// IY
		ibase = iy;
	2'b10:		// USP
		ibase = usp;
	default:	// 2'b11 SSP
		ibase = ssp;
	endcase
end	// always comb

endmodule

// End of ac09_exe_regfile.v
