//
// ac09_core.v
//
// ac09 processor core
//
// Version 0.6
//
// Copyright 2008, Hideyuki Abe. All rights reserved.
// Distributed under the terms of the MIT License.
//

`include "ac09_defs.v"

module ac09_core(
	clk,
	rst,
	paddr,
	pen,
	prdata,
	pack,
	daddr,
	den,
	dwen,
	dwdata,
	drdata,
	dack,
	irq,
	fiq,
	nmi
);

input	clk;
input	rst;
output [15:0]	paddr;
output	pen;
input [7:0]	prdata;
input	pack;
output [15:0]	daddr;
output	den;
output	dwen;
output [7:0]	dwdata;
input [7:0]	drdata;
input	dack;
input	irq;
input	fiq;
input	nmi;

wire	inst_rdy;
wire	inst_ack;
wire [15:0]	pc_nxt;
wire	jmp_req;
wire	jmp_ack;
wire [15:0]	new_pc;

wire [`OPC_LEN - 1:0]	opcode;
wire [`ALUOP_LEN - 1:0]	main_opr;
wire [3:0]	cond;
wire [`REG_LEN - 1:0]	opreg;
wire [`AMODE_LEN - 1:0]	amode;
wire [7:0]	postbyte;
wire [15:0]	oprnd;


ac09_fetch fetch0(
	.clk(clk),
	.rst(rst),
	.inst_rdy(inst_rdy),
	.inst_ack(inst_ack),
	.pc_nxt(pc_nxt),
	.jmp_req(jmp_req),
	.jmp_ack(jmp_ack),
	.new_pc(new_pc),
	.opcode(opcode),
	.main_opr(main_opr),
	.cond(cond),
	.opreg(opreg),
	.amode(amode),
	.postbyte(postbyte),
	.oprnd(oprnd),
	.calc_ea(calc_ea),
	.paddr(paddr),
	.pen(pen),
	.prdata(prdata),
	.pack(pack)
);

ac09_exe exe0(
	.clk(clk),
	.rst(rst),
	.inst_rdy(inst_rdy),
	.inst_ack(inst_ack),
	.pc(pc_nxt),
	.jmp_req(jmp_req),
	.jmp_ack(jmp_ack),
	.new_pc(new_pc),
	.opcode(opcode),
	.main_opr(main_opr),
	.cond(cond),
	.opreg(opreg),
	.amode(amode),
	.postbyte(postbyte),
	.oprnd(oprnd),
	.calc_ea(calc_ea),
	.daddr(daddr),
	.den(den),
	.dwen(dwen),
	.dwdata(dwdata),
	.drdata(drdata),
	.dack(dack),
	.irq(irq),
	.fiq(fiq),
	.nmi(nmi)
);

endmodule

// End of ac09_core.v
