//
// vidgen400.v
//
// for 25.2MHz
//
// Copyright 2008, Hideyuki Abe. All rights reserved.
// Distributed under the terms of the MIT License.
//

`define	VID_XMAX	10'd799
`define	VID_YMAX	9'd448
`define	VID_HSSTART	10'd655
`define	VID_HSEND	10'd751
`define	VID_VSSTART	9'd411
`define	VID_VSEND	9'd413

module vidgen400(
	clk,
	rst,
	xcnt,
	ycnt,
	r_in,
	g_in,
	b_in,
	r_out,
	g_out,
	b_out,
	hblnk,
	vblnk,
	hsync,
	vsync
);

input	clk;
input	rst;
output [9:0]	xcnt;
output [8:0]	ycnt;
input [3:0]	r_in;
input [3:0]	g_in;
input [3:0]	b_in;
output [3:0]	r_out;
output [3:0]	g_out;
output [3:0]	b_out;
output	hblnk;
output	vblnk;
output	hsync;
output	vsync;

reg [9:0]	xcnt;
reg [8:0]	ycnt;
reg [3:0]	r_out;
reg [3:0]	g_out;
reg [3:0]	b_out;
wire	hblnk;
wire	vblnk;
reg	hblnk_d;
reg	vblnk_d;
reg	hblnk_dd;
reg	vblnk_dd;
reg	hsync_ppp;
reg	vsync_ppp;
reg	hsync_pp;
reg	vsync_pp;
reg	hsync_p;
reg	vsync_p;
reg	hsync;
reg	vsync;


always @(posedge clk or negedge rst) begin
	if(~rst)
		xcnt <= 10'h000;
	else if(xcnt == `VID_XMAX)
		xcnt <= 10'h000;
	else
		xcnt <= xcnt + 10'h001;
end

always @(posedge clk or negedge rst) begin
	if(~rst) begin
		ycnt <= 9'h000;
	end
	else if(xcnt == `VID_XMAX) begin
		if(ycnt == `VID_YMAX)
			ycnt <= 9'h000;
		else
			ycnt <= ycnt + 9'h001;
	end
end

assign	hblnk = (xcnt >= 10'd640);
//assign	vblnk = (ycnt >= 9'd400);
assign	vblnk = (ycnt >= 9'd384);

always @(posedge clk or negedge rst) begin
	if(~rst) begin
		hblnk_d <= 1'b0;
		hblnk_dd <= 1'b0;
		vblnk_d <= 1'b0;
		vblnk_dd <= 1'b0;
	end
	else begin
		hblnk_d <= hblnk;
		hblnk_dd <= hblnk_d;
		vblnk_d <= vblnk;
		vblnk_dd <= vblnk_d;
	end
end

always @(posedge clk or negedge rst) begin
	if(~rst) begin
		r_out <= 4'b0000;
		g_out <= 4'b0000;
		b_out <= 4'b0000;
	end
	else if((~hblnk_dd) & (~vblnk_dd)) begin
		r_out <= r_in;
		g_out <= g_in;
		b_out <= b_in;
	end
	else begin
		r_out <= 4'b0000;
		g_out <= 4'b0000;
		b_out <= 4'b0000;
	end
end

always @(xcnt or hsync_pp) begin
	if(xcnt == `VID_HSSTART)
		hsync_ppp = 1'b0;
	else if(xcnt == `VID_HSEND)
		hsync_ppp = 1'b1;
	else
		hsync_ppp = hsync_pp;
end	// always comb

always @(ycnt or vsync_pp) begin
	if(ycnt == `VID_VSSTART)
		vsync_ppp = 1'b0;
	else if(ycnt == `VID_VSEND)
		vsync_ppp = 1'b1;
	else
		vsync_ppp = vsync_pp;
end	// always comb

always @(posedge clk or negedge rst) begin
	if(~rst) begin
		hsync_pp <= 1'b1;
		hsync_p <= 1'b1;
		hsync <= 1'b1;
		vsync_pp <= 1'b1;
		vsync_p <= 1'b1;
		vsync <= 1'b1;
	end
	else begin
		hsync_pp <= hsync_ppp;
		hsync_p <= hsync_pp;
		hsync <= hsync_p;
		vsync_pp <= vsync_ppp;
		vsync_p <= vsync_pp;
		vsync <= vsync_p;
	end
end

endmodule

// End of vidgen400.v
