//
// ps2.v
//
// last modified on 080919
//
// Copyright 2008, Hideyuki Abe. All rights reserved.
// Distributed under the terms of the MIT License.
//

module ps2(
	clk,
	rst,
	rcv_dat,
	rcv_full,
	rcv_ack,
	scl_i,
	sda_i
);

parameter	PS2_RLD = 12'h13b;

input	clk;
input	rst;
output [9:0]	rcv_dat;
output	rcv_full;
input	rcv_ack;
input	scl_i;
input	sda_i;

reg [11:0]	brg_cntr;
wire	sclk;
reg	rcv_full;
reg	scl_d;
wire	scl_fall;
reg	receiving;
reg [3:0]	rcv_cntr;
reg [3:0]	rcv_cntr_nxt;
reg [10:0]	rshft_reg;
reg [10:0]	rshft_reg_nxt;
wire	frm_ok;
wire	rparity_ok;
reg	rcv_reg_load;
wire	rcv_exdat;
reg [9:0]	rcv_dat;


always @(posedge clk or negedge rst) begin
	if(~rst)
		brg_cntr <= PS2_RLD;
	else if(brg_cntr == 12'h000)
		brg_cntr <= PS2_RLD;
	else
		brg_cntr <= brg_cntr - 12'h001;
end

assign	sclk = (brg_cntr == 12'h000);

always @(posedge clk or negedge rst) begin
	if(~rst)
		rcv_full <= 1'b0;
	else if(rcv_reg_load & ~rcv_exdat)
		rcv_full <= 1'b1;
	else if(rcv_ack)
		rcv_full <= 1'b0;
end

always @(posedge clk or negedge rst) begin
	if(~rst)
		scl_d <= 1'b1;
	else if(sclk)
		scl_d <= scl_i;
end

assign	scl_fall = scl_d & ~scl_i & sclk;

always @(posedge clk or negedge rst) begin
	if(~rst)
		receiving <= 1'b0;
	else if(scl_fall)
		receiving <= 1'b1;
	else if(rcv_reg_load & ~rcv_exdat)
		receiving <= 1'b0;
end

always @(posedge clk or negedge rst) begin
	if(~rst)
		rcv_cntr <= 4'd0;
	else
		rcv_cntr <= rcv_cntr_nxt;
end

always @(rcv_cntr or scl_fall or receiving) begin
	if(scl_fall & rcv_cntr == 4'd0)
		rcv_cntr_nxt = 4'd10;
	else if(rcv_cntr == 4'd0)
		rcv_cntr_nxt = rcv_cntr;
	else if(scl_fall)
		rcv_cntr_nxt = rcv_cntr - 4'd1;
	else
		rcv_cntr_nxt = rcv_cntr;
end	// always comb

always @(posedge clk or negedge rst) begin
	if(~rst)
		rshft_reg <= 11'h7ff;
	else
		rshft_reg <= rshft_reg_nxt;
end

always @(rshft_reg or rcv_cntr or scl_fall or sda_i) begin
	if((rcv_cntr != 4'd0) & scl_fall)
		rshft_reg_nxt = {sda_i,rshft_reg[10:1]};
	else
		rshft_reg_nxt = rshft_reg;
end

assign	frm_ok = rshft_reg_nxt[10] & ~(rshft_reg_nxt[0]);
assign	rparity_ok = ^rshft_reg_nxt[9:1];
assign	rcv_exdat = (rshft_reg_nxt[8:1] == 8'he0) | (rshft_reg_nxt[8:1] == 8'hf0);

always @(receiving or scl_fall or rcv_cntr) begin
	if(receiving) begin
		if(scl_fall & (rcv_cntr == 4'd1))
			rcv_reg_load = 1'b1;
		else
			rcv_reg_load = 1'b0;
	end
	else begin
		rcv_reg_load = 1'b0;
	end
end	// always comb

always @(posedge clk or negedge rst) begin
	if(~rst) begin
		rcv_dat <= 10'h000;
	end
	else if(rcv_ack) begin
		rcv_dat <= 10'h000;
	end
	else if(rcv_reg_load) begin
		if(rshft_reg_nxt[8:1] == 8'he0)			// key code extension
			rcv_dat <= {rcv_dat[9],1'b1,rcv_dat[7:0]};
		else if(rshft_reg_nxt[8:1] == 8'hf0)	// key break
			rcv_dat <= {1'b1,rcv_dat[8:0]};
		else
			rcv_dat <= {rcv_dat[9:8],rshft_reg_nxt[8:1]};
	end
end

endmodule

// End of ps2.v
