//
// ns_filt.v
//
// for 12.6MHz
//
// Copyright 2008, Hideyuki Abe. All rights reserved.
// Distributed under the terms of the MIT License.
//

module ns_filt(
	clk,
	rst,
	in,
	out
);

parameter	NSFLT_INI = 1'b1;
parameter	NSFLT_RLD = 16'd12599;

input	clk;
input	rst;
input	in;
output	out;

reg [15:0]	smp_cntr;
wire	smp_tim;
reg [15:0]	smp_data;
reg [15:0]	smp_data_nxt;
reg	out;


always @(posedge clk or negedge rst) begin
	if(~rst)
		smp_cntr <= NSFLT_RLD;
	else if(smp_cntr == 16'h0000)
		smp_cntr <= NSFLT_RLD;
	else
		smp_cntr <= smp_cntr - 16'h0001;
end

assign	smp_tim = (smp_cntr == 16'h0000);

always @(posedge clk or negedge rst) begin
	if(~rst)
		smp_data <= {16{NSFLT_INI}};
	else
		smp_data <= smp_data_nxt;
end

always @(smp_data or smp_tim or in) begin
	if(smp_tim)
		smp_data_nxt = {smp_data[14:0],in};
	else
		smp_data_nxt = smp_data;
end	// always comb

always @(posedge clk or negedge rst) begin
	if(~rst)
		out <= NSFLT_INI;
	else if((~out) & (smp_data_nxt == 16'h7fff))
		out <= 1'b1;
	else if(out & (smp_data_nxt == 16'h8000))
		out <= 1'b0;
end

endmodule

// End of ns_filt.v
