//
// kbd2chr.v
//
// Copyright 2008, Hideyuki Abe. All rights reserved.
// Distributed under the terms of the MIT License.
//

//`define	USE_JP106

module kbd2chr(
	clk,
	rst,
	rcv_dat,
	rcv_full,
	rcv_ack,
	keystb,
	keydata
);

input	clk;
input	rst;
input [9:0]	rcv_dat;
input	rcv_full;
output	rcv_ack;
output	keystb;
output [6:0]	keydata;

reg	keystb;
reg [6:0]	keydata;
reg [6:0]	keydata_nxt;
reg	shft_md;
reg	shft_md_nxt;


assign	rcv_ack = rcv_full;

always @(posedge clk or negedge rst) begin
	if(~rst) begin
		keydata <= 7'h00;
		shft_md <= 1'b0;
	end
	else begin
		keydata <= keydata_nxt;
		shft_md <= shft_md_nxt;
	end
end

always @(rcv_full or rcv_dat or keydata or shft_md) begin
	keystb = 1'b1;
	keydata_nxt = keydata;
	shft_md_nxt = shft_md;

	if(rcv_full) begin
		if(rcv_dat[9]) begin	// break
			case(rcv_dat[8:0])
			9'h012,9'h059:	// shift
				shft_md_nxt = 1'b0;
			endcase
		end
		else begin				// make
			keystb = 1'b0;
			keydata_nxt = 7'h00;
			case(rcv_dat[8:0])
			9'h012,9'h059: begin	// shift
				keystb = 1'b1;	// not active
				shft_md_nxt = 1'b1;
			end
			9'h01c:	keydata_nxt = 7'h41;	// A
			9'h032:	keydata_nxt = 7'h42;	// B
			9'h021:	keydata_nxt = 7'h43;	// C
			9'h023:	keydata_nxt = 7'h44;	// D
			9'h024:	keydata_nxt = 7'h45;	// E
			9'h02b:	keydata_nxt = 7'h46;	// F
			9'h034:	keydata_nxt = 7'h47;	// G
			9'h033:	keydata_nxt = 7'h48;	// H
			9'h043:	keydata_nxt = 7'h49;	// I
			9'h03b:	keydata_nxt = 7'h4a;	// J
			9'h042:	keydata_nxt = 7'h4b;	// K
			9'h04b:	keydata_nxt = 7'h4c;	// L
			9'h03a:	keydata_nxt = 7'h4d;	// M
			9'h031:	keydata_nxt = 7'h4e;	// N
			9'h044:	keydata_nxt = 7'h4f;	// O
			9'h04d:	keydata_nxt = 7'h50;	// P
			9'h015:	keydata_nxt = 7'h51;	// Q
			9'h02d:	keydata_nxt = 7'h52;	// R
			9'h01b:	keydata_nxt = 7'h53;	// S
			9'h02c:	keydata_nxt = 7'h54;	// T
			9'h03c:	keydata_nxt = 7'h55;	// U
			9'h02a:	keydata_nxt = 7'h56;	// V
			9'h01d:	keydata_nxt = 7'h57;	// W
			9'h022:	keydata_nxt = 7'h58;	// X
			9'h035:	keydata_nxt = 7'h59;	// Y
			9'h01a:	keydata_nxt = 7'h5a;	// Z
			9'h029:	keydata_nxt = 7'h20;	// SPACE
			9'h05a:	keydata_nxt = 7'h0d;	// RET
			9'h041:
				if(shft_md) keydata_nxt = 7'h3c;
				else keydata_nxt = 7'h2c;	// ,<
			9'h049:
				if(shft_md) keydata_nxt = 7'h3e;
				else keydata_nxt = 7'h2e;	// .>
			9'h04a:
				if(shft_md) keydata_nxt = 7'h3f;
				else keydata_nxt = 7'h2f;	// /?
			9'h076:	keydata_nxt = 7'h1b;	// ESC
			9'h066:	keydata_nxt = 7'h5f;	// BS
`ifdef	USE_JP106
			// jp106 type keyboard
			9'h016:
				if(shft_md) keydata_nxt = 7'h21;
				else keydata_nxt = 7'h31;	// 1!
			9'h01e:
				if(shft_md) keydata_nxt = 7'h22;
				else keydata_nxt = 7'h32;	// 2"
			9'h026:
				if(shft_md) keydata_nxt = 7'h23;
				else keydata_nxt = 7'h33;	// 3#
			9'h025:
				if(shft_md) keydata_nxt = 7'h24;
				else keydata_nxt = 7'h34;	// 4$
			9'h02e:
				if(shft_md) keydata_nxt = 7'h25;
				else keydata_nxt = 7'h35;	// 5%
			9'h036:
				if(shft_md) keydata_nxt = 7'h26;
				else keydata_nxt = 7'h36;	// 6&
			9'h03d:
				if(shft_md) keydata_nxt = 7'h27;
				else keydata_nxt = 7'h37;	// 7'
			9'h03e:
				if(shft_md) keydata_nxt = 7'h29;
				else keydata_nxt = 7'h38;	// 8(
			9'h046:
				if(shft_md) keydata_nxt = 7'h29;
				else keydata_nxt = 7'h39;	// 9)
			9'h045:	keydata_nxt = 7'h30;	// 0
			9'h04e:
				if(shft_md) keydata_nxt = 7'h3d;
				else keydata_nxt = 7'h2d;	// -=
			9'h055:	keydata_nxt = 7'h5e;	// ^
			9'h06a:	keydata_nxt = 7'h5c;	// \
			9'h054:	keydata_nxt = 7'h40;	// @
			9'h05b:	keydata_nxt = 7'h5b;	// [
			9'h04c:
				if(shft_md) keydata_nxt = 7'h2b;
				else keydata_nxt = 7'h3b;	// ;+
			9'h052:
				if(shft_md) keydata_nxt = 7'h2a;
				else keydata_nxt = 7'h3a;	// :*
			9'h05d:	keydata_nxt = 7'h5d;	// ]
			9'h04a:
				if(shft_md) keydata_nxt = 7'h3f;
				else keydata_nxt = 7'h2f;	// /?
			9'h051:
				if(shft_md) keydata_nxt = 7'h5f;
				else keydata_nxt = 7'h5c;	// \_
`else	// USE_JP106
			// 101 type keyboard
			9'h016:
				if(shft_md) keydata_nxt = 7'h21;
				else keydata_nxt = 7'h31;	// 1!
			9'h01e:
				if(shft_md) keydata_nxt = 7'h40;
				else keydata_nxt = 7'h32;	// 2@
			9'h026:
				if(shft_md) keydata_nxt = 7'h23;
				else keydata_nxt = 7'h33;	// 3#
			9'h025:
				if(shft_md) keydata_nxt = 7'h24;
				else keydata_nxt = 7'h34;	// 4$
			9'h02e:
				if(shft_md) keydata_nxt = 7'h25;
				else keydata_nxt = 7'h35;	// 5%
			9'h036:
				if(shft_md) keydata_nxt = 7'h5e;
				else keydata_nxt = 7'h36;	// 6^
			9'h03d:
				if(shft_md) keydata_nxt = 7'h26;
				else keydata_nxt = 7'h37;	// 7&
			9'h03e:
				if(shft_md) keydata_nxt = 7'h2a;
				else keydata_nxt = 7'h38;	// 8*
			9'h046:
				if(shft_md) keydata_nxt = 7'h28;
				else keydata_nxt = 7'h39;	// 9(
			9'h045:
				if(shft_md) keydata_nxt = 7'h29;
				else keydata_nxt = 7'h30;	// 0)
			9'h04e:
				if(shft_md) keydata_nxt = 7'h5f;
				else keydata_nxt = 7'h2d;	// -_
			9'h055:
				if(shft_md) keydata_nxt = 7'h3d;
				else keydata_nxt = 7'h2b;	// +=
			9'h05d:	keydata_nxt = 7'h5c;	// \
			9'h054:	keydata_nxt = 7'h5b;	// [
			9'h05b:	keydata_nxt = 7'h5d;	// ]
			9'h04c:
				if(shft_md) keydata_nxt = 7'h3b;
				else keydata_nxt = 7'h3a;	// :;
			9'h052:
				if(shft_md) keydata_nxt = 7'h27;
				else keydata_nxt = 7'h22;	// "'
`endif	// USE_JP106
			default:
				keystb = 1'b1;	// not active
			endcase
		end
	end
end

endmodule

// End of kbd2chr.v
