//
// cyc2.v
//
// cycloneII for Terasic DE1
//

module cyc2(
	clk24_0,
	clk24_1,
	clk27_0,
	clk27_1,
	clk50,
	ext_clk,
	flash_addr,
	flash_data,
	flash_rst,
	flash_ce,
	flash_oe,
	flash_we,
	sram_addr,
	sram_data,
	sram_ce,
	sram_oe,
	sram_we,
	sram_ub,
	sram_lb,
	dram_addr,
	dram_data,
	dram_clk,
	dram_cke,
	dram_cs,
	dram_we,
	dram_ba1,
	dram_ba0,
	dram_ras,
	dram_cas,
	dram_udqm,
	dram_ldqm,
	ps2_clk,
	ps2_dat,
	uart_txd,
	uart_rxd,
	ac_mclk,
	ac_bclk,
	ac_adlrck,
	ac_addat,
	ac_dalrck,
	ac_dadat,
	i2c_scl,
	i2c_sda,
	vga_r,
	vga_g,
	vga_b,
	vga_hsync,
	vga_vsync,
	sd_clk,
	sd_cmd,
	sd_dat,
	sd_dat3,
	hex0,
	hex1,
	hex2,
	hex3,
	ledr,
	ledg,
	sw,
	key,
	gpio0,
	gpio1,
	tck,
	tcs,
	tdi,
	tdo
);

// clock
input	clk24_0;	// 24MHz from USB Blaster
input	clk24_1;	// 24MHz from USB Blaster
input	clk27_0;	// 27MHz
input	clk27_1;	// 27MHz
input	clk50;	// 50MHz
input	ext_clk;	// external clock

// memory interface
// Flash
output [21:0]	flash_addr;
inout [7:0]		flash_data;
output	flash_rst;
output	flash_ce;
output	flash_oe;
output	flash_we;
// SRAM
output [17:0]	sram_addr;
inout [15:0]	sram_data;
output	sram_ce;
output	sram_oe;
output	sram_we;
output	sram_ub;
output	sram_lb;
// SDRAM
output [11:0]	dram_addr;
inout [15:0]	dram_data;
output	dram_clk;
output	dram_cke;
output	dram_cs;
output	dram_we;
output	dram_ba1;
output	dram_ba0;
output	dram_ras;
output	dram_cas;
output	dram_udqm;
output	dram_ldqm;

// PS/2 KB/Mouse interface
//output	ps2_clk;
//inout	ps2_dat;
input	ps2_clk;
input	ps2_dat;

// UART interface
output	uart_txd;
input	uart_rxd;

// Audio Codec interface
output	ac_mclk;	// master clock
output	ac_bclk;	// bit clock (inout ???)
output	ac_adlrck;
input	ac_addat;
output	ac_dalrck;
output	ac_dadat;
output	i2c_scl;
inout	i2c_sda;

// VGA interface
output [3:0]	vga_r;
output [3:0]	vga_g;
output [3:0]	vga_b;
output	vga_hsync;
output	vga_vsync;

// SD Card interface
output	sd_clk;
inout	sd_cmd;
inout	sd_dat;
inout	sd_dat3;

// 7segment LED
output [6:0]	hex0;	// L : on
output [6:0]	hex1;	// L : on
output [6:0]	hex2;	// L : on
output [6:0]	hex3;	// L : on

// LED
output [9:0]	ledr;	// H : on
output [7:0]	ledg;	// H : on

// Slide Switch
input [9:0]		sw;		// Down : L, Up : H

// Key Switch
input [3:0]		key;	// pressed : L, released : H

// GPIO
inout [35:0]	gpio0;
inout [35:0]	gpio1;

// JTAG interface
input	tck;
input	tcs;
input	tdi;
output	tdo;

//
// default signal definitions
//

// memory interface
// Flash
assign	flash_addr = 22'h00_0000;
assign	flash_data = 8'hzz;
assign	flash_rst = 1'b1;
assign	flash_ce = 1'b1;
assign	flash_oe = 1'b1;
assign	flash_we = 1'b1;
// SRAM
//assign	sram_addr = 18'h0_0000;
//assign	sram_data = 16'hzzzz;
//assign	sram_ce = 1'b1;
//assign	sram_oe = 1'b1;
//assign	sram_we = 1'b1;
//assign	sram_ub = 1'b1;
//assign	sram_lb = 1'b1;
// SDRAM
assign	dram_clk = 1'b0;
assign	dram_cke = 1'b0;
assign	dram_addr = 12'h000;
assign	dram_data = 16'hzzzz;
assign	dram_cs = 1'b1;
assign	dram_we = 1'b1;
assign	dram_ras = 1'b1;
assign	dram_cas = 1'b1;
assign	dram_ba0 = 1'b0;
assign	dram_ba1 = 1'b0;
assign	dram_udqm = 1'b0;
assign	dram_ldqm = 1'b0;

// PS/2 KB/Mouse interface
//assign	ps2_clk = 1'b1;
//assign	ps2_dat = 1'bz;

// UART interface
assign	uart_txd = 1'b1;

// Audio Codec interface
assign	ac_mclk = 1'b1;
assign	ac_bclk = 1'b1;
assign	ac_adlrck = 1'b1;
assign	ac_dalrck = 1'b1;
assign	ac_dadat = 1'b1;
assign	i2c_scl = 1'b1;
assign	i2c_sda = 1'bz;

// VGA interface
//assign	vga_r = 4'b0000;
//assign	vga_g = 4'b0000;
//assign	vga_b = 4'b0000;
//assign	vga_hsync = 1'b1;
//assign	vga_vsync = 1'b1;

// SD Card interface
assign	sd_clk = 1'b1;
assign	sd_cmd = 1'bz;
assign	sd_dat = 1'bz;

// 7segment LED
assign	hex0 = 7'b111_1111;	// L : on
assign	hex1 = 7'b111_1111;	// L : on
assign	hex2 = 7'b111_1111;	// L : on
assign	hex3 = 7'b111_1111;	// L : on

// LED
assign	ledr = 10'b00_0000_0000;	// H : on
assign	ledg = 8'b0000_0000;	// H : on

// GPIO
assign	gpio0 = 36'hzzzzzzzzz;
assign	gpio1 = 36'hzzzzzzzzz;

// JTAG interface
assign	tdo = 1'b1;


wire	clk2;
wire	clk;
wire	locked;
wire	async_rst;
reg	rst;

wire	irq;
wire	nmi;

wire [15:0]	addr;
wire [7:0]	wdata;
wire [7:0]	rdata;
wire	en;
wire	wen;
reg	ack;

wire [10:0]	rom_addr;
wire	rom_en;
wire [7:0]	rom_rdata;

wire [15:0]	ram_addr;
wire	ram_en;
wire	ram_wen;
wire [7:0]	ram_wdata;
wire [7:0]	ram_rdata;
wire [7:0]	ram_data;

wire [1:0]	pia_addr;
wire	pia_en;
wire	pia_wen;
wire [7:0]	pia_wdata;
wire [7:0]	pia_rdata;
wire	pia_irq;
wire [7:0]	pa_i;
wire [7:0]	pa_o;
wire [7:0]	ddra;
wire	ca1;
wire	ca2_i;
wire	ca2_o;
wire [7:0]	pb_i;
wire [7:0]	pb_o;
wire [7:0]	ddrb;
wire	cb1;
wire	cb2_i;
wire	cb2_o;

wire [8:0]	rom1_addr;
wire	rom1_en;
wire [7:0]	rom1_rdata;

wire [10:0]	ram1_addr;
wire	ram1_en;
wire	ram1_wen;
wire [7:0]	ram1_wdata;
wire [7:0]	ram1_rdata;

wire [9:0]	hrdat;
wire	hrful;
wire	hrack;
wire	keystb;
wire [6:0]	keydata;

wire	cls_reqb;
wire	disp_req;
wire	disp_ack;
wire [9:0]	xcnt;
wire [8:0]	ycnt;
wire [3:0]	r_in;
wire [3:0]	g_in;
wire [3:0]	b_in;
wire [3:0]	r_out;
wire [3:0]	g_out;
wire [3:0]	b_out;
wire	hblnk;
wire	vblnk;
wire	hsync;
wire	vsync;


pll25 pll25_0(
	.inclk0(clk27_0),
	.c0(clk2),
	.c1(clk),
	.locked(locked)
);

assign	async_rst = key[0] & locked;

always @(posedge clk) begin
	rst <= async_rst;
end

assign	irq = 1'b0;
assign	nmi = 1'b0;


ac6502_top ac6502_top0(
	.clk(clk),
	.rst(rst),
	.irq(irq),
	.nmi(nmi),
	.addr(addr),
	.wdata(wdata),
	.rdata(rdata),
	.en(en),
	.wen(wen),
	.ack(ack)
);

always @(posedge clk or negedge rst) begin
	if(~rst)
		ack <= 1'b0;
	else
		ack <= en;
end

apl1_mux mux0(
	.clk(clk),
	.rst(rst),
	.addr(addr),
	.en(en),
	.wen(wen),
	.wdata(wdata),
	.rdata(rdata),
	.rom_addr(rom_addr),
	.rom_en(rom_en),
	.rom_rdata(rom_rdata),
	.ram_addr(ram_addr),
	.ram_en(ram_en),
	.ram_wen(ram_wen),
	.ram_wdata(ram_wdata),
	.ram_rdata(ram_rdata),
	.pia_addr(pia_addr),
	.pia_en(pia_en),
	.pia_wen(pia_wen),
	.pia_wdata(pia_wdata),
	.pia_rdata(pia_rdata)
);

srom rom0(
	.clock(clk),
	.address(rom_addr),
	.q(rom_rdata)
);

assign	sram_addr = {2'b00,ram_addr};
assign	sram_data = ram_wen ? {8'h00,ram_wdata} : 16'hzzzz;
assign	ram_rdata = sram_data[7:0];
assign	sram_ce = ~ram_en;
assign	sram_we = (~ram_wen) | clk;
assign	sram_oe = ram_wen;
assign	sram_ub = 1'b1;
assign	sram_lb = 1'b0;

pia pia0(
	.clk(clk),
	.rst(rst),
	.addr(pia_addr),
	.en(pia_en),
	.wen(pia_wen),
	.wdata(pia_wdata),
	.rdata(pia_rdata),
	.irq(pia_irq),
	.pa_i(pa_i),
	.pa_o(pa_o),
	.ddra(ddra),
	.ca1(ca1),
	.ca2_i(ca2_i),
	.ca2_o(ca2_o),
	.pb_i(pb_i),
	.pb_o(pb_o),
	.ddrb(ddrb),
	.cb1(cb1),
	.cb2_i(cb2_i),
	.cb2_o(cb2_o)
);

assign	pa_i = {1'b1,keydata};	// PA7 = 1
assign	ca1 = keystb;
assign	ca2_i = 1'b1;
assign	pb_i = {disp_req,7'b0000_000};
assign	cb1 = disp_ack;
assign	cb2_i = 1'b1;

kbd2chr kbd2chr0(
	.clk(clk),
	.rst(rst),
	.rcv_dat(hrdat),
	.rcv_full(hrful),
	.rcv_ack(hrack),
	.keystb(keystb),
	.keydata(keydata)
);

ps2 ps2_0(
	.clk(clk),
	.rst(rst),
	.rcv_dat(hrdat),
	.rcv_full(hrful),
	.rcv_ack(hrack),
	.scl_i(ps2_clk),
	.sda_i(ps2_dat)
);

assign	disp_req = ~cb2_o;

ns_filt #(1'b1) ns_filt0(
	.clk(clk),
	.rst(rst),
	.in(key[3]),
	.out(cls_reqb)
);

vidcon vidcon0(
	.clk(clk2),
	.rst(rst),
	.vram_addr(ram1_addr),
	.vram_en(ram1_en),
	.vram_wen(ram1_wen),
	.vram_wdata(ram1_wdata),
	.vram_rdata(ram1_rdata),
	.crom_addr(rom1_addr),
	.crom_en(rom1_en),
	.crom_rdata(rom1_rdata),
	.cls_req(~cls_reqb),
	.disp_req(disp_req),
	.disp_ack(disp_ack),
	.disp_data(pb_o[6:0]),
	.xcnt(xcnt),
	.ycnt(ycnt),
	.r_in(r_in),
	.g_in(g_in),
	.b_in(b_in),
	.hblnk(hblnk),
	.vblnk(vblnk)
);

vidgen400 vidgen0(
	.clk(clk2),
	.rst(rst),
	.xcnt(xcnt),
	.ycnt(ycnt),
	.r_in(r_in),
	.g_in(g_in),
	.b_in(b_in),
	.r_out(vga_r),
	.g_out(vga_g),
	.b_out(vga_b),
	.hblnk(hblnk),
	.vblnk(vblnk),
	.hsync(vga_hsync),
	.vsync(vga_vsync)
);

crom crom1(
	.clock(clk2),
	.address(rom1_addr),
	.q(rom1_rdata)
);

vram vram1(
	.clock(clk2),
	.address(ram1_addr),
	.data(ram1_wdata),
	.wren(ram1_wen),
	.q(ram1_rdata)
);


endmodule

// End of cyc2.v
