//
// apl1_mux.v
//
// Copyright 2008, Hideyuki Abe. All rights reserved.
// Distributed under the terms of the MIT License.
//

module apl1_mux(
	clk,
	rst,
	addr,
	en,
	wen,
	wdata,
	rdata,
	rom_addr,
	rom_en,
	rom_rdata,
	ram_addr,
	ram_en,
	ram_wen,
	ram_wdata,
	ram_rdata,
	pia_addr,
	pia_en,
	pia_wen,
	pia_wdata,
	pia_rdata
);

input	clk;
input	rst;
input [15:0]	addr;
input	en;
input	wen;
input [7:0]	wdata;
output [7:0]	rdata;
output [10:0]	rom_addr;
output	rom_en;
input [7:0]	rom_rdata;
output [15:0]	ram_addr;
output	ram_en;
output	ram_wen;
output [7:0]	ram_wdata;
input [7:0]	ram_rdata;
output [1:0]	pia_addr;
output	pia_en;
output	pia_wen;
output [7:0]	pia_wdata;
input [7:0]	pia_rdata;

reg [7:0]	rdata;

reg	rom_en_d;

reg	pia_en_d;
reg [7:0]	pia_rdata_d;

reg	ram_en_d;
reg [7:0]	ram_rdata_d;


assign	rom_en = (addr[15:11] == 5'b1111_1) & en;
assign	rom_addr = addr[10:0];

always @(posedge clk or negedge rst) begin
	if(~rst)
		rom_en_d <= 1'b0;
	else
		rom_en_d <= rom_en;
end

assign	pia_en = (addr[15:4] == 12'hd01) & en;
assign	pia_wen = pia_en & wen;
assign	pia_addr = addr[1:0];
assign	pia_wdata = wdata;

always @(posedge clk or negedge rst) begin
	if(~rst)
		pia_en_d <= 1'b0;
	else
		pia_en_d <= pia_en;
end

always @(posedge clk or negedge rst) begin
	if(~rst)
		pia_rdata_d <= 8'h00;
	else if(pia_en)
		pia_rdata_d <= pia_rdata;
end

assign	ram_en = en & ~rom_en & ~pia_en;
assign	ram_wen = ram_en & wen;
assign	ram_addr = addr;
assign	ram_wdata = wdata;

always @(posedge clk or negedge rst) begin
	if(~rst)
		ram_en_d <= 1'b0;
	else
		ram_en_d <= ram_en;
end

always @(posedge clk or negedge rst) begin
	if(~rst)
		ram_rdata_d <= 8'h00;
	else if(ram_en)
		ram_rdata_d <= ram_rdata;
end

always @(
	rom_en_d or rom_rdata
	or pia_en_d or pia_rdata_d
	or ram_en_d or ram_rdata_d
) begin
	if(rom_en_d)
		rdata = rom_rdata;
	else if(pia_en_d)
		rdata = pia_rdata_d;
	else if(ram_en_d)
		rdata = ram_rdata_d;
	else
		rdata = 8'h00;
end	// always comb

endmodule

// End of apl1_mux.v
