//
// ac6502_bus2memr.v
//
// ac6502 processor core
//
// Version 0.6
//
// Copyright 2008, Hideyuki Abe. All rights reserved.
// Distributed under the terms of the MIT License.
//

module ac6502_bus2memr(
	clk,
	rst,
	addr_i,
	en_i,
	ack_i,
	addr_o,
	en_o,
	ack_o
);

input	clk;
input	rst;
input [15:0]	addr_i;
input	en_i;
output	ack_i;
output [15:0]	addr_o;
output	en_o;
input	ack_o;

reg [15:0]	addr_o;
reg	en_o;

reg [15:0]	addr_r;
reg	en_r;

always @(posedge clk or negedge rst) begin
	if(~rst) begin
		addr_r <= 16'h0000;
		en_r <= 1'b0;
	end
	else if(en_i) begin
		addr_r <= addr_i;
		en_r <= 1'b1;
	end
	else if(ack_o) begin
		en_r <= 1'b0;
	end
end

always @(
	addr_i or en_i or addr_r or en_r or ack_o
) begin
	if(en_i) begin
		addr_o = addr_i;
		en_o = en_i;
	end
	else if(ack_o) begin
		addr_o = 16'h0000;
		en_o = 1'b0;
	end
	else if(en_r) begin
		addr_o = addr_r;
		en_o = en_r;
	end
	else begin
		addr_o = addr_r;
		en_o = en_r;
	end
end	// always comb

assign	ack_i = ack_o;

endmodule

// End of ac6502_bus2memr.v
