//
// sync_ram.v
//
// ac68 processor core
//
// Version 0.6
//
// Copyright 2008, Hideyuki Abe. All rights reserved.
// Distributed under the terms of the MIT License.
//

module sync_ram(
	clk,
	addr,
	wdata,
	ceb,
	web,
	rdata
);

parameter	ADDR_WIDTH = 16;

input	clk;
input [ADDR_WIDTH - 1:0]	addr;
input	ceb;
input	web;
input [7:0]	wdata;
output [7:0]	rdata;

reg [7:0]	rdata;

reg [7:0]	mem[0:(1 << ADDR_WIDTH) - 1];
wire	write_en;
wire	read_en;

parameter	WDELAY = 1;
parameter	RDELAY = 1;

assign	read_en = (~ceb);
assign	write_en = (~ceb & ~web);


always @(posedge clk) begin
	if(read_en)
		rdata <= #RDELAY mem[addr];
end

always @(posedge clk) begin
	if(write_en)
		mem[addr] <= #WDELAY wdata;
end

endmodule

// End of sync_ram.v
