;
; test.asm
;
; ac68 processor core
;
; Version 0.6
;
; Copyright 2008, Hideyuki Abe. All rights reserved.
; Distributed under the terms of the MIT License.
;

	.area	CODE	(ABS)

	; direct page
	.org	0x0000
ld_dat0:
	.fcb	0xaa

	.org	0x8000

test_error:
	bra		test_error

start:
ld_test:
	ldaa	#0x55		; immediate
	beq		ld_error
	bmi		ld_error
	bvs		ld_error
	cmpa	#0x55
	bne		ld_error

	ldab	*ld_dat0	; direct
	beq		ld_error
	bpl		ld_error
	bvs		ld_error
	cmpb	#0xaa
	bne		ld_error

	ldaa	ld_dat1		; extended
	bne		ld_error
	bmi		ld_error
	bvs		ld_error
	cmpa	#0x00
	bne		ld_error

	ldx		#ld_dat1
	ldab	1,x			; index
	beq		ld_error
	bpl		ld_error
	bvs		ld_error
	cmpb	#0x89
	bne		ld_error

	jmp		ld16_test

ld_dat1:
	.fcb	0x00
	.fcb	0x89

ld_error:
	jmp		test_error

ld16_test:
	ldx		#0x55aa		; immediate
	beq		ld16_error
	bmi		ld16_error
	bvs		ld16_error
	cpx		#0x55aa
	bne		ld16_error

	ldx		ld16_dat0	; extended
	beq		ld16_error
	bpl		ld16_error
	bvs		ld16_error
	cpx		#0x89ab
	bne		ld16_error

	lds		#0x0000		; immediate
	bne		ld16_error
	bmi		ld16_error
	bvs		ld16_error
	tsx					; x = sp + 1
	cpx		#0x0001
	bne		ld16_error

	lds		ld16_dat1	; extended
	beq		ld16_error
	bpl		ld16_error
	bvs		ld16_error
	tsx					; x = sp + 1
	cpx		#0x0000
	bne		ld16_error

	jmp		st_test

ld16_dat0:
	.fdb	0x89ab
ld16_dat1:
	.fdb	0xffff

ld16_error:
	jmp		test_error

st_test:
	ldaa	#0x55
	ldab	#0x00
	staa	st_dat0		; extended
	beq		st_error
	bmi		st_error
	bvs		st_error
	ldab	st_dat0
	cmpb	#0x55
	bne		st_error

	ldx		#0xaa55
	stx		st_dat1		; extended
	beq		st_error
	bpl		st_error
	bvs		st_error
	ldx		#0x0000
	ldx		st_dat1
	cpx		#0xaa55
	bne		st_error

	lds		#0x0000
	sts		st_dat2		; extended
	bne		st_error
	bmi		st_error
	bvs		st_error
	ldx		st_dat2
	cpx		#0x0000
	bne		st_error

	jmp		tfr_test

st_dat0:
	.fcb	0x00
st_dat1:
	.fdb	0x0000
st_dat2:
	.fdb	0xffff

st_error:
	jmp		test_error

tfr_test:
	ldab	#0x55
	ldaa	#0x00
	tba					; A := B
	beq		tfr_error
	bmi		tfr_error
	bvs		tfr_error
	cmpa	#0x55
	bne		tfr_error

	ldaa	#0xaa
	ldab	#0x00
	tab					; B := A
	beq		tfr_error
	bpl		tfr_error
	bvs		tfr_error
	cmpb	#0xaa
	bne		tfr_error

	lds		#0x55aa
	ldx		#0x0000
	tsx					; X := SP + 1
	cmpx	#0x55ab
	bne		tfr_error

	ldx		#0xaa55
	lds		#0x0000
	txs					; SP := X - 1
	sts		tfr_dat0
	ldx		tfr_dat0
	cmpx	#0xaa54
	bne		tfr_error

	ldaa	#0x00		; Z = 1
	tpa					; A := CC
	bita	#0x04		; test bit2
	beq		tfr_error
	anda	#0xfb		; clear bit2
	tap					; CC := A
	beq		tfr_error

	jmp		stk_test

tfr_dat0:
	.fdb	0x0000

tfr_error:
	jmp		test_error

stk_test:
	lds		#stk_dat1

	ldaa	#0x55
	psha				; psha
	ldab	stk_dat1
	cmpb	#0x55
	bne		stk_error
	ldab	#0xaa
	pshb				; pshb
	ldaa	stk_dat0
	cmpa	#0xaa
	bne		stk_error
	ldaa	#0x00
	pula				; pula
	cmpa	#0xaa
	bne		stk_error
	ldab	#0x00
	pulb				; pulb
	cmpb	#0x55
	bne		stk_error

	jmp		cc_test

stk_dat0:
	.fcb	0x00
stk_dat1:
	.fcb	0x00

stk_error:
	jmp		test_error

cc_test:
	sec
	bcc		cc_error
	clc
	bcs		cc_error
	sec
	bcc		cc_error

	sev
	bvc		cc_error
	clv
	bvs		cc_error
	sev
	bvc		cc_error

	sei
	tpa
	bita	#0x10		; test bit4
	beq		cc_error
	cli
	tpa
	bita	#0x10		; test bit4
	bne		cc_error
	sei
	tpa
	bita	#0x10		; test bit4
	beq		cc_error

	jmp		lop_test

cc_error:
	jmp		test_error

lop_test:
	; and test
	ldaa	#0x55
	anda	#0xa5
	beq		lop_error
	bmi		lop_error
	bvs		lop_error
	cmpa	#0x05
	bne		lop_error

	ldab	#0xaa
	andb	lop_dat0
	beq		lop_error
	bpl		lop_error
	bvs		lop_error
	cmpb	#0xa0
	bne		lop_error

	; or test
	ldaa	#0x55
	oraa	#0xa5
	beq		lop_error
	bpl		lop_error
	bvs		lop_error
	cmpa	#0xf5
	bne		lop_error

	ldab	#0xaa
	orab	lop_dat1
	beq		lop_error
	bpl		lop_error
	bvs		lop_error
	cmpb	#0xaf
	bne		lop_error

	; xor test
	ldaa	#0x55
	eora	#0xa5
	beq		lop_error
	bpl		lop_error
	bvs		lop_error
	cmpa	#0xf0
	bne		lop_error

	ldab	#0xaa
	eorb	lop_dat2
	beq		lop_error
	bmi		lop_error
	bvs		lop_error
	cmpb	#0x0f
	bne		lop_error

	jmp		lop2_test

lop_dat0:
	.fcb	0xa5
lop_dat1:
	.fcb	0xa5
lop_dat2:
	.fcb	0xa5

lop_error:
	jmp		test_error

lop2_test:
	; clr test
	ldaa	#0xff
	clra
	bne		lop2_error
	bmi		lop2_error
	bvs		lop2_error
	bcs		lop2_error
	cmpa	#0x00
	bne		lop2_error

	clr		lop2_dat0
	bne		lop2_error
	bmi		lop2_error
	bvs		lop2_error
	bcs		lop2_error
	ldab	lop2_dat0
	cmpb	#0x00
	bne		lop2_error

	; com test
	ldab	#0x55
	comb
	beq		lop2_error
	bpl		lop2_error
	bvs		lop2_error
	bcc		lop2_error
	cmpb	#0xaa
	bne		lop2_error

	com		lop2_dat1
	beq		lop2_error
	bpl		lop2_error
	bvs		lop2_error
	bcc		lop2_error
	ldaa	lop2_dat1
	cmpa	#0xff
	bne		lop2_error

	; bit test
	ldaa	#0x55
	bita	#0x04
	beq		lop2_error
	bmi		lop2_error
	bvs		lop2_error
	cmpa	#0x55
	bne		lop2_error

	ldab	#0xaa
	bitb	lop2_dat2
	beq		lop2_error
	bpl		lop2_error
	bvs		lop2_error
	cmpb	#0xaa
	bne		lop2_error

	jmp		aop_test

lop2_dat0:
	.fcb	0xff
lop2_dat1:
	.fcb	0x00
lop2_dat2:
	.fcb	0x80

lop2_error:
	jmp		test_error

aop_test:
	; add
	ldaa	#0x55
	adda	#0xaa
	beq		aop_error
	bpl		aop_error
	bvs		aop_error
	bcs		aop_error
	cmpa	#0xff
	bne		aop_error

	ldab	#0x23
	addb	aop_dat0
	beq		aop_error
	bpl		aop_error
	bvc		aop_error
	bcs		aop_error
	cmpb	#0x9a
	bne		aop_error

	ldaa	#0x89
	ldab	#0xcd
	aba					; A := A + B
	beq		aop_error
	bmi		aop_error
	bvc		aop_error
	bcc		aop_error
	cmpa	#0x56
	bne		aop_error

	; adc
	ldab	#0xde
	sec
	adcb	#0x21
	bne		aop_error
	bmi		aop_error
	bvs		aop_error
	bcc		aop_error
	cmpb	#0x00
	bne		aop_error

	ldaa	#0x35
	clc
	adca	aop_dat1
	beq		aop_error
	bmi		aop_error
	bvs		aop_error
	bcs		aop_error
	cmpa	#0x7f
	bne		aop_error

	jmp		aop2_test

aop_dat0:
	.fcb	0x77
aop_dat1:
	.fcb	0x4a

aop_error:
	jmp		test_error

aop2_test:
	; sub
	ldaa	#0x55
	suba	#0x55
	bne		aop2_error
	bmi		aop2_error
	bvs		aop2_error
	bcs		aop2_error
	cmpa	#0x00
	bne		aop2_error

	ldab	#0xaa
	subb	aop2_dat0
	beq		aop2_error
	bmi		aop2_error
	bvc		aop2_error
	bcs		aop2_error
	cmpb	#0x65
	bne		aop2_error

	ldaa	#0x34
	ldab	#0x89
	sba					; A := A - B
	beq		aop2_error
	bpl		aop2_error
	bvc		aop2_error
	bcc		aop2_error
	cmpa	#0xab
	bne		aop2_error

	; sbc
	ldab	#0x55
	sec
	sbcb	#0x54
	bne		aop2_error
	bmi		aop2_error
	bvs		aop2_error
	bcs		aop2_error
	cmpb	#0x00
	bne		aop2_error

	ldaa	#0x89
	clc
	sbca	aop2_dat1
	beq		aop2_error
	bmi		aop2_error
	bvc		aop2_error
	bcs		aop2_error
	cmpa	#0x12
	bne		aop2_error

	jmp		aop3_test

aop2_dat0:
	.fcb	0x45
aop2_dat1:
	.fcb	0x77

aop2_error:
	jmp		test_error

aop3_test:
	; neg
	ldaa	#0x55
	nega
	beq		aop3_error
	bpl		aop3_error
	bvs		aop3_error
	bcc		aop3_error
	cmpa	#0xab
	bne		aop3_error

	neg		aop3_dat0
	beq		aop3_error
	bpl		aop3_error
	bvc		aop3_error
	bcc		aop3_error
	ldaa	aop3_dat0
	cmpa	#0x80
	bne		aop3_error

	; tst
	ldab	#0x55
	tstb
	beq		aop3_error
	bmi		aop3_error
	bvs		aop3_error
	bcs		aop3_error
	cmpb	#0x55
	bne		aop3_error

	tst		aop3_dat1
	bne		aop3_error
	bmi		aop3_error
	bvs		aop3_error
	bcs		aop3_error
	ldab	aop3_dat1
	cmpb	#0x00
	bne		aop3_error

	jmp		aop4_test

aop3_dat0:
	.fcb	0x80
aop3_dat1:
	.fcb	0x00

aop3_error:
	jmp		test_error

aop4_test:
	; daa
	ldaa	#0x56
	adda	#0x89
	daa
	cmpa	#0x45
	bne		aop4_error

	; inc
	ldaa	#0xcd
	inca
	beq		aop4_error
	bpl		aop4_error
	bvs		aop4_error
	cmpa	#0xce
	bne		aop4_error

	inc		aop4_dat0
	beq		aop4_error
	bpl		aop4_error
	bvc		aop4_error
	ldaa	aop4_dat0
	cmpa	#0x80
	bne		aop4_error

	; dec
	ldab	#0x00
	decb
	beq		aop4_error
	bpl		aop4_error
	bvs		aop4_error
	cmpb	#0xff
	bne		aop4_error

	dec		aop4_dat1
	beq		aop4_error
	bmi		aop4_error
	bvc		aop4_error
	ldab	aop4_dat1
	cmpb	#0x7f
	bne		aop4_error

	jmp		aop5_test

aop4_dat0:
	.fcb	0x7f
aop4_dat1:
	.fcb	0x80

aop4_error:
	jmp		test_error

aop5_test:
	; inx
	ldx		#0xffff
	inx
	bne		aop5_error
	cpx		#0x0000
	bne		aop5_error

	; dex
	ldx		#0x0000
	dex
	beq		aop5_error
	cpx		#0xffff
	bne		aop5_error

	; ins
	lds		#0xffff
	ins
	tsx					; x := sp + 1
	cpx		#0x0001
	bne		aop5_error

	; des
	lds		#0x0000
	des
	tsx					; x := xp + 1
	cpx		#0x0000
	bne		aop5_error

	jmp		cmp_test

aop5_error:
	jmp		test_error

cmp_test:
	ldaa	#0xaa
	cmpa	#0xaa		; eval 0x00
	bne		cmp_error
	bmi		cmp_error
	bvs		cmp_error
	bcs		cmp_error
	cmpa	#0xaa
	bne		cmp_error

	ldab	#0x12
	cmpb	cmp_dat0	; eval 0xab
	beq		cmp_error
	bpl		cmp_error
	bvs		cmp_error
	bcc		cmp_error
	cmpb	#0x12
	bne		cmp_error

	; cba
	ldaa	#0x56
	ldab	#0x87
	cba					; eval 0xcf
	beq		cmp_error
	bpl		cmp_error
	bvc		cmp_error
	bcc		cmp_error
	cmpa	#0x56
	bne		cmp_error

	; cpx
	ldx		#0x5678
	clc
	cpx		#0xabcd		; eval 0xaaab
	beq		cmp_error
	bpl		cmp_error
	bvc		cmp_error
	bcs		cmp_error	; carry bit unchanged
	cpx		#0x5678
	bne		cmp_error

	ldx		#0x789a
	sec
	cpx		cmp_dat1	; eval 0x2468
	beq		cmp_error
	bmi		cmp_error
	bvs		cmp_error
	bcc		cmp_error	; carry bit unchanged
	cpx		#0x789a
	bne		cmp_error

	jmp		shf_test

cmp_dat0:
	.fcb	0x67
cmp_dat1:
	.fdb	0x5432

cmp_error:
	jmp		test_error

shf_test:
	; asl
	ldaa	#0xaa
	clc
	asla
	beq		shf_error
	bmi		shf_error
	bvc		shf_error
	bcc		shf_error
	cmpa	#0x54
	bne		shf_error

	sec
	asl		shf_dat0
	beq		shf_error
	bpl		shf_error
	bvc		shf_error
	bcs		shf_error
	ldaa	shf_dat0
	cmpa	#0xaa
	bne		shf_error

	; asr
	ldab	#0xaa
	sec
	asrb
	beq		shf_error
	bpl		shf_error
	bvc		shf_error
	bcs		shf_error
	cmpb	#0xd5
	bne		shf_error

	clc
	asr		shf_dat1
	beq		shf_error
	bmi		shf_error
	bvc		shf_error
	bcc		shf_error
	ldab	shf_dat1
	cmpb	#0x2a
	bne		shf_error

	; lsr
	ldaa	#0xaa
	sec
	lsra
	beq		shf_error
	bmi		shf_error
	bvs		shf_error
	bcs		shf_error
	cmpa	#0x55
	bne		shf_error

	clc
	lsr		shf_dat2
	beq		shf_error
	bmi		shf_error
	bvc		shf_error
	bcc		shf_error
	ldaa	shf_dat2
	cmpa	#0x2a
	bne		shf_error

	jmp		rot_test

shf_dat0:
	.fcb	0x55
shf_dat1:
	.fcb	0x55
shf_dat2:
	.fcb	0x55

shf_error:
	jmp		test_error

rot_test:
	; rol
	sec
	ldab	#0x55
	rolb
	beq		rot_error
	bpl		rot_error
	bvc		rot_error
	bcs		rot_error
	cmpb	#0xab
	bne		rot_error

	clc
	rol		rot_dat0
	beq		rot_error
	bmi		rot_error
	bvc		rot_error
	bcc		rot_error
	ldab	rot_dat0
	cmpb	#0x54
	bne		rot_error

	; ror
	clc
	ldaa	#0x55
	rora
	beq		rot_error
	bmi		rot_error
	bvc		rot_error
	bcc		rot_error
	cmpa	#0x2a
	bne		rot_error

	sec
	ror		rot_dat1
	beq		rot_error
	bpl		rot_error
	bvc		rot_error
	bcs		rot_error
	ldaa	rot_dat1
	cmpa	#0xd5
	bne		rot_error

	jmp		jmp_test

rot_dat0:
	.fcb	0xaa
rot_dat1:
	.fcb	0xaa

rot_error:
	jmp		test_error

jmp_test:
	jmp		jmp_tst1
	bra		jmp_error
jmp_tst1:
	ldx		#jmp_tst1
	jmp		(jmp_tst2-jmp_tst1),x
	bra		jmp_error
jmp_tst2:
	nop

	jmp		sbr_test

jmp_error:
	jmp		test_error

sbr_test:
	lds		#(sbr_dat1-1)
	bsr		sbr_tst1

	jmp		swi_test

sbr_tst1:
	jsr		sbr_tst2
	rts

sbr_tst2:
	ldx		#sbr_tst1
	jsr		(sbr_tst3-sbr_tst1),x
	rts

sbr_tst3:
	rts

sbr_dat0:
	.fdb	0x0000
	.fdb	0x0000
	.fdb	0x0000
sbr_dat1:

sbr_error:
	jmp		test_error

swi_test:
	lds		#(swi_dat1-1)
	clr		irq_dat0
	swi
	ldaa	irq_dat0
	cmpa	0x03
	bne		swi_error

	jmp		int_test

swi_dat0:
	.fcb	0x00	; CCR
	.fcb	0x00	; AccB
	.fcb	0x00	; AccA
	.fdb	0x0000	; IX
	.fdb	0x0000	; PC
swi_dat1:

swi_error:
	jmp		test_error

irq_cnt	=	0xfd00
nmi_cnt	=	0xfd01

int_test:
	lds		#(int_dat2-1)

	clr		irq_dat0
	sei
	ldaa	#0x01
	staa	irq_cnt	; set IRQ
	nop
	nop
	ldaa	irq_dat0
	cmpa	#0x00
	bne		int_error
	ldaa	#0x00
	staa	irq_cnt	; clear IRQ

	clr		irq_dat0
	cli
	ldaa	#0x01
	staa	irq_cnt	; set IRQ
	nop
	nop
	ldaa	irq_dat0
	cmpa	#0x06
	bne		int_error

	clr		irq_dat0
	cli
	ldaa	#0x02
	staa	irq_cnt	; set IRQ (delayed)
	wai
	ldaa	irq_dat0
	cmpa	#0x06
	bne		int_error

	jmp		test_ok

int_dat0:
	.fcb	0x00	; CCR
	.fcb	0x00	; AccB
	.fcb	0x00	; AccA
	.fdb	0x0000	; IX
	.fdb	0x0000	; PC
int_dat1:
	.fcb	0x00	; CCR
	.fcb	0x00	; AccB
	.fcb	0x00	; AccA
	.fdb	0x0000	; IX
	.fdb	0x0000	; PC
int_dat2:

int_error:
	jmp		test_error

test_ok:
	bra		test_ok

irq_dat0:
	.fcb	0x00

irq_hdl:
	ldaa	irq_dat0
	asla
	asla
	oraa	#0x01
	staa	irq_dat0
	ldaa	#0x01
	staa	nmi_cnt
	nop
	nop
	ldaa	#0x00
	staa	irq_cnt
	rti

swi_hdl:
	ldaa	irq_dat0
	asla
	asla
	oraa	#0x03
	staa	irq_dat0
	rti

nmi_hdl:
	ldaa	irq_dat0
	asla
	asla
	oraa	#0x02
	staa	irq_dat0
	ldaa	#0x00
	staa	nmi_cnt
	rti

	.org	0xfff8
	.fdb	irq_hdl
	.fdb	swi_hdl
	.fdb	nmi_hdl
	.fdb	start

; End of test.asm
