//
// ac68_top.v
//
// ac68 processor core
//
// Version 0.6
//
// Copyright 2008, Hideyuki Abe. All rights reserved.
// Distributed under the terms of the MIT License.
//

module ac68_top(
	clk,
	rst,
	addr,
	en,
	wen,
	wdata,
	rdata,
	ack,
	irq,
	nmi
);

input	clk;
input	rst;
output [15:0]	addr;
output	en;
output	wen;
output [7:0]	wdata;
input [7:0]	rdata;
input	ack;
input	irq;
input	nmi;

wire [15:0]	paddr;
wire	pen;
wire [7:0]	prdata;
wire	pack;
wire [15:0]	daddr;
wire	den;
wire	dwen;
wire [7:0]	dwdata;
wire [7:0]	drdata;
wire	dack;


ac68_core core0(
	.clk(clk),
	.rst(rst),
	.paddr(paddr),
	.pen(pen),
	.prdata(prdata),
	.pack(pack),
	.daddr(daddr),
	.den(den),
	.dwen(dwen),
	.dwdata(dwdata),
	.drdata(drdata),
	.dack(dack),
	.irq(irq),
	.nmi(nmi)
);

ac68_bmux bmux0(
	.clk(clk),
	.rst(rst),
	.paddr(paddr),
	.pen(pen),
	.prdata(prdata),
	.pack(pack),
	.daddr(daddr),
	.den(den),
	.dwen(dwen),
	.dwdata(dwdata),
	.drdata(drdata),
	.dack(dack),
	.addr(addr),
	.en(en),
	.wen(wen),
	.wdata(wdata),
	.rdata(rdata),
	.ack(ack)
);

endmodule

// End of ac68_top.v
