//
// ac68_exe.v
//
// ac68 processor core
//
// Version 0.6
//
// Copyright 2008, Hideyuki Abe. All rights reserved.
// Distributed under the terms of the MIT License.
//

`include "ac68_defs.v"

module ac68_exe(
	clk,
	rst,
	inst_rdy,
	inst_ack,
	pc,
	jmp_req,
	jmp_ack,
	new_pc,
	opcode,
	amode,
	oprnd,
	calc_ea,
	daddr,
	den,
	dwen,
	dwdata,
	drdata,
	dack,
	irq,
	nmi
);

input	clk;
input	rst;
input	inst_rdy;
output	inst_ack;
input [15:0]	pc;
output	jmp_req;
input	jmp_ack;
output [15:0]	new_pc;
input [7:0]	opcode;
input [`AMODE_LEN - 1:0]	amode;
input [15:0]	oprnd;
input	calc_ea;
output [15:0]	daddr;
output	den;
output	dwen;
output [7:0]	dwdata;
input [7:0]	drdata;
input	dack;
input	irq;
input	nmi;

wire [7:0]	opcode;
wire [7:0]	opcode_r;
wire [`ALUOP_LEN - 1:0]	main_opr;
wire [`AMODE_LEN - 1:0]	amode;
wire [`AMODE_LEN - 1:0]	amode_r;
wire [15:0]	oprnd;

wire [`EAMUX_LEN - 1:0]	ea_mux;
wire [`PCMUX_LEN - 1:0]	pc_mux;
wire [`CPCMUX_LEN - 1:0]	cpc_mux;
wire [`TMUX_LEN - 1:0]	tmp_mux;
wire [`ALUOP_LEN - 1:0]	op_sel;
wire [`ALUOP_LEN - 1:0]	op_sel_i;
wire [`AMUX_LEN - 1:0]	ina_mux;
wire [`BMUX_LEN - 1:0]	inb_mux;
wire [`CCMUX_LEN - 1:0]	cc_mux;
wire [`RMUX_LEN - 1:0]	rbus_mux;
wire [`RNUM_LEN - 1:0]	rnum_mux;
wire [`RWDMUX_LEN - 1:0]	rwd_mux;
wire [`DMUX_LEN - 1:0]	dbus_mux;
wire [`DAMUX_LEN - 1:0]	da_mux;
wire [`DWDMUX_LEN - 1:0]	dwd_mux;

wire [15:0]	ina;
wire [15:0]	inb;
wire [15:0]	outa;
wire [15:0]	outb;

wire [15:0]	daddr_i;
wire	den_i;
wire	dsize_i;
wire	dwen_i;
wire [15:0]	dwdata_i;
wire [15:0]	drdata_i;
wire	dack_i;


ac68_exe_ctrl exe_ctrl0(
	.clk(clk),
	.rst(rst),
	.inst_rdy(inst_rdy),
	.inst_ack(inst_ack),
	.jmp_req(jmp_req),
	.jmp_ack(jmp_ack),
	.opcode(opcode_r),
	.cond_ok(cond_ok),
	.rlst_end(rlst_end),
	.amode(amode_r),
	.calc_ea(calc_ea),
	.ea_mux(ea_mux),
	.pc_mux(pc_mux),
	.cpc_mux(cpc_mux),
	.tmp_mux(tmp_mux),
	.op_sel(op_sel_i),
	.ina_mux(ina_mux),
	.inb_mux(inb_mux),
	.cc_mux(cc_mux),
	.rbus_mux(rbus_mux),
	.rnum_mux(rnum_mux),
	.rwd_mux(rwd_mux),
	.dbus_mux(dbus_mux),
	.da_mux(da_mux),
	.dwd_mux(dwd_mux),
	.ack(dack_i),
	.irq(irq_i),
	.nmi(nmi_i)
);

ac68_exe_data exe_data0(
	.clk(clk),
	.rst(rst),
	.inst_ack(inst_ack),
	.pc(pc),
	.new_pc(new_pc),
	.opcode(opcode),
	.opcode_r(opcode_r),
	.main_opr(main_opr),
	.cond_ok(cond_ok),
	.rlst_end(rlst_end),
	.amode(amode),
	.amode_r(amode_r),
	.oprnd(oprnd),
	.ea_mux(ea_mux),
	.pc_mux(pc_mux),
	.cpc_mux(cpc_mux),
	.tmp_mux(tmp_mux),
	.ina_mux(ina_mux),
	.inb_mux(inb_mux),
	.cc_mux(cc_mux),
	.h_bit(h_bit),
	.c_bit(c_bit),
	.v_bit(v_bit),
	.new_h(new_h),
	.new_n(new_n),
	.new_z(new_z),
	.new_v(new_v),
	.new_c(new_c),
	.opsize(opsize),
	.ina(ina),
	.inb(inb),
	.outa(outa),
	.outb(outb),
	.rbus_mux(rbus_mux),
	.rnum_mux(rnum_mux),
	.rwd_mux(rwd_mux),
	.dbus_mux(dbus_mux),
	.da_mux(da_mux),
	.dwd_mux(dwd_mux),
	.daddr(daddr_i),
	.den(den_i),
	.dsize(dsize_i),
	.dwen(dwen_i),
	.dwdata(dwdata_i),
	.drdata(drdata_i),
	.irq(irq),
	.nmi(nmi),
	.irq_i(irq_i),
	.nmi_i(nmi_i)
);

assign	op_sel = (op_sel_i == `ALUOP_MAIN) ? main_opr : op_sel_i;

ac68_exe_alu exe_alu0(
	.op_sel(op_sel),
	.opsize(opsize),
	.ina(ina),
	.inb(inb),
	.h_bit(h_bit),
	.c_bit(c_bit),
	.v_bit(v_bit),
	.outa(outa),
	.outb(outb),
	.new_h(new_h),
	.new_n(new_n),
	.new_z(new_z),
	.new_v(new_v),
	.new_c(new_c)
);

ac68_mcon mcon0(
	.clk(clk),
	.rst(rst),
	.addr(daddr_i),
	.en(den_i),
	.size(dsize_i),
	.wen(dwen_i),
	.wdata(dwdata_i),
	.rdata(drdata_i),
	.ack(dack_i),
	.addr8(daddr),
	.en8(den),
	.wen8(dwen),
	.wdata8(dwdata),
	.rdata8(drdata),
	.ack8(dack)
);

endmodule

// End of ac68_exe.v
