//
// ac68_bmux.v
//
// ac68 processor core
//
// Version 0.6
//
// Copyright 2008, Hideyuki Abe. All rights reserved.
// Distributed under the terms of the MIT License.
//

module ac68_bmux(
	clk,
	rst,
	paddr,
	pen,
	prdata,
	pack,
	daddr,
	den,
	dwen,
	dwdata,
	drdata,
	dack,
	addr,
	en,
	wen,
	wdata,
	rdata,
	ack
);

parameter	ADDR_WIDTH = 16;

input	clk;
input	rst;
input [ADDR_WIDTH-1:0]	paddr;
input	pen;
output [7:0]	prdata;
output	pack;
input [ADDR_WIDTH-1:0]	daddr;
input	den;
input	dwen;
input [7:0]	dwdata;
output [7:0]	drdata;
output	dack;
output [ADDR_WIDTH-1:0]	addr;
output	en;
output	wen;
output [7:0]	wdata;
input [7:0]	rdata;
input	ack;

reg [ADDR_WIDTH-1:0]	addr;
reg [7:0]	wdata;
reg	wen;

reg	den_d;

assign	en = pen | den;
assign	prdata = rdata;
assign	drdata = rdata;

always @(den or daddr or dwdata or dwen or pen or paddr) begin
	if(den) begin
		addr = daddr;
		wdata = dwdata;
		wen = dwen;
	end
	else begin
		addr = paddr;
		wdata = 8'h00;
		wen = 1'b0;
	end
end	// always comb

always @(posedge clk or negedge rst) begin
	if(~rst)
		den_d <= 1'b0;
	else
		den_d <= den;
end	// always

assign	pack = (~den_d) & ack;
assign	dack = den_d & ack;

endmodule

// End of ac68_bmux.v
