;
; test.s
;
; ac6502 processor core
;
; Version 0.6
;
; Copyright 2008, Hideyuki Abe. All rights reserved.
; Distributed under the terms of the MIT License.
;

	org	$0000
	fcb		$ff, $11, $22
ld_dat1:
	fcb		$a5
ld_dat2a:
	fdb		ld_dat2
ld_dat6:
	fcb		$b5

	org	$8000
;
; error detected
;
error_end:
	jmp		error_end
;
; program entry point
;
start:
	nop
;
; register initial value test
;
initval_test:
	; accumulator
	cmp		#0
	bne		ival_test_err
	; index X
	cpx		#0
	bne		ival_test_err
	; index Y
	cpy		#0
	bne		ival_test_err
	jmp		load_test
ival_test_err:
	jmp		error_end
;
; load inst test
;
load_test:
	; accumulator
	lda		#$55	; immediate
	cmp		#$55
	bne		ld_test_err
	lda		ld_dat0	; absolute
	cmp		#$aa
	bne		ld_test_err
	lda		ld_dat1	; zero page
	cmp		#$a5
	bne		ld_test_err
	ldx		#4
	lda		ld_dat0,x	; absolute X
	cmp		#$ab
	bne		ld_test_err
	ldy		#5
	lda		ld_dat0,y	; absolute Y
	cmp		#$ba
	bne		ld_test_err
	ldx		#3
	lda		ld_dat1,x	; zero page X
	cmp		#$b5
	bne		ld_test_err
	ldx		#1
	lda		(ld_dat1,x)	; indexed indirect
	cmp		#$5a
	bne		ld_test_err
	ldy		#2
	lda		(ld_dat2a),y	; indirect indexed
	cmp		#$56
	bne		ld_test_err
	; index X
	ldx		#$b6	; immediate
	cpx		#$b6
	bne		ld_test_err
	ldx		ld_dat7	; absolute
	cpx		#$6b
	bne		ld_test_err
	; index Y
	ldy		#$5b	; immediate
	cpy		#$5b
	bne		ld_test_err
	ldy		ld_dat8	; absolute
	cpy		#$a6
	bne		ld_test_err
	jmp		store_test

ld_test_err:
	jmp		error_end

ld_dat0:
	fcb		$aa
ld_dat2:
	fcb		$5a
	fcb		$65
ld_dat3:
	fcb		$56
ld_dat4:
	fcb		$ab
ld_dat5:
	fcb		$ba
ld_dat7:
	fcb		$6b
ld_dat8:
	fcb		$a6

;
; store inst test
;
store_test:
	; acc
	lda		#$aa
	sta		st_dat0		; absolute
	lda		#$00
	lda		st_dat0
	cmp		#$aa
	bne		st_test_err
	; ix
	ldx		#$55
	stx		st_dat1		; absolute
	lda		st_dat1
	cmp		#$55
	bne		st_test_err
	; iy
	ldy		#$ff
	sty		st_dat2		; absolute
	lda		st_dat2
	cmp		#$ff
	bne		st_test_err
	jmp		ora_test

st_test_err:
	jmp		error_end

st_dat0:
	fcb		$55
st_dat1:
	fcb		$aa
st_dat2:
	fcb		$00

;
; or inst test
;
ora_test:
	lda		#$55
	ora		#$aa		; immediate
	bpl		or_test_err
	beq		or_test_err
	cmp		#$ff
	bne		or_test_err
	lda		#$00
	ora		or_dat0		; absolute
	bmi		or_test_err
	bne		or_test_err
	jmp		and_test

or_test_err:
	jmp		error_end

or_dat0:
	fcb		$00

;
; and inst test
;
and_test:
	lda		#$55
	and		#$aa		; immediate
	bmi		and_test_err
	bne		and_test_err
	lda		#$91
	and		and_dat0	; absolute
	bpl		and_test_err
	beq		and_test_err
	cmp		#$81
	bne		and_test_err
	jmp		eor_test

and_test_err:
	jmp		error_end

and_dat0:
	fcb		$8f

;
; eor inst test
;
eor_test:
	lda		#$ff
	eor		#$ff		; immediate
	bmi		eor_test_err
	bne		eor_test_err
	lda		#$55
	eor		eor_dat0	; absolute
	bpl		eor_test_err
	beq		eor_test_err
	cmp		#$d5
	bne		eor_test_err
	jmp		bit_test

eor_test_err:
	jmp		error_end

eor_dat0:
	fcb		$80

;
; bit inst test
;
bit_test:
	lda		#$5a
	bit		bit_dat0
	bpl		bit_test_err	; bit7 of $a5
	bvs		bit_test_err	; bit6 of $a5
	bne		bit_test_err	; eval $00
	cmp		#$5a		; not changed
	bne		bit_test_err
	lda		#$55
	bit		bit_dat1
	bmi		bit_test_err	; bit7 of $5a
	bvc		bit_test_err	; bit6 of $5a
	beq		bit_test_err	; eval $50
	cmp		#$55		; not changed
	bne		bit_test_err
	jmp		tfr_test

bit_test_err:
	jmp		error_end

bit_dat0:
	fcb		$a5
bit_dat1:
	fcb		$5a

;
; tfr inst test
;
tfr_test:
	; TAX
	lda		#$55
	ldx		#$aa
	tax
	bmi		tfr_test_err
	beq		tfr_test_err
	cpx		#$55
	bne		tfr_test_err
	; TAY
	lda		#$aa
	ldy		#$55
	tay
	bpl		tfr_test_err
	beq		tfr_test_err
	cpy		#$aa
	bne		tfr_test_err
	; TXA
	ldx		#$00
	lda		#$ff
	txa
	bmi		tfr_test_err
	bne		tfr_test_err
	; TYA
	ldy		#$5a
	lda		#$a5
	tya
	bmi		tfr_test_err
	beq		tfr_test_err
	cmp		#$5a
	bne		tfr_test_err
	; TXS, TSX
	ldx		#$aa
	txs
	pha		; push acc
	ldx		#$00
	tsx
	bpl		tfr_test_err
	beq		tfr_test_err
	cpx		#$a9
	bne		tfr_test_err
	jmp		stk_test

tfr_test_err:
	jmp		error_end

;
; stack inst test
;
stk_test:
	; PHA
	tsx				; sp -> ix
	lda		#$55
	sta		$0100,x
	lda		#$aa
	pha
	ldy		$0100,x
	cpy		#$aa
	bne		stk_test_err
	; PLA
	lda		#$b4
	pha
	lda		#$ff
	pla
	cmp		#$b4
	bne		stk_test_err
	; PHP
	tsx				; sp -> ix
	php
	pla
	cmp		$0100,x
	bne		stk_test_err
	; PLP
	clc
	php
	pla
	ora		#$01	; bit 0(Carry)
	pha
	plp
	bcc		stk_test_err
	jmp		flg_test

stk_test_err:
	jmp		error_end

;
; flag inst test
;
flg_test:
	; CLC
	sec
	clc
	bcs		flg_test_err
	; SEC
	sec
	bcc		flg_test_err
	; CLV
	clv
	bvs		flg_test_err
	; SEI
	sei
	php
	pla
	and		#$04	; bit 2
	beq		flg_test_err
	; CLI
	cli
	php
	pla
	and		#$04	; bit 2
	bne		flg_test_err
	; SED
	sed
	php
	pla
	and		#$08	; bit 3
	beq		flg_test_err
	; CLD
	cld
	php
	pla
	and		#$08	; bit3
	bne		flg_test_err
	jmp		adc_test

flg_test_err:
	jmp		error_end

;
; adc inst test
;
adc_test:
	; binary mode
	clc
	cld
	lda		#$12
	adc		#$ab	; immediate
	bcs		adc_test_err
	bvs		adc_test_err
	bpl		adc_test_err
	cmp		#$bd
	bne		adc_test_err

	clc
	lda		#$cd
	adc		adc_dat0	; absolute
	bcc		adc_test_err
	bvs		adc_test_err
	bmi		adc_test_err
	bne		adc_test_err

	; decimal mode
	clc
	sed		; decimal
	lda		#$39
	adc		#$24
	cld
	bcs		adc_test_err
;	bvs		adc_test_err
	bmi		adc_test_err
	cmp		#$63
	bne		adc_test_err

	jmp		sbc_test

adc_test_err:
	jmp		error_end

adc_dat0:
	fcb		$33

;
; sbc inst test
;
sbc_test:
	; binary mode
	sec
	cld
	lda		#$cd
	sbc		#$34	; immediate
	bcc		sbc_test_err
	bvs		sbc_test_err
	bpl		sbc_test_err
	cmp		#$99
	bne		sbc_test_err

	sec
	lda		#$00
	sbc		sbc_dat0	; absolute
	bcs		sbc_test_err
	bvs		sbc_test_err
	bpl		sbc_test_err
	cmp		#$f0
	bne		sbc_test_err

	; decimal mode
	sec
	sed		; decimal
	lda		#$41
	sbc		#$13
	cld
	bcc		sbc_test_err
;	bvc		sbc_test_err
	bmi		sbc_test_err
	cmp		#$28
	bne		sbc_test_err

	jmp		cmp_test

sbc_test_err:
	jmp		error_end

sbc_dat0:
	fcb		$10

;
; cmp inst test
;
cmp_test:
	; cmp
	lda		#$01
	cmp		#$02	; immediate
	bcs		cmp_test_err
	bpl		cmp_test_err
	beq		cmp_test_err
	cmp		#$01
	bne		cmp_test_err

	lda		#$a5
	cmp		cmp_dat0	; absolute
	bcc		cmp_test_err
	bmi		cmp_test_err
	bne		cmp_test_err
	cmp		#$a5
	bne		cmp_test_err

	; cpx
	ldx		#$5a
	cpx		#$11	; immediate
	bcc		cmp_test_err
	bmi		cmp_test_err
	beq		cmp_test_err
	cpx		#$5a
	bne		cmp_test_err

	ldx		#$88
	cpx		cmp_dat1	; absolute
	bcc		cmp_test_err
	bmi		cmp_test_err
	beq		cmp_test_err
	cpx		#$88
	bne		cmp_test_err

	; cpy
	ldy		#$a5
	cpy		#$06		; immediate
	bcc		cmp_test_err
	bpl		cmp_test_err
	beq		cmp_test_err
	cpy		#$a5
	bne		cmp_test_err

	ldy		#$00
	cpy		cmp_dat2	; absolute
	bcc		cmp_test_err
	bmi		cmp_test_err
	bne		cmp_test_err
	cpy		#$00
	bne		cmp_test_err

	jmp		dec_test

cmp_test_err:
	jmp		error_end

cmp_dat0:
	fcb		$a5
cmp_dat1:
	fcb		$48
cmp_dat2:
	fcb		$00

;
; dec inst test
;
dec_test:
	; dec
	dec		dec_dat0	; absolute
	beq		dec_test_err
	bpl		dec_test_err
	lda		dec_dat0
	cmp		#$ff
	bne		dec_test_err

	; dex
	ldx		#$80
	dex
	beq		dec_test_err
	bmi		dec_test_err
	cpx		#$7f
	bne		dec_test_err

	; dey
	ldy		#$01
	dey
	bne		dec_test_err
	bmi		dec_test_err
	cpy		#$00
	bne		dec_test_err

	jmp		inc_test

dec_test_err:
	jmp		error_end

dec_dat0:
	fcb		$00

;
; inc inst test
;
inc_test:
	; inc
	inc		inc_dat0	; absolute
	bne		inc_test_err
	bmi		inc_test_err
	lda		inc_dat0
	cmp		#$00
	bne		inc_test_err

	; inx
	ldx		#$7f
	inx
	beq		inc_test_err
	bpl		inc_test_err
	cpx		#$80
	bne		inc_test_err

	; iny
	ldy		#$00
	iny
	beq		inc_test_err
	bmi		inc_test_err
	cpy		#$01
	bne		inc_test_err

	jmp		sft_test

inc_test_err:
	jmp		error_end

inc_dat0:
	fcb		$ff

;
; shift & rotate inst test
;
sft_test:
	; asl
	sec
	lda		#$01
	asl		a
	bcs		sft_test_err
	bmi		sft_test_err
	beq		sft_test_err
	cmp		#$02
	bne		sft_test_err

	clc
	asl		sft_dat0	; absolute
	bcc		sft_test_err
	bmi		sft_test_err
	beq		sft_test_err
	lda		sft_dat0
	cmp		#$4a
	bne		sft_test_err

	; lsr
	clc
	lda		#$81
	lsr		a
	bcc		sft_test_err
	bmi		sft_test_err
	beq		sft_test_err
	cmp		#$40
	bne		sft_test_err

	clc
	lsr		sft_dat1	; absolute
	bcc		sft_test_err
	bmi		sft_test_err
	bne		sft_test_err
	lda		sft_dat1
	cmp		#$00
	bne		sft_test_err

	; rol
	sec
	lda		#$01
	rol		a
	bcs		sft_test_err
	bmi		sft_test_err
	beq		sft_test_err
	cmp		#$03
	bne		sft_test_err

	clc
	rol		sft_dat2	; absolute
	bcs		sft_test_err
	bmi		sft_test_err
	bne		sft_test_err
	lda		sft_dat2
	cmp		#$00
	bne		sft_test_err

	; ror
	clc
	lda		#$ff
	ror		a
	bcc		sft_test_err
	bmi		sft_test_err
	beq		sft_test_err
	cmp		#$7f
	bne		sft_test_err

	sec
	ror		sft_dat3	; absolute
	bcs		sft_test_err
	bpl		sft_test_err
	beq		sft_test_err
	lda		sft_dat3
	cmp		#$ad
	bne		sft_test_err

	jmp		jmp_test

sft_test_err:
	jmp		error_end

sft_dat0:
	fcb		$a5
sft_dat1:
	fcb		$01
sft_dat2:
	fcb		$00
sft_dat3:
	fcb		$5a

;
; jmp inst test
;
jmp_test:
	jmp		(jmp_dat0)
	jmp		jmp_test_err

jmp_test0:

	jmp		jsr_test

jmp_test_err:
	jmp		error_end

jmp_dat0:
	fdb		jmp_test0

;
; jsr & rts inst test
;
jsr_test:
	jsr		jsr_test1
	jmp		brk_test

jsr_test2:
	rts
jsr_test1:
	jmp		jsr_test2

jsr_test_err:
	jmp		error_end

;
; brk inst test
;
brk_test:
	brk
	nop				; skip one byte
	lda		brk_dat0
	cmp		#$00
	bne		brk_test_err

	jmp		irq_test

brk_test_err:
	jmp		error_end

brk_dat0:
	fcb		$ff

;
; irq, nmi test
;
irq_test:
	cli
	lda		#$01
	sta		$e000	; IRQ !!!
	nop
	nop
	nop
	lda		irq_dat0
	cmp		#$00
	bne		irq_test_err
	lda		irq_dat1
	cmp		#$00
	bne		irq_test_err

	jmp		stop	; temporary

irq_test_err:
	jmp		error_end

irq_dat0:
	fcb		$ff
irq_dat1:
	fcb		$ff

;
; IRQ/BRK handler
;
irq_hnd:
	php				; PSR -> stack
	pla				; stack -> A
	tax				; A -> X
	and		#$10	; bit4
	bne		brk_hnd
	txa				; X -> A
	and		#$04	; bit2
	beq		irq_hnd1
	lda		#$00	; ok
	jmp		irq_hnd2
irq_hnd1:
	lda		#$01	; error
irq_hnd2:
	sta		irq_dat0
	lda		#$01
	sta		$e001	; NMI !!!
	nop
	nop
	nop
	lda		#$00
	sta		$e000
	rti

brk_hnd:
	txa				; X -> A
	and		#$04	; bit2
	beq		brk_hnd1
	txa				; X -> A
	and		#$08	; bit3
	bne		brk_hnd1
	lda		#$00	; ok
	jmp		brk_hnd2
brk_hnd1:
	lda		#$01	; error
brk_hnd2:
	sta		brk_dat0
	rti

;
; NMI handler
;
nmi_hnd:
	lda		#$00
	sta		$e001
	sta		irq_dat1
	rti

;
; error not detected
;
stop:
	jmp		stop

	org	$fffa
	fdb	nmi_hnd
	fdb	start
	fdb	irq_hnd

; End of test.s
