//
// ac6502_top.v
//
// ac6502 processor core
//
// Version 0.6
//
// Copyright 2008, Hideyuki Abe. All rights reserved.
// Distributed under the terms of the MIT License.
//


module ac6502_top(
	clk,
	rst,
	irq,
	nmi,
	addr,
	wdata,
	rdata,
	en,
	wen,
	ack
);

input	clk;
input	rst;
input	irq;
input	nmi;
output [15:0]	addr;
output [7:0]	wdata;
input [7:0]	rdata;
output	en;
output	wen;
input	ack;


wire [15:0]	addra;
wire [7:0]	rdataa;
wire	ena;
wire	acka;
wire [15:0]	addra_i;
wire	ena_i;
wire	acka_i;
wire [15:0]	pc_nxt;
wire [7:0]	inst1;
wire [7:0]	inst2;
wire [7:0]	inst3;

wire [15:0]	new_pc;

wire [15:0]	addrb;
wire [7:0]	wdatab;
wire [7:0]	rdatab;
wire	wenb;
wire	enb;
wire	ackb;
wire [15:0]	addrb_i;
wire [7:0]	wdatab_i;
wire	wenb_i;
wire	enb_i;
wire	ackb_i;


ac6502_bus_mux bus_mux0(
	.clk(clk),
	.rst(rst),
	.addr(addr),
	.wdata(wdata),
	.rdata(rdata),
	.en(en),
	.wen(wen),
	.ack(ack),
	.addra(addra),
	.rdataa(rdataa),
	.ena(ena),
	.acka(acka),
	.addrb(addrb),
	.wdatab(wdatab),
	.rdatab(rdatab),
	.wenb(wenb),
	.enb(enb),
	.ackb(ackb)
);

ac6502_bus2memr bus2memr0(
	.clk(clk),
	.rst(rst),
	.addr_i(addra_i),
	.en_i(ena_i),
	.ack_i(acka_i),
	.addr_o(addra),
	.en_o(ena),
	.ack_o(acka)
);

ac6502_fetch fetch0(
	.clk(clk),
	.rst(rst),
	.addr(addra_i),
	.rdata(rdataa),
	.en(ena_i),
	.ack(acka_i),
	.pc_nxt(pc_nxt),
	.inst1(inst1),
	.inst2(inst2),
	.inst3(inst3),
	.inst_rdy(inst_rdy),
	.inst_ack(inst_ack),
	.jmp_req(jmp_req),
	.jmp_ack(jmp_ack),
	.new_pc(new_pc)
);

ac6502_bus2mem bus2mem0(
	.clk(clk),
	.rst(rst),
	.addr_i(addrb_i),
	.wdata_i(wdatab_i),
	.en_i(enb_i),
	.wen_i(wenb_i),
	.ack_i(ackb_i),
	.addr_o(addrb),
	.wdata_o(wdatab),
	.en_o(enb),
	.wen_o(wenb),
	.ack_o(ackb)
);

ac6502_exe exe0(
	.clk(clk),
	.rst(rst),
	.irq(irq),
	.nmi(nmi),
	.pc_nxt(pc_nxt),
	.inst1(inst1),
	.inst2(inst2),
	.inst3(inst3),
	.inst_rdy(inst_rdy),
	.inst_ack(inst_ack),
	.jmp_req(jmp_req),
	.jmp_ack(jmp_ack),
	.new_pc(new_pc),
	.addr(addrb_i),
	.wdata(wdatab_i),
	.rdata(rdatab),
	.wen(wenb_i),
	.en(enb_i),
	.ack(ackb_i)
);

endmodule

// End of ac6502_top.v
