//
// ac6502_tb.v
//
// ac6502 processor core
//
// Version 0.6
//
// Copyright 2008, Hideyuki Abe. All rights reserved.
// Distributed under the terms of the MIT License.
//

//`define	MEM_CYC	(2'b01)	// no wait (one cycle)
`define	MEM_CYC	(2'b10)	// one wait (two cycle)

module ac6502_tb;

reg	clk;
reg	rst;
reg	irq;
reg	nmi;

wire [15:0]	addr;
wire [7:0]	wdata;
wire [7:0]	rdata;
wire	en;
wire	wen;
wire	ack;
reg [1:0]	mwt;


always begin
	#5	clk = ~clk;
end

always @(posedge clk or negedge rst) begin
	if(~rst)
		irq <= 1'b0;
	else if(en & wen & addr == 16'he000)
		irq <= wdata[0];
end

always @(posedge clk or negedge rst) begin
	if(~rst)
		nmi = 1'b0;
	else if(en & wen & addr == 16'he001)
		nmi <= wdata[0];
end

initial begin
	clk = 1'b1;
	rst = 1'b0;
	#10	;
	#1	rst = 1'b1;
	#(10 * 3000)	;
//	#(10 * 15000)	;
	$finish;
end

ac6502_top ac6502_top0(
	.clk(clk),
	.rst(rst),
	.irq(irq),
	.nmi(nmi),
	.addr(addr),
	.wdata(wdata),
	.rdata(rdata),
	.en(en),
	.wen(wen),
	.ack(ack)
);

// count memory cycle
always @(posedge clk or negedge rst) begin
	if(~rst) begin
		mwt <= 2'b00;
	end
	else if(en) begin
		if(mwt == `MEM_CYC)
			mwt <= 2'b01;
		else
			mwt <= mwt + 2'b01;
	end
	else begin
		mwt <= 2'b00;
	end
end

assign	ack = (mwt == `MEM_CYC);

sync_ram ram0(
	.clk(clk),
	.addr(addr),
	.wdata(wdata),
	.ceb(~en),
	.web(~wen),
	.rdata(rdata)
);

initial begin
	$readmemh("test.dat", ram0.mem);
end


initial begin
	$dumpfile("ac6502_tb.vcd");
	$dumpvars(0, ac6502_tb);
end

endmodule

// ac6502_tb.v
