//
// ac6502_exe.v
//
// ac6502 processor core
//
// Version 0.6
//
// Copyright 2008, Hideyuki Abe. All rights reserved.
// Distributed under the terms of the MIT License.
//

`include "ac6502_defs.v"

module ac6502_exe(
	clk,
	rst,
	irq,
	nmi,
	pc_nxt,
	inst1,
	inst2,
	inst3,
	inst_rdy,
	inst_ack,
	jmp_req,
	jmp_ack,
	new_pc,
	addr,
	wdata,
	rdata,
	wen,
	en,
	ack
);

input	clk;
input	rst;
input	irq;
input	nmi;
input [15:0]	pc_nxt;
input [7:0]	inst1;
input [7:0]	inst2;
input [7:0]	inst3;
input	inst_rdy;
output	inst_ack;
output	jmp_req;
input	jmp_ack;
output [15:0]	new_pc;
output [15:0]	addr;
output [7:0]	wdata;
input [7:0]	rdata;
output	wen;
output	en;
input	ack;

wire [7:0]	inst1_r;
wire [`PCMUX_LEN - 1:0]	pc_mux;
wire [`CPCMUX_LEN - 1:0]	cpc_mux;
wire [`ACCMUX_LEN - 1:0]	acc_mux;
wire [`IXMUX_LEN - 1:0]	ix_mux;
wire [`IYMUX_LEN - 1:0]	iy_mux;
wire [`SPMUX_LEN - 1:0]	sp_mux;
wire [`PSRMUX_LEN - 1:0]	psr_mux;
wire [`BSMUX_LEN - 1:0]	bus_mux;
wire [`BAMUX_LEN - 1:0]	ba_mux;
wire [`EAMUX_LEN - 1:0]	ea_mux;
wire [`WDMUX_LEN - 1:0]	wd_mux;
wire [`TMUX_LEN - 1:0]	tmp_mux;
wire [`T16MUX_LEN - 1:0]	tmp16_mux;
wire [`ALUOP_LEN - 1:0]	op_sel;
wire [`AMUX_LEN - 1:0]	ina_mux;
wire [`BMUX_LEN - 1:0]	inb_mux;
wire [7:0]	ina;
wire [7:0]	inb;
wire [7:0]	outa;
wire [7:0]	outb;
wire [3:0]	upd_flg;
wire [`COND_LEN - 1:0]	cond;


ac6502_exe_ctrl exe_ctrl0(
	.clk(clk),
	.rst(rst),
	.irq(irq),
	.nmi(nmi),
	.inst1(inst1),
	.inst1_r(inst1_r),
	.inst_rdy(inst_rdy),
	.inst_ack(inst_ack),
	.jmp_req(jmp_req),
	.jmp_ack(jmp_ack),
	.pc_mux(pc_mux),
	.cpc_mux(cpc_mux),
	.acc_mux(acc_mux),
	.ix_mux(ix_mux),
	.iy_mux(iy_mux),
	.sp_mux(sp_mux),
	.psr_mux(psr_mux),
	.bus_mux(bus_mux),
	.ba_mux(ba_mux),
	.ea_mux(ea_mux),
	.ea_sav(ea_sav),
	.wd_mux(wd_mux),
	.tmp_mux(tmp_mux),
	.tmp16_mux(tmp16_mux),
	.op_sel(op_sel),
	.ina_mux(ina_mux),
	.inb_mux(inb_mux),
	.upd_flg(upd_flg),
	.cond(cond),
	.ctrue(ctrue),
	.dec_bit(dec_bit),
	.imsk_bit(imsk_bit),
	.ack(ack)
);

ac6502_exe_data exe_data0(
	.clk(clk),
	.rst(rst),
	.pc_nxt(pc_nxt),
	.inst1(inst1),
	.inst2(inst2),
	.inst3(inst3),
	.inst1_r(inst1_r),
	.inst_ack(inst_ack),
	.new_pc(new_pc),
	.pc_mux(pc_mux),
	.cpc_mux(cpc_mux),
	.acc_mux(acc_mux),
	.ix_mux(ix_mux),
	.iy_mux(iy_mux),
	.sp_mux(sp_mux),
	.psr_mux(psr_mux),
	.bus_mux(bus_mux),
	.ba_mux(ba_mux),
	.ea_mux(ea_mux),
	.ea_sav(ea_sav),
	.wd_mux(wd_mux),
	.tmp_mux(tmp_mux),
	.tmp16_mux(tmp16_mux),
	.ina_mux(ina_mux),
	.inb_mux(inb_mux),
	.ina(ina),
	.inb(inb),
	.cy_bit(cy_bit),
	.outa(outa),
	.outb(outb),
	.new_cy(new_cy),
	.new_ov(new_ov),
	.new_neg(new_neg),
	.new_zero(new_zero),
	.upd_flg(upd_flg),
	.cond(cond),
	.ctrue(ctrue),
	.dec_bit(dec_bit),
	.imsk_bit(imsk_bit),
	.addr(addr),
	.wdata(wdata),
	.rdata(rdata),
	.en(en),
	.wen(wen)
);

ac6502_exe_alu exe_alu0(
	.op_sel(op_sel),
	.ina(ina),
	.inb(inb),
	.cy_bit(cy_bit),
	.outa(outa),
	.outb(outb),
	.new_cy(new_cy),
	.new_ov(new_ov),
	.new_neg(new_neg),
	.new_zero(new_zero)
);

endmodule


// End of ac6502_exe.v
