//
// ac6502_defs.v
//
// ac6502 processor core
//
// Version 0.6
//
// Copyright 2008, Hideyuki Abe. All rights reserved.
// Distributed under the terms of the MIT License.
//

// pc_mux definictions
`define	PCMUX_LEN	3
`define	PCMUX_ZERO	3'b000
`define	PCMUX_TMP16	3'b001
`define	PCMUX_ABS	3'b010
`define	PCMUX_REL	3'b011
`define	PCMUX_RTS	3'b100

// cpc_mux definitions
`define	CPCMUX_LEN	2
`define	CPCMUX_NULL	2'b00
`define	CPCMUX_PCR	2'b01
`define	CPCMUX_PCN	2'b10

// acc_mux definitions
`define	ACCMUX_LEN	2
`define	ACCMUX_NULL	2'b00
`define	ACCMUX_OUTA	2'b01

// ix_mux definitions
`define	IXMUX_LEN	2
`define	IXMUX_NULL	2'b00
`define	IXMUX_OUTA	2'b01

// iy_mux definitions
`define	IYMUX_LEN	2
`define	IYMUX_NULL	2'b00
`define	IYMUX_OUTA	2'b01

// sp_mux definitions
`define	SPMUX_LEN	2
`define	SPMUX_NULL	2'b00
`define	SPMUX_OUTA	2'b01
`define	SPMUX_INC	2'b10
`define	SPMUX_DEC	2'b11

// psr_mux definitions
`define	PSRMUX_LEN	4
`define	PSRMUX_NULL	4'b0000
`define	PSRMUX_CLI	4'b0001
`define	PSRMUX_SEI	4'b0010
`define	PSRMUX_CLD	4'b0011
`define	PSRMUX_SED	4'b0100
`define	PSRMUX_OUTA	4'b0101
`define	PSRMUX_RDAT	4'b0110
`define	PSRMUX_BRK	4'b0111
`define	PSRMUX_IRQ	4'b1000

// bus_mux definitions
`define	BSMUX_LEN	2
`define	BSMUX_NULL	2'b00
`define	BSMUX_RD	2'b01
`define	BSMUX_WR	2'b10

// ba_mux definitions
`define	BAMUX_LEN		4
`define	BAMUX_ZERO		4'b0000
`define	BAMUX_RSTL		4'b0001
`define	BAMUX_RSTH		4'b0010
`define	BAMUX_ABS		4'b0011
`define	BAMUX_ZP		4'b0100
`define	BAMUX_ZPEA		4'b0101
`define	BAMUX_TMP16		4'b0110
`define	BAMUX_EA		4'b0111
`define	BAMUX_SP		4'b1000
`define	BAMUX_SPEA		4'b1001
`define	BAMUX_IRQL		4'b1010
`define	BAMUX_IRQH		4'b1011
`define	BAMUX_NMIL		4'b1100
`define	BAMUX_NMIH		4'b1101

// ea_mux definitions
`define	EAMUX_LEN		4
`define	EAMUX_NULL		4'b0000
`define	EAMUX_ZPX		4'b0001
`define	EAMUX_ABSX		4'b0010
`define	EAMUX_ZP_1		4'b0011
`define	EAMUX_TMP16Y	4'b0100
`define	EAMUX_ABSY		4'b0101
`define	EAMUX_ABS_1		4'b0110
`define	EAMUX_SP_1		4'b0111
`define	EAMUX_INCZP		4'b1000

// wd_mux definitions
`define	WDMUX_LEN	4
`define	WDMUX_ZERO	4'b0000
`define	WDMUX_ACC	4'b0001
`define	WDMUX_IX	4'b0010
`define	WDMUX_IY	4'b0011
`define	WDMUX_PSR	4'b0100
`define	WDMUX_OUTA	4'b0101
`define	WDMUX_JSRH	4'b0110
`define	WDMUX_JSRL	4'b0111
`define	WDMUX_BRKH	4'b1000
`define	WDMUX_BRKL	4'b1001
`define	WDMUX_CPCH	4'b1010
`define	WDMUX_CPCL	4'b1011

// tmp_mux definitions
`define	TMUX_LEN	2
`define	TMUX_NULL	2'b00
`define	TMUX_RDAT	2'b01

// tmp16_mux definitions
`define	T16MUX_LEN	2
`define	T16MUX_NULL		2'b00
`define	T16MUX_RDATL	2'b01
`define	T16MUX_RDATH	2'b10

// op_sel definitions
`define	ALUOP_LEN	5
`define	ALUOP_NULL	5'b00000
`define	ALUOP_ADD	5'b00001
`define	ALUOP_SUB	5'b00010
`define	ALUOP_ADC	5'b00011
`define	ALUOP_SBC	5'b00100
`define	ALUOP_ADCD	5'b00101
`define	ALUOP_SBCD	5'b00110
`define	ALUOP_THR	5'b00111
`define	ALUOP_OR	5'b01000
`define	ALUOP_AND	5'b01001
`define	ALUOP_EOR	5'b01010
`define	ALUOP_CLFLG	5'b01011
`define	ALUOP_SEFLG	5'b01100
`define	ALUOP_ASL	5'b01101
`define	ALUOP_LSR	5'b01110
`define	ALUOP_ROL	5'b01111
`define	ALUOP_ROR	5'b10000
`define	ALUOP_BIT	5'b10001

// ina_mux definitions
`define	AMUX_LEN	3
`define	AMUX_ZERO	3'b000
`define	AMUX_ACC	3'b001
`define	AMUX_INST2	3'b010
`define	AMUX_RDAT	3'b011
`define	AMUX_IX		3'b100
`define	AMUX_IY		3'b101
`define	AMUX_SP		3'b110

// inb_mux definitions
`define	BMUX_LEN	2
`define	BMUX_ZERO	2'b00
`define	BMUX_INST2	2'b01
`define	BMUX_RDAT	2'b10
`define	BMUX_ONE	2'b11

// cond definictions
`define	COND_LEN	3
`define	COND_PL		3'b000
`define	COND_MI		3'b001
`define	COND_VC		3'b010
`define	COND_VS		3'b011
`define	COND_CC		3'b100
`define	COND_CS		3'b101
`define	COND_NEQ	3'b110
`define	COND_EQ		3'b111

// opcode definitions
`define	OPC_ADC_EA	5'b011____01	// 61,65,6D,71,75,79,7D
`define	OPC_ADC_IMM	8'b0110_1001	// 69
`define	OPC_AND_EA	5'b001____01	// 21,25,2D,31,35,39,3D
`define	OPC_AND_IMM	8'b0010_1001	// 29
`define	OPC_ASL_EA	5'b000____10	// 06,0E,16,1E
`define	OPC_ASL_A	8'b0000_1010	// 0A
`define	OPC_BCOND	   5'b1_0000	// 10,30,50,70,90,B0,D0,F0
`define	OPC_BIT_EA	5'b001____00	// 24,2C
`define	OPC_BRK		8'b0000_0000	// 00
`define	OPC_CLC		8'b0001_1000	// 18
`define	OPC_CLD		8'b1101_1000	// D8
`define	OPC_CLI		8'b0101_1000	// 58
`define	OPC_CLV		8'b1011_1000	// B8
`define	OPC_CMP_EA	5'b110____01	// C1,C5,CD,D1,D5,D9,DD
`define	OPC_CMP_IMM	8'b1100_1001	// C9
`define	OPC_CPX_EA	5'b111____00	// E4,EC
`define	OPC_CPX_IMM	8'b1110_0000	// E0
`define	OPC_CPY_EA	5'b110____00	// C4,CC
`define	OPC_CPY_IMM	8'b1100_0000	// C0
`define	OPC_DEC_EA	5'b110____10	// C6,CE,D6,DE
`define	OPC_DEX		8'b1100_1010	// CA
`define	OPC_DEY		8'b1000_1000	// 88
`define	OPC_EOR_EA	5'b010____01	// 41,45,4D,51,55,59,5D
`define	OPC_EOR_IMM	8'b0100_1001	// 49
`define	OPC_INC_EA	5'b111____10	// E6,EE,F6,FE
`define	OPC_INX		8'b1110_1000	// E8
`define	OPC_INY		8'b1100_1000	// C8
`define	OPC_JMP_ABS	8'b0100_1100	// 4C
`define	OPC_JMP_IND	8'b0110_1100	// 6C
`define	OPC_JSR		8'b0010_0000	// 20
`define	OPC_LDA_EA	5'b101____01	// A1,A5,AD,B1,B5,B9,AD
`define	OPC_LDA_IMM	8'b1010_1001	// A9
`define	OPC_LDX_EA	5'b101____10	// A6,AE,B6,BE
`define	OPC_LDX_IMM	8'b1010_0010	// A2
`define	OPC_LDY_EA	5'b101____00	// A4,AC,B4,BC
`define	OPC_LDY_IMM	8'b1010_0000	// A0
`define	OPC_LSR_EA	5'b010____10	// 46,4E,56,5E
`define	OPC_LSR_A	8'b0100_1010	// 4A
`define	OPC_NOP		8'b1110_1010	// EA
`define	OPC_ORA_EA	5'b000____01	// 01,05,0D,11,15,19,1D
`define	OPC_ORA_IMM	8'b0000_1001	// 09
`define	OPC_PHA		8'b0100_1000	// 48
`define	OPC_PHP		8'b0000_1000	// 08
`define	OPC_PHX		8'b1101_1010	// DA
`define	OPC_PHY		8'b0101_1010	// 5A
`define	OPC_PLA		8'b0110_1000	// 68
`define	OPC_PLP		8'b0010_1000	// 28
`define	OPC_PLX		8'b1111_1010	// FA
`define	OPC_PLY		8'b0111_1010	// 7A
`define	OPC_ROL_EA	5'b001____10	// 26,2E,36,3E
`define	OPC_ROL_A	8'b0010_1010	// 2A
`define	OPC_ROR_EA	5'b011____10	// 66,6E,76,7E
`define	OPC_ROR_A	8'b0110_1010	// 6A
`define	OPC_RTI		8'b0100_0000	// 40
`define	OPC_RTS		8'b0110_0000	// 60
`define	OPC_SBC_EA	8'b111____01	// E1,E5,ED,F1,F5,F9,FD
`define	OPC_SBC_IMM	8'b1110_1001	// E9
`define	OPC_SEC		8'b0011_1000	// 38
`define	OPC_SED		8'b1111_1000	// F8
`define	OPC_SEI		8'b0111_1000	// 78
`define	OPC_STA_EA	5'b100____01	// 81,85,8D,91,95,99,9D
`define	OPC_STX_EA	5'b100____10	// 86,8E,96
`define	OPC_STY_EA	5'b100____00	// 84,8C,94
`define	OPC_TAX		8'b1010_1010	// AA
`define	OPC_TAY		8'b1010_1000	// A8
`define	OPC_TSX		8'b1011_1010	// BA
`define	OPC_TXA		8'b1000_1010	// 8A
`define	OPC_TXS		8'b1001_1010	// 9A
`define	OPC_TYA		8'b1001_1000	// 98

// End of ac6502_defs.v
