//
// ac6502_bus_mux.v
//
// ac6502 processor core
//
// Version 0.6
//
// Copyright 2008, Hideyuki Abe. All rights reserved.
// Distributed under the terms of the MIT License.
//

module ac6502_bus_mux(
	clk,
	rst,
	addr,
	wdata,
	rdata,
	en,
	wen,
	ack,
	addra,
	rdataa,
	ena,
	acka,
	addrb,
	wdatab,
	rdatab,
	wenb,
	enb,
	ackb
);

input	clk;
input	rst;
output [15:0]	addr;
output [7:0]	wdata;
input [7:0]	rdata;
output	en;
output	wen;
input	ack;
input [15:0]	addra;
output [7:0]	rdataa;
input	ena;
output	acka;
input [15:0]	addrb;
input [7:0]	wdatab;
output [7:0]	rdatab;
input	wenb;
input	enb;
output	ackb;

wire	mst_chg;

reg	ena_r;
reg	enb_r;
wire	ena_s;
wire	enb_s;
reg	acka;
reg	ackb;


assign	mst_chg = ack | ~(ena_r | enb_r);

always @(posedge clk or negedge rst) begin
	if(~rst) begin
		ena_r <= 1'b0;
	end
	// lower priority
	else if(mst_chg & ena & ~enb) begin
		ena_r <= 1'b1;
	end
	else if(acka) begin
		ena_r <= 1'b0;
	end
end

always @(posedge clk or negedge rst) begin
	if(~rst) begin
		enb_r <= 1'b0;
	end
	// higher priority
	else if(mst_chg & enb) begin
		enb_r <= 1'b1;
	end
	else if(ackb) begin
		enb_r <= 1'b0;
	end
end

always @(ena_r or enb_r or ack) begin
	if(enb_r) begin
		acka = 1'b0;
		ackb = ack;
	end
	else if(ena_r) begin
		acka = ack;
		ackb = 1'b0;
	end
	else begin
		acka = 1'b0;
		ackb = 1'b0;
	end
end	// always comb

assign	ena_s = (mst_chg) ? ena : ena_r;
assign	enb_s = (mst_chg) ? enb : enb_r;

assign	addr = enb_s ? addrb : addra;

assign	wdata = wdatab;

assign	rdataa = rdata;
assign	rdatab = rdata;

assign	en = enb_s | ena_s;

assign	wen = enb_s ? wenb : 1'b0;

endmodule

// End of ac6502_bus_mux.v
