//
// ac6502_bus2mem.v
//
// ac6502 processor core
//
// Version 0.6
//
// Copyright 2008, Hideyuki Abe. All rights reserved.
// Distributed under the terms of the MIT License.
//

module ac6502_bus2mem(
	clk,
	rst,
	addr_i,
	wdata_i,
	en_i,
	wen_i,
	ack_i,
	addr_o,
	wdata_o,
	en_o,
	wen_o,
	ack_o
);

input	clk;
input	rst;
input [15:0]	addr_i;
input [7:0]	wdata_i;
input	en_i;
input	wen_i;
output	ack_i;
output [15:0]	addr_o;
output [7:0]	wdata_o;
output	en_o;
output	wen_o;
input	ack_o;

reg [15:0]	addr_o;
reg [7:0]	wdata_o;
reg	en_o;
reg	wen_o;

reg [15:0]	addr_r;
reg [7:0]	wdata_r;
reg	en_r;
reg	wen_r;

always @(posedge clk or negedge rst) begin
	if(~rst) begin
		addr_r <= 16'h0000;
		wdata_r <= 8'h00;
		en_r <= 1'b0;
		wen_r <= 1'b0;
	end
	else if(en_i) begin
		addr_r <= addr_i;
		wdata_r <= wdata_i;
		en_r <= 1'b1;
		wen_r <= wen_i;
	end
	else if(ack_o) begin
		en_r <= 1'b0;
	end
end

always @(
	addr_i or wdata_i or en_i or wen_i
	or addr_r or wdata_r or en_r or wen_r
	or ack_o
) begin
	if(en_i) begin
		addr_o = addr_i;
		wdata_o = wdata_i;
		en_o = en_i;
		wen_o = wen_i;
	end
	else if(ack_o) begin
		addr_o = 16'h0000;
		wdata_o = 8'h00;
		en_o = 1'b0;
		wen_o = 1'b0;
	end
	else if(en_r) begin
		addr_o = addr_r;
		wdata_o = wdata_r;
		en_o = en_r;
		wen_o = wen_r;
	end
	else begin
		addr_o = 16'h0000;
		wdata_o = 8'h00;
		en_o = 1'b0;
		wen_o = 1'b0;
	end
end	// always comb

assign	ack_i = ack_o;

endmodule

// End of ac6502_bus2mem.v
