;
; test.a51
;
; c51 microcontroller core
;
; Version 0.6
;
; Copyright 2008, Hideyuki Abe. All rights reserved.
; Distributed under the terms of the MIT License.
;


	.area	HOME	(CODE)
	.area	CODE	(ABS)

	.org	0
	ljmp	test_start

	.org	0x0003
	ljmp	irq0hdl

	.org	0x000b
	ljmp	irq1hdl

	.org	0x0013
	ljmp	irq2hdl

	.org	0x001b
	ljmp	irq3hdl

	.org	0x0023
	ljmp	irq4hdl

	.org	0x002b
	ljmp	irq5hdl

	.org	0x0100
test_error:
	sjmp	test_error

test_start:
;
; Initial test
;
ini_test:
	cjne	a,#0x00,ini_error

	mov		a,psw
	cjne	a,#0x00,ini_error

	mov		a,sp
	cjne	a,#0x07,ini_error

	ljmp	mov_test

ini_error:
	ljmp	test_error

;
; MOV test
;
mov_test:
	; set bank0
	clr		rs0
	clr		rs1

	mov		a,#0x55		; mov a,#data
	cjne	a,#0x55,mov1_error

	mov		0x00,#0xaa
	mov		a,r0		; mov a,rn
	cjne	a,#0xaa,mov1_error

	mov		0x10,#0x5a
	mov		a,0x10		; mov a,direct
	cjne	a,#0x5a,mov1_error

	mov		r1,#0x35
	mov		0x35,#0xa5
	mov		a,@r1		; mov a,@ri
	cjne	a,#0xa5,mov1_error

	; set bank2
	clr		rs0
	setb	rs1

	mov		a,#0xff
	mov		r4,a		; mov rn,a
	cjne	r4,#0xff,mov1_error

	mov		0x37,#0x12
	mov		r6,0x37		; mov rn,direct
	cjne	r6,#0x12,mov1_error

	mov		r2,#0x34	; mov rn,#data
	mov		a,0x12
	cjne	a,#0x34,mov1_error

	sjmp	mov2_test

mov1_error:
	ljmp	test_error

mov2_test:
	; set bank0
	clr		rs0
	clr		rs1

	mov		a,#0x56
	mov		0x15,a		; mov direct,a
	mov		r3,0x15
	cjne	r3,#0x56,mov2_error

	mov		r5,#0x78
	mov		0x33,r5		; mov direct,rn
	mov		a,0x33
	cjne	a,#0x78,mov2_error

	mov		r7,#0x9a
	mov		0x17,0x07	; mov direct,direct
	mov		a,0x17
	cjne	a,#0x9a,mov2_error

	mov		r0,#0x14
	mov		0x14,#0xbc
	mov		0x22,@r0	; mov direct,@ri
	mov		a,0x14
	cjne	a,#0xbc,mov2_error

	mov		0x30,#0xde	; mov direct,#data
	mov		a,0x30
	cjne	a,#0xde,mov2_error

	mov		r1,#0x22
	mov		0x22,#0x00
	mov		a,#0xf0
	mov		@r1,a		; mov @ri,a
	mov		r3,0x22
	cjne	r3,#0xf0,mov2_error

	mov		0x11,#0x13
	mov		r0,#0x33
	mov		@r0,0x11	; mov @ri,direct
	mov		a,0x33
	cjne	a,#0x13,mov2_error

	mov		r1,#0x15
	mov		@r1,#0x24	; mov @ri,#data
	mov		a,0x15
	cjne	a,#0x24,mov2_error

	mov		dptr,#0x55aa	; mov dptr,#data16
	mov		a,dph
	cjne	a,#0x55,mov2_error
	mov		a,dpl
	cjne	a,#0xaa,mov2_error

	mov		dptr,#mov_dat0
	mov		a,#1
	movc	a,@a+dptr	; movc a,@a+dptr
	cjne	a,#0xaa,mov2_error

	mov		a,#(mov_dat0-mov2_tst2)
	movc	a,@a+pc		; movc a,@a+pc
mov2_tst2:
	cjne	a,#0x55,mov2_error

	sjmp	mov3_test

mov_dat0:
	.db		0x55
mov_dat1:
	.db		0xaa

mov2_error:
	ljmp	test_error

mov3_test:
	mov		p2,#0x00
	mov		r0,#0x45
	mov		a,#0x5a
	movx	@r0,a		; movx @ri,a
	mov		a,#0x00
	mov		dptr,#0x0045
	movx	a,@dptr		; movx a,@dptr
	cjne	a,#0x5a,mov3_error

	mov		dptr,#0x89ab
	mov		a,#0xa5
	movx	@dptr,a		; movx @dptr,a
	mov		a,#0x00
	mov		p2,#0x89
	mov		r1,#0xab
	movx	a,@r1		; movx a,@ri
	cjne	a,#0xa5,mov3_error

	ljmp	stk_test

mov3_error:
	ljmp	test_error

;
; Stack test
;
stk_test:
	mov		a,#0x55
	mov		sp,#0x7f
	push	acc			; push direct
	mov		r0,#0x80
	mov		0x04,@r0
	cjne	r4,#0x55,stk_error
	mov		a,sp
	cjne	a,#0x80,stk_error

	pop		0x06		; pop direct
	cjne	r6,#0x55,stk_error
	mov		a,sp
	cjne	a,#0x7f,stk_error

	ljmp	xch_test

stk_error:
	ljmp	test_error

;
; XCH test
;
xch_test:
	mov		a,#0x55
	mov		r7,#0xaa
	xch		a,r7		; xch a,rn
	cjne	a,#0xaa,xch_error
	cjne	r7,#0x55,xch_error

	mov		a,#0xff
	mov		0x13,#0x5a
	xch		a,0x13		; xch a,direct
	cjne	a,#0x5a,xch_error
	mov		r2,0x13
	cjne	r2,#0xff,xch_error

	mov		a,#0x89
	mov		r1,#0x25
	mov		0x25,#0xab
	xch		a,@r1		; xch a,@ri
	cjne	a,#0xab,xch_error
	mov		r5,0x25
	cjne	r5,#0x89,xch_error

	mov		a,#0x45
	mov		r0,#0x1a
	mov		0x1a,#0xcd
	xchd	a,@r0		; xchd a,@ri
	cjne	a,#0x4d,xch_error
	mov		r4,0x1a
	cjne	r4,#0xc5,xch_error

	ljmp	add_test

xch_error:
	ljmp	test_error

;
; ADD test
;
add_test:
	mov		a,#0x45
	mov		r4,#0x67
	add		a,r4		; add a,rn
	jb		cy,add_error
	jb		ac,add_error
	jnb		ov,add_error
	jb		p,add_error
	cjne	a,#0xac,add_error

	mov		a,#0x86
	mov		0x09,#0x8b
	add		a,0x09		; add a,direct
	jnb		cy,add_error
	jnb		ac,add_error
	jnb		ov,add_error
	jb		p,add_error
	cjne	a,#0x11,add_error

	mov		a,#0x12
	mov		r1,#0x0a
	mov		0x0a,#0x34
	add		a,@r1		; add a,@ri
	jb		cy,add_error
	jb		ac,add_error
	jb		ov,add_error
	jnb		p,add_error
	cjne	a,#0x46,add_error

	mov		a,#0xaa
	add		a,#0x56		; add a,#data
	jnb		cy,add_error
	jnb		ac,add_error
	jb		ov,add_error
	jb		p,add_error
	cjne	a,#0x00,add_error

	ljmp	adc_test

add_error:
	ljmp	test_error

;
; ADDC test
;
adc_test:
	setb	c
	mov		a,#0x67
	mov		r6,#0x13
	addc	a,r6		; addc a,rn
	jb		cy,adc_error
	jb		ac,adc_error
	jb		ov,adc_error
	jb		p,adc_error
	cjne	a,#0x7b,adc_error

	clr		c
	mov		a,#0xf7
	mov		0x08,#0x08
	addc	a,0x08		; addc a,direct
	jb		cy,adc_error
	jb		ac,adc_error
	jb		ov,adc_error
	jb		p,adc_error
	cjne	a,#0xff,adc_error

	setb	c
	mov		a,#0xdf
	mov		r0,#0x14
	mov		0x14,#0x30
	addc	a,@r0		; addc a,@ri
	jnb		cy,adc_error
	jnb		ac,adc_error
	jb		ov,adc_error
	jnb		p,adc_error
	cjne	a,#0x10,adc_error

	clr		c
	mov		a,#0x7f
	addc	a,#0x24		; addc a,#data
	jb		cy,adc_error
	jnb		ac,adc_error
	jnb		ov,adc_error
	jb		p,adc_error
	cjne	a,#0xa3,adc_error

	ljmp	sbb_test

adc_error:
	ljmp	test_error

;
; SUBB test
;
sbb_test:
	setb	c
	mov		a,#0x00
	mov		r7,#0x55
	subb	a,r7		; subb a,rn
	jnb		cy,sbb_error
	jnb		ac,sbb_error
	jb		ov,sbb_error
	jb		p,sbb_error
	cjne	a,#0xaa,sbb_error

	clr		c
	mov		a,#0xaa
	mov		0x0c,#0x77
	subb	a,0x0c		; subb a,direct
	jb		cy,sbb_error
	jb		ac,sbb_error
	jnb		ov,sbb_error
	jb		p,sbb_error
	cjne	a,#0x33,sbb_error

	setb	c
	mov		a,#0x82
	mov		r1,#0x15
	mov		0x15,#0x02
	subb	a,@r1		; subb a,@ri
	jb		cy,sbb_error
	jnb		ac,sbb_error
	jnb		ov,sbb_error
	jnb		p,sbb_error
	cjne	a,#0x7f,sbb_error

	clr		c
	mov		a,#0xcd
	subb	a,#0x5a		; subb a,#data
	jb		cy,sbb_error
	jb		ac,sbb_error
	jnb		ov,sbb_error
	jnb		p,sbb_error
	cjne	a,#0x73,sbb_error

	ljmp	inc_test

sbb_error:
	ljmp	test_error

;
; INC test
;
inc_test:
	mov		a,#0x55
	inc		a			; inc a
	cjne	a,#0x56,inc_error

	mov		r6,#0xff
	inc		r6			; inc rn
	cjne	r6,#0x00,inc_error

	mov		0x22,#0x00
	inc		0x22		; inc direct
	mov		a,0x22
	cjne	a,#0x01,inc_error

	mov		r1,#0x11
	mov		0x11,#0x7f
	inc		@r1			; inc @ri
	mov		a,0x11
	cjne	a,#0x80,inc_error

	mov		dptr,#0x45ff
	inc		dptr		; inc dptr
	mov		a,dpl
	cjne	a,#0x00,inc_error
	mov		a,dph
	cjne	a,#0x46,inc_error

	ljmp	dec_test

inc_error:
	ljmp	test_error

;
; DEC test
;
dec_test:
	mov		a,#0x00
	dec		a			; dec a
	cjne	a,#0xff,dec_error

	mov		r5,#0x80
	dec		r5			; dec rn
	cjne	r5,#0x7f,dec_error

	mov		0x0f,#0xaa
	dec		0x0f		; dec direct
	mov		a,0x0f
	cjne	a,#0xa9,dec_error

	mov		r0,#0x11
	mov		0x11,#0x95
	dec		@r0			; dec @ri
	mov		a,0x11
	cjne	a,#0x94,dec_error

	ljmp	mul_test

dec_error:
	ljmp	test_error

;
; Multiplication test
;
mul_test:
	mov		a,#0xaa
	mov		b,#0x7f
	mul		ab			; result 0x5456
	jb		cy,mul_error
	jnb		ov,mul_error
	cjne	a,#0x56,mul_error
	mov		a,b
	cjne	a,#0x54,mul_error

	mov		a,#0x06
	mov		b,#0x12
	mul		ab			; result 0x006c
	jb		cy,mul_error
	jb		ov,mul_error
	cjne	a,#0x6c,mul_error
	mov		a,b
	cjne	a,#0x00,mul_error

	ljmp	div_test

mul_error:
	ljmp	test_error

;
; Division test
;
div_test:
	mov		a,#0xac
	mov		b,#0x12
	div		ab			; result 0x09 rem 0x0a
	jb		cy,div_error
	jb		ov,div_error
	cjne	a,#0x09,div_error
	mov		a,b
	cjne	a,#0x0a,div_error

	mov		a,#0x55
	mov		b,#0x00
	div		ab			; div by 0
	jb		cy,div_error
	jnb		ov,div_error

	ljmp	da_test

div_error:
	ljmp	test_error

;
; Decimal Ajust test
;
da_test:
	mov		a,#0x56
	add		a,#0x78
	da		a			; da a
	jnb		cy,da_error
	cjne	a,#0x34,da_error

	mov		a,#0x45
	add		a,#0x49
	da		a			; da a
	jb		cy,da_error
	cjne	a,#0x94,da_error

	ljmp	and_test

da_error:
	ljmp	test_error

;
; Logical And test
;
and_test:
	mov		a,#0x55
	mov		r3,#0xa5
	anl		a,r3		; anl a,rn
	cjne	a,#0x05,and_error

	mov		a,#0xaa
	mov		0x10,#0xa5
	anl		a,0x10		; anl a,direct
	cjne	a,#0xa0,and_error

	mov		a,#0xa5
	mov		r0,#0x11
	mov		0x11,#0x55
	anl		a,@r0		; anl a,@ri
	cjne	a,#0x05,and_error

	mov		a,#0xa5
	anl		a,#0xaa		; anl a,#data
	cjne	a,#0xa0,and_error

	mov		0x12,#0x55
	mov		a,#0xa5
	anl		0x12,a		; anl direct,a
	cjne	a,#0xa5,and_error
	mov		r4,0x12
	cjne	r4,#0x05,and_error

	mov		0x13,#0xaa
	anl		0x13,#0xa5	; anl direct,#data
	mov		a,0x13
	cjne	a,#0xa0,and_error

	ljmp	or_test

and_error:
	ljmp	test_error

;
; Logical Or test
;
or_test:
	mov		a,#0x55
	mov		r5,#0xa5
	orl		a,r5		; orl a,rn
	cjne	a,#0xf5,or_error

	mov		a,#0xaa
	mov		0x14,#0xa5
	orl		a,0x14		; orl a,direct
	cjne	a,#0xaf,or_error

	mov		a,#0xa5
	mov		r1,#0x15
	mov		0x15,#0x55
	orl		a,@r1		; orl a,@ri
	cjne	a,#0xf5,or_error

	mov		a,#0xa5
	orl		a,#0xaa
	cjne	a,#0xaf,or_error

	mov		0x16,#0x55
	mov		a,#0xa5
	orl		0x16,a		; orl direct,a
	cjne	a,#0xa5,or_error
	mov		a,0x16
	cjne	a,#0xf5,or_error

	mov		0x17,#0xaa
	orl		0x17,#0xa5	; orl direct,#data
	mov		a,0x17
	cjne	a,#0xaf,or_error

	ljmp	xor_test

or_error:
	ljmp	test_error

;
; Logical Exor test
;
xor_test:
	mov		a,#0x55
	mov		r6,#0xa5
	xrl		a,r6		; xrl a,rn
	cjne	a,#0xf0,xor_error

	mov		a,#0xaa
	mov		0x18,#0xa5
	xrl		a,0x18		; xrl a,direct
	cjne	a,#0x0f,xor_error

	mov		a,#0xa5
	mov		r0,#0x19
	mov		0x19,#0x55
	xrl		a,@r0		; xrl a,@r0
	cjne	a,#0xf0,xor_error

	mov		a,#0xa5
	xrl		a,#0xaa		; xrl a,#data
	cjne	a,#0x0f,xor_error

	mov		0x1a,#0x55
	mov		a,#0xa5
	xrl		0x1a,a		; xrl direct,a
	cjne	a,#0xa5,xor_error
	mov		a,0x1a
	cjne	a,#0xf0,xor_error

	mov		0x1b,#0xaa
	xrl		0x1b,#0xa5	; xrl direct,#data
	mov		a,0x1b
	cjne	a,#0x0f,xor_error

	ljmp	lop_test

xor_error:
	ljmp	test_error

;
; Logical operation test
;
lop_test:
	mov		a,#0xff
	clr		a			; clr a
	cjne	a,#0x00,lop_error

	mov		a,#0xa5
	cpl		a			; cpl a
	cjne	a,#0x5a,lop_error

	mov		a,#0x5a
	swap	a			; swap a
	cjne	a,#0xa5,lop_error

	ljmp	rot_test

lop_error:
	ljmp	test_error

;
; Rotation test
;
rot_test:
	mov		a,#0xaa
	rl		a			; rl a
	cjne	a,#0x55,rot_error

	clr		c
	mov		a,#0xaa
	rlc		a			; rlc a
	jnb		cy,rot_error
	cjne	a,#0x54,rot_error

	mov		a,#0x55
	rr		a			; rr a
	cjne	a,#0xaa,rot_error

	setb	c
	mov		a,#0x55
	rrc		a			; rrc a
	jnb		cy,rot_error
	cjne	a,#0xaa,rot_error

	ljmp	bit_test

rot_error:
	ljmp	test_error

;
; Bit operation test
;
bit_test:
	setb	c			; setb c
	jnb		cy,bit_error

	clr		c			; clr c
	jb		cy,bit_error

	setb	c
	cpl		c			; cpl c
	jb		cy,bit_error
	cpl		c			; cpl c
	jnb		cy,bit_error

	mov		0x20,#0x00
	setb	0x03		; setb bit
	mov		a,0x20
	cjne	a,#0x08,bit_error
	cpl		0x04		; cpl bit
	mov		a,0x20
	cjne	a,#0x18,bit_error

	mov		0x2f,#0xff
	clr		0x7f		; clr bit
	mov		a,0x2f
	cjne	a,#0x7f,bit_error
	cpl		0x78		; cpl bit
	mov		a,0x2f
	cjne	a,#0x7e,bit_error

	mov		0x21,#0xaa
	mov		c,0x0a		; mov c,bit
	jb		cy,bit_error
	mov		c,0x0d		; mov c,bit
	jnb		cy,bit_error

	mov		0x2e,#0xf0
	setb	c
	mov		0x72,c		; mov bit,c
	mov		a,0x2e
	cjne	a,#0xf4,bit_error
	clr		c
	mov		0x75,c		; mov bit,c
	mov		a,0x2e
	cjne	a,#0xd4,bit_error

	sjmp	bit2_test

bit_error:
	ljmp	test_error

bit2_test:
	mov		0x22,#0x0f

	clr		c
	anl		c,0x10		; anl c,bit
	jc		bit_error
	anl		c,/0x11		; anl c,/bit
	jc		bit_error

	setb	c
	anl		c,0x12		; anl c,bit
	jnc		bit_error
	anl		c,/0x13		; anl c,/bit
	jc		bit_error

	clr		c
	orl		c,0x14		; orl c,bit
	jc		bit_error
	orl		c,/0x15		; orl c,/bit
	jnc		bit_error

	setb	c
	orl		c,0x16		; orl c,bit
	jnc		bit_error
	orl		c,/0x17		; orl c,/bit
	jnc		bit_error

	jbc		0x13,bit2_tst2
	sjmp	bit2_error
bit2_tst2:
	mov		a,0x22
	cjne	a,#0x07,bit_error

	jbc		0x16,bit2_tst3
	sjmp	bit2_tst4
bit2_tst3:
	sjmp	bit2_error
bit2_tst4:
	mov		a,0x22
	cjne	a,#0x07,bit_error

	ljmp	jmp_test

bit2_error:
	ljmp	test_error

;
; Jump test
;
jmp_test:
	sjmp	jmp_tst2
	sjmp	jmp_error
jmp_tst2:
	ljmp	jmp_tst3
	sjmp	jmp_error
jmp_tst3:
	ajmp	jmp_tst4
	sjmp	jmp_error
jmp_tst4:
	mov		dptr,#jmp_dat0
	mov		a,#0x02
	jmp		@a+dptr
jmp_tst5:
	sjmp	jmp_error
jmp_tst6:
	mov		a,#0x00
	jz		jmp_tst7
	sjmp	jmp_error
jmp_tst7:
	mov		a,#0xff
	jnz		jmp_tst8
	sjmp	jmp_error
jmp_tst8:

	ljmp	sbr_test

jmp_dat0:
	ajmp	jmp_tst5
	ajmp	jmp_tst6
	ajmp	jmp_tst5

jmp_error:
	ljmp	test_error

;
; Subroutine test
;
sbr_test:
	mov		a,#0x00
	acall	sbr_tst2
	cjne	a,#0x55,sbr_error

	mov		a,#0x00
	lcall	sbr_tst3
	cjne	a,#0xaa,sbr_error

	ljmp	cjne_test

sbr_tst2:
	mov		a,#0x55
	ret

sbr_tst3:
	mov		a,#0xaa
	ret

sbr_error:
	ljmp	test_error

;
; CJNE test
;
cjne_test:
	mov		a,#0x55
	mov		0x16,#0x55
	mov		0x17,#0xaa
	cjne	a,0x16,cjne_error	; cjne a,direct,rel
	cjne	a,0x17,cjne_tst2	; cjne a,direct,rel
	sjmp	cjne_error
cjne_tst2:

	mov		a,#0xff
	cjne	a,#0x00,cjne_tst3	; cjne a,#data,rel
	sjmp	cjne_error
cjne_tst3:
	cjne	a,#0xff,cjne_error	; cjne a,#data,rel

	mov		r5,#0x00
	cjne	r5,#0x00,cjne_error	; cjne rn,#data,rel
	cjne	r5,#0x01,cjne_tst4	; cjne rn,#data,rel
	sjmp	cjne_error
cjne_tst4:

	mov		r0,#0x18
	mov		0x18,#0x80
	cjne	@r0,#0x80,cjne_error	; cjne @ri,#data,rel
	cjne	@r0,#0x00,cjne_tst5	; cjne @ri,#data,rel
	sjmp	cjne_error
cjne_tst5:

	ljmp	djnz_test

cjne_error:
	ljmp	test_error

;
; DJNZ test
;
djnz_test:
	mov		r7,#0x03
	mov		a,#0x00
djnz_tst2:
	inc		a
	push	acc
	mov		a,r7
	jz		djnz_error
	pop		acc
	djnz	r7,djnz_tst2	; djnz rn,rel
	cjne	a,#0x03,djnz_error

	mov		0x19,#0x04
	mov		a,#0x00
djnz_tst3:
	inc		a
	push	acc
	mov		a,0x19
	jz		djnz_error
	pop		acc
	djnz	0x19,djnz_tst3	; djnz direct,rel
	cjne	a,#0x04,djnz_error

	ljmp	port_test

djnz_error:
	ljmp	test_error

;
; Port test
;
port_test:
	mov		p2,#0xff	; loop-back to p1in
	mov		p1,#0x00	; loop-back to p3in
	mov		a,#0xff
	anl		p1,a		; p1reg = 0x00 (rmw)
	mov		a,p3		; p3in = p1out = 0x00
	jnz		port_error

	mov		a,#0xff
	orl		p1,a		; p1reg = 0xff (rmw)
	mov		a,p3		; p3in = p1out = 0xff
	cjne	a,#0xff,port_error

	xrl		p1,a		; p1reg = 0x00 (rmw)
	mov		a,p3		; p3in = p1out = 0x00
	jnz		port_error

	cpl		p1.0		; p1reg = 0x01 (rmw)
	mov		a,p1		; p1in = p2out = 0xff
	cjne	a,#0xff,port_error
	mov		a,p3		; p3in = p1out = 0x01
	cjne	a,#0x01,port_error

	ljmp	eint_test

port_error:
	ljmp	test_error

;
; external interrupt test
;
eint_test:
	mov		ip,#0x00	; all lower priority
	mov		ie,#0x80	; master enable
	mov		ie,#0x85	; EX0,EX1 enable
	anl		p3,#0xfe	; EX0 = p3out[0] = 0
	orl		p3,#0x01	; EX0 = p3out[0] = 1
	mov		a,0x00
	cjne	a,#0x01,eint_error

	ljmp	tmr_test

eint_error:
	ljmp	test_error

;
; Timer01 test
;
tmr_test:
	mov		ip,#0x00
	mov		ie,#0x80
	mov		ie,#0x8a	; TF0,TF1 enable
	mov		th0,#0xff
	mov		tl0,#0xfe
	orl		tcon,#0x10	; TR0 = 1
tmr_tst2:
	jb		tcon.4,tmr_tst2
	mov		a,0x00
	cjne	a,#0x02,tmr_error

	ljmp	tmr2_test

tmr_error:
	ljmp	test_error

;
; Timer2 test
;
tmr2_test:
	mov		ip,#0x00
	mov		ie,#0xa0	; ET2 enable
	mov		th2,#0xff
	mov		tl2,#0xfe
	orl		t2con,#0x04	; TR2 = 1
tmr2_tst2:
	jb		t2con.2,tmr2_tst2
	mov		a,0x00
	cjne	a,#0x40,tmr2_error

	ljmp	ser_test

tmr2_error:
	ljmp	test_error

;
; serial test
;
ser_test:
	mov		ip,#0x00
	mov		ie,#0x80
	mov		ie,#0x90		; RI,TI enable
	; mode0
	orl		scon,#0x08		; TB8 = 1
	mov		sbuf,#0xaa		; send
ser_tst2:
	jb		scon.3,ser_tst2
	mov		a,0x00
	cjne	a,#0x20,ser_error
	anl		p3,#0xef		; mode0 rcv test on
	orl		scon,#0x10		; REN = 1
ser_tst3:
	jb		scon.4,ser_tst3
	orl		p3,#0x10		; mode0 rcv test off
	mov		a,0x00
	cjne	a,#0x10,ser_error
	mov		a,sbuf
	; mode1
	mov		pcon,#0x80		; TMOD = 1
	mov		tl1,#0xff		; initial value
	mov		th1,#0xff		; auto-load value
	mov		tmod,#0x20		; tmr1 mode2
	mov		tcon,#0x40		; TR1 = 1
	mov		scon,#0x50		; mode1, REN = 1
	mov		sbuf,#0x55
ser_tst4:
	jb		scon.4,ser_tst4	; wait REN = 0
	mov		a,0x00
	anl		a,#0x10
	cjne	a,#0x10,ser_error
	mov		a,sbuf
	cjne	a,#0x55,ser_error
	; mode2
	mov		scon,#0x90		; mode2, REN = 1
	mov		sbuf,#0xa5		; send
ser_tst5:
	jb		scon.4,ser_tst5	; wait REN = 0
	mov		a,0x00
	anl		a,#0x10
	cjne	a,#0x10,ser_error
	mov		a,sbuf
	cjne	a,#0xa5,ser_error
	; mode3
	; tmr2 baudrate gen mode begin
	mov		rcap2l,#0xff	; reload value L
	mov		rcap2h,#0xff	; reload value H
	mov		tl2,#0xff		; initial value L
	mov		th2,#0xff		; initial value H
	mov		t2mod,#0x00		; clear T2OE
	mov		t2con,#0x34		; brg mode start
	; tmr2 baudrate gen mode end
	mov		scon,#0xd0		; mode3, REN = 1
	mov		sbuf,#0x5a		; send
ser_tst6:
	jb		scon.4,ser_tst6	; wait REN = 0
	mov		a,0x00
	anl		a,#0x10
	cjne	a,#0x10,ser_error
	mov		a,sbuf
	cjne	a,#0x5a,ser_error

	ljmp	test_ok

ser_error:
	ljmp	test_error

;
; all test ok
;
test_ok:
	sjmp	test_ok

;
; interrupt handlers
;
irq0hdl:	; ext int0
	mov		0x00,#0x01
	reti

irq1hdl:	; tmr int0
	anl		tcon,#0xef	; TR0 = 0
	mov		0x00,#0x02
	reti

irq2hdl:	; ext int1
	mov		0x00,#0x04
	reti

irq3hdl:	; tmr int1
	mov		0x00,#0x08
	reti

irq4hdl:	; serial int
	clr		a
	jnb		scon.0,irq4hdl0		; if not RI
	orl		a,#0x10
	anl		scon,#0xef			; clear REN
irq4hdl0:
	jnb		scon.1,irq4hdl1		; if not TI
	orl		a,#0x20
irq4hdl1:
	mov		0x00,a
	anl		scon,#0xf0			; clear RI, TI, TB8
	reti

irq5hdl:	; tmr2 int
	clr		a
	jnb		t2con.7,irq5hdl0	; if not TF2
	orl		a,#0x40
irq5hdl0:
	jnb		t2con.6,irq5hdl1	; if not EXF2
	orl		a,#0x80
irq5hdl1:
	mov		0x00,a
	mov		t2con,#0x00			; clear TF2, EXF2
	reti

; End of test.a51
