//
// ac51_tb.v
//
// ac51 microcontroller core
//
// Version 0.6
//
// Copyright 2008, Hideyuki Abe. All rights reserved.
// Distributed under the terms of the MIT License.
//

`define	PMEM_CYC	(2'b01)	// no wait (one cycle)
//`define	PMEM_CYC	(2'b10)	// one wait (two cycle)

module ac51_tb;

reg	clk;
reg	rst;

wire [15:0]	paddr;
wire	pen;
wire [7:0]	prdata;
reg [1:0]	pwt;
wire	pack;
wire [7:0]	iaddr;
wire [7:0]	iwdata;
wire [7:0]	irdata;
wire	iwen;
wire [15:0]	xaddr;
wire	xen;
wire [7:0]	xwdata;
wire [7:0]	xrdata;
wire	xwen;
reg	xack;

wire [7:0]	p0_i;
wire [7:0]	p0_o;
wire [7:0]	p1_i;
wire [7:0]	p1_o;
wire [7:0]	p2_i;
wire [7:0]	p2_o;
wire [7:0]	p3_i;
wire [7:0]	p3_o;

wire [1:0]	eint_i;
wire [1:0]	tc_i;
wire	tc2_i;
wire	tc2_o;
wire	t2ex_i;

wire	rxd_i;
wire	rxd_o;
wire	txd;

wire	smode0;
reg [1:0]	txd_seq;
reg	rxd_smd0;

always begin
	#5	clk = ~clk;
end

initial begin
	clk = 1'b1;
	rst = 1'b0;
	#10	;
	#1	rst = 1'b1;
//	#(10 * 1024)	;
	#(10 * 8192)	;
	$finish;
end

ac51_top ac51_top0(
	.clk(clk),
	.rst(rst),
	.paddr(paddr),
	.pen(pen),
	.prdata(prdata),
	.pack(pack),
	.iaddr(iaddr),
	.iwdata(iwdata),
	.irdata(irdata),
	.iwen(iwen),
	.xaddr(xaddr),
	.xen(xen),
	.xwdata(xwdata),
	.xrdata(xrdata),
	.xwen(xwen),
	.xack(xack),
	.p0_i(p0_i),
	.p0_o(p0_o),
	.p1_i(p1_i),
	.p1_o(p1_o),
	.p2_i(p2_i),
	.p2_o(p2_o),
	.p3_i(p3_i),
	.p3_o(p3_o),
	.eint_i(eint_i),
	.tc_i(tc_i),
	.tc2_i(tc2_i),
	.tc2_o(tc2_o),
	.t2ex_i(t2ex_i),
	.rxd_i(rxd_i),
	.rxd_o(rxd_o),
	.txd(txd)
);

assign	p0_i = p0_o;
assign	p1_i = p2_o;	// for RMW test
assign	p2_i = p2_o;
assign	p3_i = p1_o;	// for RMW test
assign	eint_i = p3_o[1:0];	// for ext int test
assign	tc_i = p3_o[3:2];	// for timer01 test
assign	tc2_i = p3_o[4];	// for timer2 test
assign	t2ex_i = p3_o[5];	// for timer2 test

assign	smode0 = ~p3_o[4];	// for serial mode0 test
assign	rxd_i = smode0
				? rxd_smd0	// for serial mode0 test
				: txd;		// for serial mode1,2,3 loop-back test

always @(posedge clk or negedge rst) begin
	if(~rst)
		txd_seq <= 2'b11;
	else
		txd_seq <= {txd_seq[0], txd};
end

always @(posedge clk or negedge rst) begin
	if(~rst)
		rxd_smd0 <= 1'b0;
	else if(~txd_seq[1] & txd_seq[0])
		rxd_smd0 <= ~rxd_smd0;
end

always @(posedge clk or negedge rst) begin
	if(~rst) begin
		pwt <= 2'b00;
	end
	else if(pen) begin
		if(pwt == `PMEM_CYC)
			pwt <= 2'b01;
		else
			pwt <= pwt + 2'b01;
	end
	else begin
		pwt <= 2'b00;
	end
end

assign	pack = (pwt == `PMEM_CYC);

sync_ram pram0(
	.clk(clk),
	.addr(paddr),
	.wdata(8'h00),
	.ceb(~rst),
	.web(1'b1),
	.rdata(prdata)
);

initial begin
	$readmemh("test.dat", pram0.mem);
end

sync_ram #(8) iram0(
	.clk(clk),
	.addr(iaddr),
	.wdata(iwdata),
	.ceb(1'b0),
	.web(~iwen),
	.rdata(irdata)
);

always @(posedge clk or negedge rst) begin
	if(~rst)
		xack <= 1'b0;
	else
		xack <= xen;
end

sync_ram xram0(
	.clk(clk),
	.addr(xaddr),
	.wdata(xwdata),
	.ceb(1'b0),
	.web(~xwen),
	.rdata(xrdata)
);

initial begin
	$dumpfile("ac51_tb.vcd");
	$dumpvars(0, ac51_tb);
end

endmodule

// ac51_tb.v
