//
// ac51_pcon.v
//
// ac51 microcontroller core
//
// Version 0.6
//
// Copyright 2008, Hideyuki Abe. All rights reserved.
// Distributed under the terms of the MIT License.
//

module ac51_pcon(
	clk,
	rst,
	ioaddr,
	iowdata,
	iordata,
	iowen,
	smod
);

input	clk;
input	rst;
input [6:0]	ioaddr;
input [7:0]	iowdata;
output [7:0]	iordata;
input	iowen;
output	smod;

reg [6:0]	ioaddr_d;

wire	pcon_enb;
wire	pcon_wen;

wire [7:0]	pcon;

reg	smod;

always @(posedge clk or negedge rst) begin
	if(~rst)
		ioaddr_d <= 7'h00;
	else
		ioaddr_d <= ioaddr;
end	// always

assign	pcon_enb = (ioaddr_d == 7'h07);	// PCON @8'h87

assign	pcon = {smod, 7'b000_0000};

assign	iordata = ({8{pcon_enb}} & pcon);

assign	pcon_wen = ((ioaddr == 7'h07) & iowen);	// PCON @8'h87

always @(posedge clk or negedge rst) begin
	if(~rst)
		smod <= 1'b0;
	else if(pcon_wen)
		smod <= iowdata[7];
end	// always

endmodule

// End of ac51_pcon.v
