//
// ac51_pbus_mux.v
//
// ac51 microcontroller core
//
// Version 0.6
//
// Copyright 2008, Hideyuki Abe. All rights reserved.
// Distributed under the terms of the MIT License.
//

module ac51_pbus_mux(
	clk,
	rst,
	paddr,
	pen,
	prdata_i,
	pack,
	paddra,
	pena,
	packa,
	paddrb,
	penb,
	packb,
	prdata_o
);

input	clk;
input	rst;
output [15:0]	paddr;
output	pen;
input [7:0]	prdata_i;
input	pack;
input [15:0]	paddra;
input	pena;
output	packa;
input [15:0]	paddrb;
input	penb;
output	packb;
output [7:0]	prdata_o;

reg	penb_d;


assign	pen = pena | penb;

always @(posedge clk or negedge rst) begin
	if(~rst)
		penb_d <= 1'b0;
	else
		penb_d <= penb;
end	// always

assign	packa = ~penb_d ? pack : 1'b0;
assign	packb = penb_d ? pack : 1'b0;

assign	paddr = penb ? paddrb : paddra;

assign	prdata_o = prdata_i;

endmodule

// End of ac51_pbus_mux.v
