//
// ac51_exe.v
//
// ac51 microcontroller core
//
// Version 0.6
//
// Copyright 2008, Hideyuki Abe. All rights reserved.
// Distributed under the terms of the MIT License.
//

`include "ac51_cfg.v"
`include "ac51_defs.v"

module ac51_exe(
	clk,
	rst,
	pc_nxt,
	inst1,
	inst2,
	inst3,
	inst_rdy,
	inst_ack,
	jmp_req,
	jmp_ack,
	new_pc,
	iaddr,
	iwdata,
	irdata,
	iwen,
	paddr,
	pen,
	prdata,
	pack,
	xaddr,
	xen,
	xwdata,
	xrdata,
	xwen,
	xack,
	p0_i,
	p0_o,
	p1_i,
	p1_o,
	p2_i,
	p2_o,
	p3_i,
	p3_o,
	eint_i,
	tc_i,
	tc2_i,
	tc2_o,
	t2ex_i,
	rxd_i,
	rxd_o,
	txd
);

input	clk;
input	rst;
input [15:0]	pc_nxt;
input [7:0]	inst1;
input [7:0]	inst2;
input [7:0]	inst3;
input	inst_rdy;
output	inst_ack;
output	jmp_req;
input	jmp_ack;
output [15:0]	new_pc;
output [7:0]	iaddr;
output [7:0]	iwdata;
input [7:0]	irdata;
output	iwen;
output [15:0]	paddr;
output	pen;
input [7:0]	prdata;
input	pack;
output [15:0]	xaddr;
output	xen;
output [7:0]	xwdata;
input [7:0]	xrdata;
output	xwen;
input	xack;
input [7:0]	p0_i;
output [7:0]	p0_o;
input [7:0]	p1_i;
output [7:0]	p1_o;
input [7:0]	p2_i;
output [7:0]	p2_o;
input [7:0]	p3_i;
output [7:0]	p3_o;
input [1:0]	eint_i;
input [1:0]	tc_i;
input	tc2_i;
output	tc2_o;
input	t2ex_i;
input	rxd_i;
output	rxd_o;
output	txd;

wire [7:0]	inst1_r;
wire [`PCMUX_LEN - 1:0]	pc_mux;
wire [`CPCMUX_LEN - 1:0]	cpc_mux;
wire [`SPMUX_LEN - 1:0]	sp_mux;
wire [`DPMUX_LEN - 1:0]	dptr_mux;
wire [`ACCMUX_LEN - 1:0]	acc_mux;
wire	acc_zero;
wire [`BRGMUX_LEN - 1:0]	breg_mux;
wire [`ALUOP_LEN - 1:0]	op_sel;
wire [`AMUX_LEN - 1:0]	ina_mux;
wire [`BMUX_LEN - 1:0]	inb_mux;
wire [7:0]	ina;
wire [7:0]	inb;
wire [15:0]	div_tmp_i;
wire	cy_bit;
wire	ac_bit;
wire	ov_bit;
wire [7:0]	outa;
wire [7:0]	outb;
wire [15:0]	div_tmp_o;
wire	new_cy;
wire	new_ac;
wire	new_ov;
wire [`TMUX_LEN - 1:0]	tmp_mux;
wire	tmp_zero;
wire	bit_data;
wire [2:0]	flg_upd;
wire [`EAMUX_LEN - 1:0]	ea_mux;
wire [`IMUX_LEN - 1:0]	ibus_mux;
wire [`IWDMUX_LEN - 1:0]	iwd_mux;
wire [`PMUX_LEN - 1:0]	pbus_mux;
wire [`XMUX_LEN - 1:0]	xbus_mux;
wire [7:0]	p2;
wire [5:0]	int_req;
wire [5:0]	int_pri;
wire [5:0]	int_ack;
wire [5:0]	int_enb;

wire [6:0]	ioaddr;
wire [7:0]	iowdata;
wire [7:0]	iordata;
wire	iormw;
wire	iowen;
wire [7:0]	iordata0;
wire [7:0]	iordata1;
wire [7:0]	iordata2;
wire [7:0]	iordata3;
wire [7:0]	iordata4;
wire [7:0]	iordata5;
wire [7:0]	iordata6;
wire [7:0]	iordata7;

wire [7:0]	p0_i;
wire [7:0]	p0_o;
wire [7:0]	p1_i;
wire [7:0]	p1_o;
wire [7:0]	p2_i;
wire [7:0]	p2_o;
wire [7:0]	p3_i;
wire [7:0]	p3_o;

wire [1:0]	eint_i;
wire [1:0]	eint_req;
wire [1:0]	eint_ack;
wire [1:0]	tc_i;
wire [1:0]	tf_req;
wire [1:0]	tf_ack;

wire	sck;
wire	sck1;
wire	sck2;
wire	smod;
wire	rxd_i;
wire	rxd_o;
wire	txd;
wire	sint_req;

ac51_exe_ctrl exe_ctrl0(
	.clk(clk),
	.rst(rst),
	.inst1_r(inst1_r),
	.inst_rdy(inst_rdy),
	.inst_ack(inst_ack),
	.jmp_req(jmp_req),
	.jmp_ack(jmp_ack),
	.pc_mux(pc_mux),
	.cpc_mux(cpc_mux),
	.sp_mux(sp_mux),
	.dptr_mux(dptr_mux),
	.acc_mux(acc_mux),
	.acc_zero(acc_zero),
	.breg_mux(breg_mux),
	.op_sel(op_sel),
	.ina_mux(ina_mux),
	.inb_mux(inb_mux),
	.tmp_mux(tmp_mux),
	.tmp_zero(tmp_zero),
	.bit_data(bit_data),
	.cy_bit(cy_bit),
	.flg_upd(flg_upd),
	.ea_mux(ea_mux),
	.ibus_mux(ibus_mux),
	.iwd_mux(iwd_mux),
	.pbus_mux(pbus_mux),
	.xbus_mux(xbus_mux),
	.pack(pack),
	.xack(xack),
	.int_req(int_req),
	.int_pri(int_pri),
	.int_ack(int_ack)
);

ac51_exe_data exe_data0(
	.clk(clk),
	.rst(rst),
	.pc_nxt(pc_nxt),
	.inst1(inst1),
	.inst2(inst2),
	.inst3(inst3),
	.inst1_r(inst1_r),
	.inst_ack(inst_ack),
	.pc_mux(pc_mux),
	.cpc_mux(cpc_mux),
	.sp_mux(sp_mux),
	.dptr_mux(dptr_mux),
	.new_pc(new_pc),
	.acc_mux(acc_mux),
	.acc_zero(acc_zero),
	.breg_mux(breg_mux),
	.ina_mux(ina_mux),
	.inb_mux(inb_mux),
	.ina(ina),
	.inb(inb),
	.div_tmp_i(div_tmp_i),
	.cy_bit(cy_bit),
	.ac_bit(ac_bit),
	.ov_bit(ov_bit),
	.outa(outa),
	.outb(outb),
	.div_tmp_o(div_tmp_o),
	.new_cy(new_cy),
	.new_ac(new_ac),
	.new_ov(new_ov),
	.tmp_mux(tmp_mux),
	.tmp_zero(tmp_zero),
	.bit_data(bit_data),
	.flg_upd(flg_upd),
	.ea_mux(ea_mux),
	.ibus_mux(ibus_mux),
	.iwd_mux(iwd_mux),
	.iaddr(iaddr),
	.iwdata(iwdata),
	.irdata(irdata),
	.iwen(iwen),
	.ioaddr(ioaddr),
	.iowdata(iowdata),
	.iordata(iordata),
	.iormw(iormw),
	.iowen(iowen),
	.pbus_mux(pbus_mux),
	.paddr(paddr),
	.pen(pen),
	.prdata(prdata),
	.xbus_mux(xbus_mux),
	.xaddr(xaddr),
	.p2(p2),
	.xen(xen),
	.xwdata(xwdata),
	.xrdata(xrdata),
	.xwen(xwen),
	.int_pri(int_pri),
	.int_enb(int_enb)
);

assign	p2 = p2_o;

ac51_exe_alu exe_alu0(
	.op_sel(op_sel),
	.ina(ina),
	.inb(inb),
	.div_tmp_i(div_tmp_i),
	.cy_bit(cy_bit),
	.ac_bit(ac_bit),
	.ov_bit(ov_bit),
	.outa(outa),
	.outb(outb),
	.div_tmp_o(div_tmp_o),
	.new_cy(new_cy),
	.new_ac(new_ac),
	.new_ov(new_ov)
);

assign	iordata = iordata0
					| iordata1
					| iordata2
					| iordata3
					| iordata4
					| iordata5
					| iordata6
					| iordata7;

ac51_port port0(
	.clk(clk),
	.rst(rst),
	.ioaddr(ioaddr),
	.iowdata(iowdata),
	.iordata(iordata0),
	.iormw(iormw),
	.iowen(iowen),
	.port_i(p0_i),
	.port_o(p0_o)
);

ac51_port #(7'h10) port1(
	.clk(clk),
	.rst(rst),
	.ioaddr(ioaddr),
	.iowdata(iowdata),
	.iordata(iordata1),
	.iormw(iormw),
	.iowen(iowen),
	.port_i(p1_i),
	.port_o(p1_o)
);

ac51_port #(7'h20) port2(
	.clk(clk),
	.rst(rst),
	.ioaddr(ioaddr),
	.iowdata(iowdata),
	.iordata(iordata2),
	.iormw(iormw),
	.iowen(iowen),
	.port_i(p2_i),
	.port_o(p2_o)
);

ac51_port #(7'h30) port3(
	.clk(clk),
	.rst(rst),
	.ioaddr(ioaddr),
	.iowdata(iowdata),
	.iordata(iordata3),
	.iormw(iormw),
	.iowen(iowen),
	.port_i(p3_i),
	.port_o(p3_o)
);

ac51_tmr01 tmr01(
	.clk(clk),
	.rst(rst),
	.ioaddr(ioaddr),
	.iowdata(iowdata),
	.iordata(iordata4),
	.iowen(iowen),
	.sck(sck1),
	.eint_i(eint_i),
	.eint_req(eint_req),
	.eint_ack(eint_ack),
	.tc_i(tc_i),
	.tf_req(tf_req),
	.tf_ack(tf_ack)
);

`ifdef	AC51_USE_TMR2
ac51_tmr2 tmr2(
	.clk(clk),
	.rst(rst),
	.ioaddr(ioaddr),
	.iowdata(iowdata),
	.iordata(iordata7),
	.iowen(iowen),
	.sck(sck2),
	.rclk(rclk),
	.tclk(tclk),
	.tc2_i(tc2_i),
	.tc2_o(tc2_o),
	.t2ex_i(t2ex_i),
	.tf2_req(tf2_req)
);
`else	// AC51_USE_TMR2
assign	iordata7 = 8'h00;
assign	sck2 = 1'b0;
assign	rclk = 1'b0;
assign	tclk = 1'b0;
assign	tc2_o = 1'b1;
`endif	// AC51_USE_TMR2

ac51_serial serial0(
	.clk(clk),
	.rst(rst),
	.ioaddr(ioaddr),
	.iowdata(iowdata),
	.iordata(iordata5),
	.iowen(iowen),
	.sck1(sck1),
	.sck2(sck2),
	.rclk(tclk),
	.tclk(tclk),
	.smod(smod),
	.rxd_i(rxd_i),
	.rxd_o(rxd_o),
	.txd(txd),
	.sint_req(sint_req)
);

ac51_pcon pcon0(
	.clk(clk),
	.rst(rst),
	.ioaddr(ioaddr),
	.iowdata(iowdata),
	.iordata(iordata6),
	.iowen(iowen),
	.smod(smod)
);

assign	int_req[0] = eint_req[0] & int_enb[0];
assign	int_req[2] = eint_req[1] & int_enb[2];
assign	eint_ack[0] = int_ack[0];
assign	eint_ack[1] = int_ack[2];

assign	int_req[1] = tf_req[0] & int_enb[1];
assign	int_req[3] = tf_req[1] & int_enb[3];
assign	tf_ack[0] = int_ack[1];
assign	tf_ack[1] = int_ack[3];

assign	int_req[4] = sint_req & int_enb[4];

`ifdef	AC51_USE_TMR2
assign	int_req[5] = tf2_req & int_enb[5];
`else	// AC51_USE_TMR2
assign	int_req[5] = 1'b0;
`endif	// AC51_USE_TMR2

endmodule

// End of ac51_exe.v
