//
// ac51_div.v
//
// ac51 microcontroller core
//
// Version 0.6
//
// Copyright 2008, Hideyuki Abe. All rights reserved.
// Distributed under the terms of the MIT License.
//

module ac51_div(
	div_op,
	ina,
	inb,
	tmp_i,
	ov_bit,
	outa,
	outb,
	tmp_o,
	new_ov
);

input [1:0]	div_op;
input [7:0]	ina;
input [7:0]	inb;
input [15:0]	tmp_i;
input	ov_bit;
output [7:0]	outa;
output [7:0]	outb;
output [15:0]	tmp_o;
output	new_ov;

wire [15:0]	remainder;
wire [15:0]	remainder_trial;
reg [15:0]	divisor;
reg [7:0]	quotient;

reg [7:0]	outa;
reg [7:0]	outb;
wire [15:0]	tmp_o;
reg	new_ov;


// divisor == 0 -> overflow
always @(ov_bit or div_op or inb) begin
	if(div_op == 2'b01) begin
		if(inb == 8'h00) new_ov = 1'b1;
		else new_ov = 1'b0;
	end
	else begin
		new_ov = ov_bit;
	end
end	// always comb

always @(tmp_i or div_op or inb) begin
	if(div_op == 2'b01) begin
		divisor = {1'b0, inb, 7'h00};
	end
	else begin
		divisor = tmp_i;
	end
end	// always comb

assign	tmp_o = {1'b0, divisor[15:1]};

assign	remainder = {8'h00, ina};
assign	remainder_trial = remainder - divisor;

always @(remainder_trial or remainder or inb) begin
	if(remainder_trial[15]) begin
		outa = remainder[7:0];
		outb = {inb[6:0], 1'b0};
	end
	else begin
		outa = remainder_trial[7:0];
		outb = {inb[6:0], 1'b1};
	end
end	// always comb

endmodule

// End of ac51_div.v
