//
// ac51_defs.v
//
// ac51 microcontroller core
//
// Version 0.6
//
// Copyright 2008, Hideyuki Abe. All rights reserved.
// Distributed under the terms of the MIT License.
//

// pc_mux definitions
`define	PCMUX_LEN	4
`define	PCMUX_ZERO	4'b0000
`define	PCMUX_ABS	4'b0001
`define	PCMUX_LONG	4'b0010
`define	PCMUX_POP	4'b0011
`define	PCMUX_EA	4'b0100
`define	PCMUX_INT0	4'b0101
`define	PCMUX_INT1	4'b0110
`define	PCMUX_INT2	4'b0111
`define	PCMUX_INT3	4'b1000
`define	PCMUX_INT4	4'b1001
`define	PCMUX_INT5	4'b1010

// cpc_mux definitions
`define	CPCMUX_LEN	2
`define	CPCMUX_NULL	2'b00
`define	CPCMUX_PCR	2'b01
`define	CPCMUX_PCN	2'b10

// sp_mux definitions
`define	SPMUX_LEN	2
`define	SPMUX_NULL	2'b00
`define	SPMUX_OUTA	2'b01

// dptr_mux definitions
`define	DPMUX_LEN		2
`define	DPMUX_NULL		2'b00
`define	DPMUX_INST23	2'b01
`define	DPMUX_EA		2'b10

// acc_mux definitions
`define	ACCMUX_LEN		3
`define	ACCMUX_NULL		3'b000
`define	ACCMUX_IDATA	3'b001
`define	ACCMUX_OUTA		3'b010
`define	ACCMUX_ZERO		3'b011
`define	ACCMUX_INST2	3'b100
`define	ACCMUX_PDATA	3'b101
`define	ACCMUX_XDATA	3'b110
`define	ACCMUX_OUTB		3'b111

// breg_mux definitions
`define	BRGMUX_LEN	2
`define	BRGMUX_NULL	2'b00
`define	BRGMUX_OUTB	2'b01
`define	BRGMUX_OUTA	2'b10

// op_sel definitions
`define	ALUOP_LEN	5
`define	ALUOP_NULL	5'b00000
`define	ALUOP_ADD	5'b00001
`define	ALUOP_ADC	5'b00010
`define	ALUOP_SUB	5'b00011
`define	ALUOP_SBB	5'b00100
`define	ALUOP_AND	5'b00101
`define	ALUOP_BSET	5'b00110
`define	ALUOP_BCLR	5'b00111
`define	ALUOP_BCOM	5'b01000
`define	ALUOP_COM	5'b01001
`define	ALUOP_SWP	5'b01010
`define	ALUOP_OR	5'b01011
`define	ALUOP_XOR	5'b01100
`define	ALUOP_MUL	5'b01101
`define	ALUOP_DIV0	5'b01110
`define	ALUOP_DIV1	5'b01111
`define	ALUOP_DAA	5'b10000
`define	ALUOP_RR	5'b10001
`define	ALUOP_RRC	5'b10010
`define	ALUOP_RL	5'b10011
`define	ALUOP_RLC	5'b10100
`define	ALUOP_XCHD	5'b10101
`define	ALUOP_BAND	5'b10110
`define	ALUOP_BOR	5'b10111
`define	ALUOP_BANDNOT	5'b11000
`define	ALUOP_BORNOT	5'b11001
`define	ALUOP_BMOV	5'b11010

// ina_mux definitions
`define	AMUX_LEN	3
`define	AMUX_ZERO	3'b000
`define	AMUX_ACC	3'b001
`define	AMUX_IDATA	3'b010
`define	AMUX_SP		3'b011

// inb_mux definitions
`define	BMUX_LEN	3
`define	BMUX_ZERO	3'b000
`define	BMUX_INST2	3'b001
`define	BMUX_IDATA	3'b010
`define	BMUX_ONE	3'b011
`define	BMUX_BRG	3'b100
`define	BMUX_ACC	3'b101
`define	BMUX_INST3	3'b110

// tmp_mux definitions
`define	TMUX_LEN	2
`define	TMUX_NULL	2'b00
`define	TMUX_OUTA	2'b01
`define	TMUX_IDATA	2'b10

// ea_mux definitions
`define	EAMUX_LEN		3
`define	EAMUX_NULL		3'b000
`define	EAMUX_INCDPTR	3'b001
`define	EAMUX_ADPTR		3'b010
`define	EAMUX_APC		3'b011
`define	EAMUX_REL2		3'b100
`define	EAMUX_REL3		3'b101

// ibus_mux definitions
`define	IMUX_LEN		4
`define	IMUX_NULL		4'b0000
`define	IMUX_DRD2		4'b0001
`define	IMUX_DWR2		4'b0010
`define	IMUX_RNRD		4'b0011
`define	IMUX_RIRD		4'b0100
`define	IMUX_BTRD2		4'b0101
`define	IMUX_BTWR2		4'b0110
`define	IMUX_RNWR		4'b0111
`define	IMUX_RIWR		4'b1000
`define	IMUX_OUTA		4'b1001
`define	IMUX_SP			4'b1010
`define	IMUX_DWR3		4'b1011
`define	IMUX_DRD2RMW	4'b1100
`define	IMUX_BTRD2RMW	4'b1101

// iwd_mux definitions
`define	IWDMUX_LEN		4
`define	IWDMUX_ZERO		4'b0000
`define	IWDMUX_INST3	4'b0001
`define	IWDMUX_ACC		4'b0010
`define	IWDMUX_OUTA		4'b0011
`define	IWDMUX_INST2	4'b0100
`define	IWDMUX_PCL		4'b0101
`define	IWDMUX_PCH		4'b0110
`define	IWDMUX_IDATA	4'b0111
`define	IWDMUX_OUTB		4'b1000
`define	IWDMUX_CPCL		4'b1001
`define	IWDMUX_CPCH		4'b1010

// pbus_mux definitions
`define	PMUX_LEN	2
`define	PMUX_NULL	2'b00
`define	PMUX_RD_EA	2'b01

// xbus_mux definitions
`define	XMUX_LEN		3
`define	XMUX_NULL		3'b000
`define	XMUX_DPTR_RD	3'b001
`define	XMUX_RI_RD		3'b010
`define	XMUX_DPTR_WR	3'b011
`define	XMUX_RI_WR		3'b100

// OP code definitions
`define	OPC_NOP				8'b0000_0000
`define	OPC_AJMP			   5'b0_0001
`define	OPC_LJMP			8'b0000_0010
`define	OPC_RR_A			8'b0000_0011
`define	OPC_INC_A			8'b0000_0100
`define	OPC_INC_DIR			8'b0000_0101
`define	OPC_INC_RI			7'b0000_011
`define	OPC_INC_RN			5'b0000_1
`define	OPC_JBC_BIT			8'b0001_0000
`define	OPC_ACALL			   5'b1_0001
`define	OPC_LCALL			8'b0001_0010
`define	OPC_RRC_A			8'b0001_0011
`define	OPC_DEC_A			8'b0001_0100
`define	OPC_DEC_DIR			8'b0001_0101
`define	OPC_DEC_RI			7'b0001_011
`define	OPC_DEC_RN			5'b0001_1
`define	OPC_JB_BIT			8'b0010_0000
`define	OPC_RET				8'b0010_0010
`define	OPC_RLA				8'b0010_0011
`define	OPC_ADD_A_IMM		8'b0010_0100
`define	OPC_ADD_A_DIR		8'b0010_0101
`define	OPC_ADD_A_RI		7'b0010_011
`define	OPC_ADD_A_RN		5'b0010_1
`define	OPC_JNB_BIT			8'b0011_0000
`define	OPC_RETI			8'b0011_0010
`define	OPC_RLCA			8'b0011_0011
`define	OPC_ADC_A_IMM		8'b0011_0100
`define	OPC_ADC_A_DIR		8'b0011_0101
`define	OPC_ADC_A_RI		7'b0011_011
`define	OPC_ADC_A_RN		5'b0011_1
`define	OPC_JC				8'b0100_0000
`define	OPC_ORL_DIR_A		8'b0100_0010
`define	OPC_ORL_DIR_IMM		8'b0100_0011
`define	OPC_ORL_A_IMM		8'b0100_0100
`define	OPC_ORL_A_DIR		8'b0100_0101
`define	OPC_ORL_A_RI		7'b0100_011
`define	OPC_ORL_A_RN		5'b0100_1
`define	OPC_JNC				8'b0101_0000
`define	OPC_ANL_DIR_A		8'b0101_0010
`define	OPC_ANL_DIR_IMM		8'b0101_0011
`define	OPC_ANL_A_IMM		8'b0101_0100
`define	OPC_ANL_A_DIR		8'b0101_0101
`define	OPC_ANL_A_RI		7'b0101_011
`define	OPC_ANL_A_RN		5'b0101_1
`define	OPC_JZ				8'b0110_0000
`define	OPC_XRL_DIR_A		8'b0110_0010
`define	OPC_XRL_DIR_IMM		8'b0110_0011
`define	OPC_XRL_A_IMM		8'b0110_0100
`define	OPC_XRL_A_DIR		8'b0110_0101
`define	OPC_XRL_A_RI		7'b0110_011
`define	OPC_XRL_A_RN		5'b0110_1
`define	OPC_JNZ				8'b0111_0000
`define	OPC_ORL_C_BIT		8'b0111_0010
`define	OPC_JMP_ADPTR		8'b0111_0011
`define	OPC_MOV_A_IMM		8'b0111_0100
`define	OPC_MOV_DIR_IMM		8'b0111_0101
`define	OPC_MOV_RI_IMM		7'b0111_011
`define	OPC_MOV_RN_IMM		5'b0111_1
`define	OPC_SJMP			8'b1000_0000
`define	OPC_ANL_C_BIT		8'b1000_0010
`define	OPC_MOVC_A_APC		8'b1000_0011
`define	OPC_DIV_AB			8'b1000_0100
`define	OPC_MOV_DIR_DIR		8'b1000_0101
`define	OPC_MOV_DIR_RI		7'b1000_011
`define	OPC_MOV_DIR_RN		5'b1000_1
`define	OPC_MOV_DPTR_IMM	8'b1001_0000
`define	OPC_MOV_BIT_C		8'b1001_0010
`define	OPC_MOVC_A_ADPTR	8'b1001_0011
`define	OPC_SUBB_A_IMM		8'b1001_0100
`define	OPC_SUBB_A_DIR		8'b1001_0101
`define	OPC_SUBB_A_RI		7'b1001_011
`define	OPC_SUBB_A_RN		5'b1001_1
`define	OPC_ORL_C_NBIT		8'b1010_0000
`define	OPC_MOV_C_BIT		8'b1010_0010
`define	OPC_INC_DPTR		8'b1010_0011
`define	OPC_MUL_AB			8'b1010_0100
`define	OPC_MOV_RI_DIR		7'b1010_011
`define	OPC_MOV_RN_DIR		5'b1010_1
`define	OPC_ANL_C_NBIT		8'b1011_0000
`define	OPC_CPL_BIT			8'b1011_0010
`define	OPC_CPL_C			8'b1011_0011
`define	OPC_CJNE_A_IMM		8'b1011_0100
`define	OPC_CJNE_A_DIR		8'b1011_0101
`define	OPC_CJNE_RI_IMM		7'b1011_011
`define	OPC_CJNE_RN_IMM		5'b1011_1
`define	OPC_PUSH_DIR		8'b1100_0000
`define	OPC_CLR_BIT			8'b1100_0010
`define	OPC_CLR_C			8'b1100_0011
`define	OPC_SWAP_A			8'b1100_0100
`define	OPC_XCH_A_DIR		8'b1100_0101
`define	OPC_XCH_A_RI		7'b1100_011
`define	OPC_XCH_A_RN		5'b1100_1
`define	OPC_POP_DIR			8'b1101_0000
`define	OPC_SETB_BIT		8'b1101_0010
`define	OPC_SETB_C			8'b1101_0011
`define	OPC_DA_A			8'b1101_0100
`define	OPC_DJNZ_DIR		8'b1101_0101
`define	OPC_XCHD_A_RI		7'b1101_011
`define	OPC_DJNZ_RN			5'b1101_1
`define	OPC_MOVX_A_DPTR		8'b1110_0000
`define	OPC_MOVX_A_RI		7'b1110_001
`define	OPC_CLR_A			8'b1110_0100
`define	OPC_MOV_A_DIR		8'b1110_0101
`define	OPC_MOV_A_RI		7'b1110_011
`define	OPC_MOV_A_RN		5'b1110_1
`define	OPC_MOVX_DPTR_A		8'b1111_0000
`define	OPC_MOVX_RI_A		7'b1111_001
`define	OPC_CPL_A			8'b1111_0100
`define	OPC_MOV_DIR_A		8'b1111_0101
`define	OPC_MOV_RI_A		7'b1111_011
`define	OPC_MOV_RN_A		5'b1111_1


// End of ac51_defs.v
