//
// ac51_addsub.v
//
// ac51 microcontroller core
//
// Version 0.6
//
// Copyright 2008, Hideyuki Abe. All rights reserved.
// Distributed under the terms of the MIT License.
//

module ac51_addsub(
	op,
	ina,
	inb,
	cy_bit,
	out,
	new_cy,
	new_ac,
	new_ov
);

input [1:0]	op;	// 00 - ADD, 01 - ADC, 10 - SUB, 11 - SBB
input [7:0]	ina;
input [7:0]	inb;
input	cy_bit;
output [7:0]	out;
output	new_cy;
output	new_ac;
output	new_ov;

wire	cinl;
wire [3:0]	inbl;
wire [3:0]	outl;
wire	coutl;
wire	cinh;
wire [3:0]	inbh;
wire [3:0]	outh;
wire	couth;

assign	cinl = (op[1]) ^ ((op[0]) & cy_bit);
assign	inbl = op[1] ? (~inb[3:0]) : inb[3:0];

adder4 add4l(
	.ina(ina[3:0]),
	.inb(inbl),
	.cy_in(cinl),
	.out(outl),
	.cy_out(coutl)
);

assign	cinh = coutl;
assign	inbh = op[1] ? (~inb[7:4]) : inb[7:4];

adder4 add4h(
	.ina(ina[7:4]),
	.inb(inbh),
	.cy_in(cinh),
	.out(outh),
	.cy_out(couth)
);

assign	out = {outh, outl};

// aux carry bit
assign	new_ac = op[1] ? (~coutl) : coutl;

// carry bit
assign	new_cy = op[1] ? (~couth) : couth;

// overflow bit
assign	new_ov = (ina[7] & inbh[3] & ~out[7])
					| ((~ina[7]) & (~inbh[3]) & out[7]);


endmodule

// End of ac51_addsub.v
