;
; test.asm
;
; ac09 processor core
;
; Version 0.6
;
; Copyright 2008, Hideyuki Abe. All rights reserved.
; Distributed under the terms of the MIT License.
;

	nam		test

	org		$0000
; zero page
ld_dat1
	fcb		$00,$00
str_dat2
	fcb		$55,$aa
lea_dat0
	fdb		lea_dat1


	org		$8000
stack_top
test_error
	bra		test_error	; error end

test_start
	; initialize sp
	lds		#stack_top
	cmps	#stack_top
	bne		test_error

	; check initial dp value
	tfr		dp, a		; dp -> a
	cmpa	#$00
	bne		test_error

; Load Instruction Test
ld_test
	lda		#$aa		; immediate
	bvs		ld_error
	bpl		ld_error
	beq		ld_error
	cmpa	#$aa
	bne		ld_error

	ldb		>ld_dat0	; extended
	bvs		ld_error
	bmi		ld_error
	beq		ld_error
	cmpb	#$55
	bne		ld_error

	ldd		<ld_dat1	; direct page
	bvs		ld_error
	bmi		ld_error
	bne		ld_error
	cmpd	#$0000
	bne		ld_error

	ldx		ld_dat2,pcr	; index
	bvs		ld_error
	bmi		ld_error
	beq		ld_error
	cmpx	#$1234
	bne		ld_error

	ldy		#$a55a
	cmpy	#$a55a
	bne		ld_error

	ldu		#$5aa5
	cmpu	#$5aa5
	bne		ld_error

	jmp		str_test

ld_dat0
	fcb		$55
ld_dat2
	fcb		$12,$34

ld_error
	jmp		test_error

; Store Instruction Test
str_test
	lda		#$55
	sta		>str_dat0	; extended
	bvs		str_error
	bmi		str_error
	beq		str_error
	ldb		str_dat0
	cmpb	#$55
	bne		str_error

	ldb		#$00
	stb		str_dat1,pcr	; index
	bvs		str_error
	bmi		str_error
	bne		str_error
	lda		str_dat1
	cmpa	#00
	bne		str_error

	ldd		#$ffff
	std		<str_dat2	; direct
	bvs		str_error
	bpl		str_error
	beq		str_error
	ldx		str_dat2
	cmpx	#$ffff
	bne		str_error

	ldx		#$aaaa
	stx		str_dat3
	ldy		str_dat3
	cmpy	#$aaaa
	bne		str_error

	ldy		#$5555
	sty		str_dat3
	ldx		str_dat3
	cmpx	#$5555
	bne		str_error

	ldu		#$4567
	stu		str_dat3
	ldd		str_dat3
	cmpd	#$4567
	bne		str_error

	sts		str_dat3
	ldx		str_dat3
	cmpx	#stack_top
	bne		str_error

	jmp		lea_test

str_dat0
	fcb		$aa
str_dat1
	fcb		$ff
str_dat3
	fcb		$00,$00

str_error
	jmp		test_error

; LEA Instruction Test & Index Addressing Mode Test
lea_test
	ldx		#$0000
	leay	,x				; no offset
	lbne		lea_error
	cmpy	#$0000
	lbne		lea_error
	leay	1,y				; 5bit offset
	lbeq		lea_error
	cmpy	#$0001
	lbne		lea_error

	ldu		#$ffff
	leau	,x
	lbeq		lea_error
	cmpu	#$0000
	lbne		lea_error
	leau	64,u			; 8bit offset
	lbne		lea_error
	cmpu	#$0040
	lbne		lea_error

	leax	256,x			; 16bit offset
	cmpx	#$0100
	lbne		lea_error

	ldx		#$0123
	ldd		#$55aa
	leay	a,x				; A offset
	cmpy	#$0178
	lbne		lea_error

	leau	b,x				; B offset
	cmpu	#$00cd
	lbne		lea_error

	leax	d,x				; D offset
	cmpx	#$56cd
	lbne		lea_error

	ldx		#$789a
	leay	,x+				; post-increment by 1
	cmpy	#$789a
	lbne		lea_error
	cmpx	#$789b
	lbne		lea_error

	ldx		#$4567
	leau	,x++			; post-increment by 2
	cmpu	#$4567
	lbne		lea_error
	cmpx	#$4569
	lbne		lea_error

	ldx		#0000
	leay	,-x				; pre-decrement by 1
	cmpy	#$ffff
	lbne		lea_error
	cmpx	#$ffff
	lbne		lea_error

	ldx		#$0002
	leau	,--x			; pre_decrement by 2
	cmpu	#$0000
	lbne		lea_error
	cmpx	#$0000
	lbne		lea_error

lea_tst0
	leax	lea_tst0,pcr	; 8bit offset from PC
	cmpx	#lea_tst0
	lbne		lea_error

	leay	lea_dat0,pcr	; 16bit offset from PC
	cmpy	#lea_dat0
	lbne		lea_error

	ldx		#lea_dat1
	leay	[,x]			; no offset indirect
	cmpy	#lea_dat2
	lbne		lea_error

	leau	[2,x]			; 8bit offset indirect
	cmpu	#lea_dat3
	bne		lea_error

	ldx		#lea_dat0
	leay	[(lea_dat3-lea_dat0),x]	; 16bit offset indirect
	cmpy	#lea_dat4
	bne		lea_error

	ldx		#lea_dat2
	lda		#(lea_dat1-lea_dat2)
	leau	[a,x]				; A offset indirect
	cmpu	#lea_dat2
	bne		lea_error

	ldb		#(lea_dat3-lea_dat2)
	leay	[b,x]				; B offset indirect
	cmpy	#lea_dat4
	bne		lea_error

	ldx		#lea_dat0
	ldd		#(lea_dat1-lea_dat0)
	leau	[d,x]				; D offset indirect
	cmpu	#lea_dat2
	bne		lea_error

	jmp		lea_tst1

lea_dat1
	fdb		lea_dat2
lea_dat2
	fdb		lea_dat3
lea_dat3
	fdb		lea_dat4
lea_dat4

lea_tst1
	ldu		#lea_dat2
	leay	[,u++]				; post-increment by 2 indirect
	cmpy	#lea_dat3
	bne		lea_error
	cmpu	#lea_dat3
	bne		lea_error

	ldu		#lea_dat2
	leax	[,--u]				; pre-decrement by 2 indirect
	cmpx	#lea_dat2
	bne		lea_error
	cmpu	#lea_dat1
	bne		lea_error

	leau	[lea_dat2,pcr]		; 8bit offset from PC indirect
	cmpu	#lea_dat3
	bne		lea_error

	leax	[lea_dat0,pcr]		; 16bit offset from PC indierct
	cmpx	#lea_dat1
	bne		lea_error

	leay	[lea_dat5]			; extended indirect
	cmpy	#lea_dat6
	bne		lea_error

	jmp		tfr_test

lea_dat5
	fdb		lea_dat6
lea_dat6

lea_error
	jmp		test_error

tfr_test
	ldd		#$cdef
	tfr		a,b					; 8bit register
	cmpd	#$cdcd
	bne		tfr_error

	ldx		#$0123
	ldy		#$4567
	tfr		x,y					; 16 bit register
	cmpx	#$0123
	bne		tfr_error
	cmpy	#$0123
	bne		tfr_error

	tfr		pc,x				; from PC
tfr_tst0
	cmpx	#tfr_tst0
	bne		tfr_error

	lda		#$00
	ldy		#tfr_tst1
	tfr		y,pc				; to PC
	lda		#$ff
tfr_tst1
	cmpa	#$00
	bne		tfr_error

	jmp		exg_test

tfr_error
	jmp		test_error

exg_test
	ldd		#$aa55
	exg		a,b					; 8bit register
	cmpd	#$55aa
	bne		exg_error

	ldu		#$ffff
	ldy		#$89ab
	exg		y,u					; 16bit register
	cmpu	#$89ab
	bne		exg_error
	cmpy	#$ffff
	bne		exg_error

	ldb		#$ff
	ldx		#exg_tst1
	exg		x,pc				; between PC and another
exg_tst0
	ldb		#$00
exg_tst1
	cmpx	#exg_tst0
	cmpb	#$ff
	bne		exg_error

	jmp		and_test

exg_error
	jmp		test_error

and_test
	lda		#$a5
	anda	#$5a
	bvs		and_error
	bmi		and_error
	bne		and_error
	cmpa	#$00
	bne		and_error

	ldb		#$85
	andb	and_dat0
	bvs		and_error
	bpl		and_error
	beq		and_error
	cmpb	#$85
	bne		and_error

	andcc	#$f5
	bvs		and_error
	bmi		and_error

	jmp		or_test

and_dat0
	fcb		$ff

and_error
	jmp		test_error

or_test
	lda		#$a5
	ora		#$5a
	bvs		or_error
	bpl		or_error
	beq		or_error
	cmpa	#$ff
	bne		or_error

	ldb		#$55
	orb		or_dat0
	bvs		or_error
	bmi		or_error
	beq		or_error
	cmpb	#$55
	bne		or_error

	orcc	#$05
	bcc		or_error
	bne		or_error

	jmp		eor_test

or_dat0
	fcb		$00

or_error
	jmp		test_error

eor_test
	lda		#$5a
	eora	eor_dat0
	bvs		eor_error
	bmi		eor_error
	beq		eor_error
	cmpa	#$0f
	bne		eor_error

	ldb		#$ff
	eorb	#$a5
	bvs		eor_error
	bmi		eor_error
	beq		eor_error
	cmpb	#$5a
	bne		eor_error

	jmp		bit_test

eor_dat0
	fcb		$55

eor_error
	jmp		test_error

bit_test
	lda		#$ff
	bita	#$00		; eval $00
	bvs		bit_error
	bmi		bit_error
	bne		bit_error
	cmpa	#$ff
	bne		bit_error

	ldb		#$0a
	bitb	bit_dat0	; eval $0a
	bvs		bit_error
	bmi		bit_error
	beq		bit_error
	cmpb	#$0a
	bne		bit_error

	jmp		tst_test

bit_dat0
	fcb		$aa

bit_error
	jmp		test_error

tst_test
	lda		#$00
	tsta
	bvs		tst_error
	bmi		tst_error
	bne		tst_error
	cmpa	#$00
	bne		tst_error

	ldb		#$55
	tstb
	bvs		tst_error
	bmi		tst_error
	beq		tst_error
	cmpb	#$55
	bne		tst_error

	tst		tst_dat0
	bvs		tst_error
	bpl		tst_error
	beq		tst_error
	lda		tst_dat0
	cmpa	#$80
	bne		tst_error

	jmp		clr_test

tst_dat0
	fcb		$80

tst_error
	jmp		test_error

clr_test
	lda		#$aa
	clra
	bcs		clr_error
	bvs		clr_error
	bmi		clr_error
	bne		clr_error
	cmpa	#$00
	bne		clr_error

	ldb		#$55
	clrb
	bcs		clr_error
	bvs		clr_error
	bmi		clr_error
	bne		clr_error
	cmpb	#$00
	bne		clr_error

	clr		clr_dat0
	bcs		clr_error
	bvs		clr_error
	bmi		clr_error
	bne		clr_error
	lda		clr_dat0
	cmpa	#$00
	bne		clr_error

	jmp		com_test

clr_dat0
	fcb		$ff

clr_error
	jmp		test_error

com_test
	lda		#$ff
	coma
	bcc		com_error
	bvs		com_error
	bmi		com_error
	bne		com_error
	cmpa	#$00
	bne		com_error

	ldb		#$7f
	comb
	bcc		com_error
	bvs		com_error
	bpl		com_error
	beq		com_error
	cmpb	#$80
	bne		com_error

	com		com_dat0
	bcc		com_error
	bvs		com_error
	bmi		com_error
	beq		com_error
	lda		com_dat0
	cmpa	#$5a
	bne		com_error

	jmp		sgx_test

com_dat0
	fcb		$a5

com_error
	jmp		test_error

sgx_test
	ldd		#$0080
	sex
	cmpd	#$ff80
	bne		sgx_error

	ldd		#$ff7f
	sex
	cmpd	#$007f
	bne		sgx_error

	jmp		add_test

sgx_error
	jmp		test_error

add_test
	lda		#$ff
	adda	add_dat0
	bcc		add_error
	bvs		add_error
	bmi		add_error
	bne		add_error
	tfr		cc,b
	bitb	#$20		; Hbit
	beq		add_error
	cmpa	#$00
	bne		add_error

	ldb		#$aa
	addb	#$55
	bcs		add_error
	bvs		add_error
	bpl		add_error
	beq		add_error
	tfr		cc,a
	bita	#$20		; Hbit
	bne		add_error
	cmpb	#$ff
	bne		add_error

	ldd		#$0123
	addd	#$8765
	bcs		add_error
	bvs		add_error
	bpl		add_error
	beq		add_error
	cmpd	#$8888
	bne		add_error

	ldd		#$3456
	addd	add_dat1
	bcs		add_error
	bvs		add_error
	bmi		add_error
	beq		add_error
	cmpd	#$4567
	bne		add_error

	jmp		adc_test

add_dat0
	fcb		$01
add_dat1
	fdb		$1111

add_error
	jmp		test_error

adc_test
	lda		#$fe
	orcc	#$01	; set Cbit
	adca	#$01
	bcc		adc_error
	bvs		adc_error
	bmi		adc_error
	bne		adc_error
	tfr		cc,b
	bitb	#$20	; Hbit
	beq		adc_error
	cmpa	#$00
	bne		adc_error

	ldb		#$10
	andcc	#$fe	; clear Cbit
	adcb	adc_dat0
	bcs		adc_error
	bvc		adc_error
	bpl		adc_error
	beq		adc_error
	tfr		cc,a
	bitb	#$20	; Hbit
	bne		adc_error
	cmpb	#$8e
	bne		adc_error

	jmp		sub_test

adc_dat0
	fcb		$7e

adc_error
	jmp		test_error

sub_test
	lda		#$00
	suba	#$01
	bcc		sub_error
	bvs		sub_error
	bpl		sub_error
	beq		sub_error
	cmpa	#$ff
	bne		sub_error

	ldb		#$55
	subb	sub_dat0
	bcc		sub_error
	bvs		sub_error
	bmi		sub_error
	beq		sub_error
	cmpb	#$56
	bne		sub_error

	ldd		#$5555
	subd	#$aaaa
	bcc		sub_error
	bvc		sub_error
	bpl		sub_error
	beq		sub_error
	cmpd	#$aaab
	bne		sub_error

	jmp		sbc_test

sub_dat0
	fcb		$ff

sub_error
	jmp		test_error

sbc_test
	orcc	#$01		; set Cbit
	lda		#$02
	sbca	#$01
	bcs		sbc_error
	bvs		sbc_error
	bmi		sbc_error
	bne		sbc_error
	cmpa	#$00
	bne		sbc_error

	andcc	#$fe		; clear Cbit
	ldb		#$a5
	sbcb	sbc_dat0
	bcs		sbc_error
	bvc		sbc_error
	bmi		sbc_error
	beq		sbc_error
	cmpb	#$4b
	bne		sbc_error

	jmp		abx_test

sbc_dat0
	fcb		$5a

sbc_error
	jmp		test_error

abx_test
	ldx		#$1234
	ldb		#$80
	abx
	cmpx	#$12b4
	bne		abx_error

	jmp		daa_test

abx_error
	jmp		test_error

daa_test
	lda		#$12
	adda	#$39
	daa
	bcs		daa_error
	bvs		daa_error
	bmi		daa_error
	beq		daa_error
	cmpa	#$51
	bne		daa_error

	lda		#$80
	adda	#$55
	daa
	bcc		daa_error
	bvs		daa_error
	bmi		daa_error
	beq		daa_error
	cmpa	#$35
	bne		daa_error

	jmp		inc_test

daa_error
	jmp		test_error

inc_test
	lda		#$00
	inca
	bvs		inc_error
	bmi		inc_error
	beq		inc_error
	cmpa	#$01
	bne		inc_error

	ldb		#$7f
	incb
	bvc		inc_error
	bpl		inc_error
	beq		inc_error
	cmpb	#$80
	bne		inc_error

	inc		inc_dat0
	bvs		inc_error
	bmi		inc_error
	bne		inc_error
	lda		inc_dat0
	cmpa	#$00
	bne		inc_error

	jmp		dec_test

inc_dat0
	fcb		$ff

inc_error
	jmp		test_error

dec_test
	lda		#$00
	deca
	bvs		dec_error
	bpl		dec_error
	beq		dec_error
	cmpa	#$ff
	bne		dec_error

	ldb		#$80
	decb
	bvc		dec_error
	bmi		dec_error
	beq		dec_error
	cmpb	#$7f
	bne		dec_error

	dec		dec_dat0
	bvs		dec_error
	bmi		dec_error
	bne		dec_error
	ldb		dec_dat0
	cmpb	#$00
	bne		dec_error

	jmp		neg_test

dec_dat0
	fcb		$01

dec_error
	jmp		test_error

neg_test
	lda		#$00
	nega
	bcs		neg_error
	bvs		neg_error
	bmi		neg_error
	bne		neg_error
	cmpa	#$00
	bne		neg_error

	ldb		#$55
	negb
	bcc		neg_error
	bvs		neg_error
	bpl		neg_error
	beq		neg_error
	cmpb	#$ab
	bne		neg_error

	neg		neg_dat0
	bcc		neg_error
	bvc		neg_error
	bpl		neg_error
	beq		neg_error
	lda		neg_dat0
	cmpa	#$80
	bne		neg_error

	jmp		shf_test

neg_dat0
	fcb		$80

neg_error
	jmp		test_error

shf_test
	; ASR
	lda		#$81
	asra
	lbcc		shf_error
	lbpl		shf_error
	lbeq		shf_error
	cmpa	#$c0
	lbne		shf_error

	asr		shf_dat0
	lbcs		shf_error
	lbmi		shf_error
	lbeq		shf_error
	ldb		shf_dat0
	cmpb	#$39
	lbne		shf_error

	; LSR
	ldb		#$81
	lsrb
	lbcc		shf_error
	lbmi		shf_error
	lbeq		shf_error
	cmpb	#$40
	lbne		shf_error

	lsr		shf_dat1
	bcc		shf_error
	bmi		shf_error
	bne		shf_error
	lda		shf_dat1
	cmpa	#$00
	bne		shf_error

	; LSL (=ASL)
	lda		#$85
	lsla
	bcc		shf_error
	bvc		shf_error
	bmi		shf_error
	beq		shf_error
	cmpa	#$0a
	bne		shf_error

	lsl		shf_dat2
	bcs		shf_error
	bvc		shf_error
	bpl		shf_error
	beq		shf_error
	ldb		shf_dat2
	cmpb	#$fe
	bne		shf_error

	; ROR
	orcc	#$01		; set Cbit
	ldb		#$55
	rorb
	bcc		shf_error
	bpl		shf_error
	beq		shf_error
	cmpb	#$aa
	bne		shf_error

	andcc	#$fe		; clear Cbit
	ror		shf_dat3
	bcc		shf_error
	bmi		shf_error
	bne		shf_error
	lda		shf_dat3
	cmpa	#$00
	bne		shf_error

	; ROL
	andcc	#$fe		; clear Cbit
	lda		#$85
	rola
	bcc		shf_error
	bvc		shf_error
	bmi		shf_error
	beq		shf_error
	cmpa	#$0a
	bne		shf_error

	orcc	#$01		; set Cbit
	rol		shf_dat4
	bcs		shf_error
	bvs		shf_error
	bmi		shf_error
	beq		shf_error
	ldb		shf_dat4
	cmpb	#$6b
	bne		shf_error

	jmp		mul_test

shf_dat0
	fcb		$72
shf_dat1
	fcb		$01
shf_dat2
	fcb		$7f
shf_dat3
	fcb		$01
shf_dat4
	fcb		$35

shf_error
	jmp		test_error

mul_test
	ldd		#$ff00
	mul
	bne		mul_error
	cmpd	#$0000
	bne		mul_error

	ldd		#$80ab
	mul
	bcc		mul_error
	beq		mul_error
	cmpd	#$5580
	bne		mul_error

	ldd		#$0155
	mul
	beq		mul_error
	cmpd	#$0055
	bne		mul_error

	jmp		sbr_test

mul_error
	jmp		test_error

sbr_test
	lda		#$00
	jsr		sbr_tst0
	cmpa	#$1b
	bne		sbr_error

	jmp		bra_test

sbr_tst1
	lsla
	lsla
	ora		#$02
	lbsr	sbr_tst2
	rts

sbr_tst0
	lsla
	lsla
	ora		#$01
	bsr		sbr_tst1
	rts

sbr_tst2
	lsla
	lsla
	ora		#$03
	rts

sbr_error
	jmp		test_error

; Long Branch Test
bra_test
	bra		bra_tst0
bra_tst1
	nop

	jmp		stk_test

bra_tst0
	lbra	bra_tst1

bra_error
	jmp		test_error

stk_test
	ldd		#$55aa
	ldx		#$0123
	ldy		#$4567
	ldu		#$89ab
	pshs	cc,a,b,dp,x,y,u,pc
stk_tst0
	puls	a,b
	cmpb	#$55
	bne		stk_error
	puls	a,b
	cmpa	#$aa
	bne		stk_error
	puls	y
	cmpy	#$0123
	bne		stk_error
	puls	x
	cmpx	#$4567
	bne		stk_error
	puls	x,y
	cmpx	#$89ab
	bne		stk_error
	cmpy	#stk_tst0
	bne		stk_error

	ldd		#$ff00
	ldx		#$5555
	ldy		#$aaaa
	pshu	a,b,x,y,s
	pulu	x
	cmpx	#$ff00
	bne		stk_error
	pulu	y
	cmpy	#$5555
	bne		stk_error
	pulu	x,y
	cmpx	#$aaaa
	bne		stk_error
	cmpy	#stack_top
	bne		stk_error

	lda		#$ff
	ldx		#stk_tst1
	pshu	x
	pulu	pc
	lda		#$00
stk_tst1
	cmpa	#$ff
	bne		stk_error

	jmp		int_test

stk_error
	jmp		test_error

; Interrupt Test
irq_trg	equ	$fd00
fiq_trg	equ	$fd01
nmi_trg	equ	$fd02
int_test
	lda		#$2f
	tfr		a,cc		; clear E,F,I bits
	lda		#$02
	sta		irq_trg		; IRQ (delayed)
	lda		#$01
	sta		fiq_trg		; FIRQ
	ldb		int_dat0
	cmpb	#$2d
	bne		int_error

	jmp		swi_test

int_dat0
	fcb		$00

int_error
	jmp		test_error

swi_test
	andcc	#$2f		; clear E,F,I bits
	swi
	swi2
	swi3
	lda		swi_dat0
	cmpa	#$00
	bne		swi_error

	jmp		sync_test

swi_dat0
	fcb		$00

swi_error
	jmp		test_error

sync_test
	orcc	#$50		; set F,I bits
	lda		#$02
	sta		irq_trg		; IRQ (delayed)
	sync
	lda		#$00
	sta		irq_trg		; clear IRQ

	jmp		wai_test

sync_error
	jmp		test_error

wai_test
	lda		#$02
	sta		irq_trg		; IRQ (delayed)
	cwai	#$2f		; clear E,F,I bits

	jmp		test_end

wai_error
	jmp		test_error

; test ok
test_end
	bra		test_end

irq_hdl
	ldb		int_dat0
	lslb
	lslb
	orb		#$01
	stb		int_dat0
	lda		#$00
	sta		irq_trg
	rti

fiq_hdl
	ldb		int_dat0
	lslb
	lslb
	orb		#$02
	stb		int_dat0
	lda		#$01
	sta		nmi_trg
	lda		#$00
	sta		fiq_trg
	rti

nmi_hdl
	ldb		int_dat0
	lslb
	lslb
	orb		#$03
	stb		int_dat0
	lda		#$00
	sta		nmi_trg
	rti

swi_hdl
	ldb		swi_dat0
	tfr		cc,a
	bita	#$80
	bne		swi1_0
	orb		#$01
swi1_0
	bita	#$40
	bne		swi1_1
	orb		#$02
swi1_1
	bita	#$10
	bne		swi1_2
	orb		#$04
swi1_2
	stb		swi_dat0
	rti

swi2_hdl
	ldb		swi_dat0
	tfr		cc,a
	bita	#$80
	bne		swi2_0
	orb		#$10
swi2_0
	bita	#$50
	beq		swi2_1
	orb		#$20
swi2_1
	stb		swi_dat0
	rti

swi3_hdl
	ldb		swi_dat0
	tfr		cc,a
	bita	#$80
	bne		swi3_0
	orb		#$40
swi3_0
	bita	#$50
	beq		swi3_1
	orb		#$80
swi3_1
	stb		swi_dat0
	rti

	;
	; vectors
	;
	org		$fff2
	fdb		swi3_hdl
	fdb		swi2_hdl
	fdb		fiq_hdl
	fdb		irq_hdl
	fdb		swi_hdl
	fdb		nmi_hdl
	fdb		test_start

	end

; End of test.asm
