//
// ac09_tb.v
//
// ac09 processor core
//
// Version 0.6
//
// Copyright 2008, Hideyuki Abe. All rights reserved.
// Distributed under the terms of the MIT License.
//

module ac09_tb;

reg	clk;
reg	rst;

wire [15:0]	addr;
wire	en;
wire	wen;
wire [7:0]	wdata;
wire [7:0]	rdata;
reg	ack;

reg	irq_pre;
reg [3:0]	irq_cnt;
reg	irq;
reg	fiq;
reg	nmi;


always begin
	#5	clk = ~clk;
end

initial begin
	clk = 1'b1;
	rst = 1'b0;
	#10	;
	#1	rst = 1'b1;
	#(10 * 3000)	;
	$finish;
end

ac09_top ac09_top0(
	.clk(clk),
	.rst(rst),
	.addr(addr),
	.en(en),
	.wen(wen),
	.wdata(wdata),
	.rdata(rdata),
	.ack(ack),
	.irq(irq),
	.fiq(fiq),
	.nmi(nmi)
);

sync_ram ram0(
	.clk(clk),
	.addr(addr),
	.ceb(~en),
	.web(~wen),
	.wdata(wdata),
	.rdata(rdata)
);

always @(posedge clk or negedge rst) begin
	if(~rst)
		ack <= 1'b0;
	else
		ack <= en;
end

always @(posedge clk or negedge rst) begin
	if(~rst)
		irq_pre <= 1'b0;
	else if(irq_cnt == 4'h0)
		irq_pre <= 1'b0;
	else if((addr == 16'hfd00) & en & wen)
		irq_pre <= wdata[1];
end

always @(posedge clk or negedge rst) begin
	if(~rst)
		irq_cnt <= 4'hf;
	else if(irq_cnt == 4'h0)
		irq_cnt <= 4'hf;
	else if(irq_pre)
		irq_cnt <= irq_cnt - 4'h1;
end

always @(posedge clk or negedge rst) begin
	if(~rst)
		irq <= 1'b0;
	else if((addr == 16'hfd00) & en & wen)
		irq <= wdata[0];
	else if(irq_pre & (irq_cnt == 4'h0))
		irq <= 1'b1;
end

always @(posedge clk or negedge rst) begin
	if(~rst)
		fiq <= 1'b0;
	else if((addr == 16'hfd01) & en & wen)
		fiq <= wdata[0];
end

always @(posedge clk or negedge rst) begin
	if(~rst)
		nmi <= 1'b0;
	else if((addr == 16'hfd02) & en & wen)
		nmi <= wdata[0];
end

initial begin
	$readmemh("test.dat", ram0.mem);
end

initial begin
	$dumpfile("ac09_tb.vcd");
	$dumpvars(0, ac09_tb);
end

endmodule

// End of ac09_tb.v
