//
// ac09_defs.v
//
// ac09 processor core
//
// Version 0.6
//
// Copyright 2008, Hideyuki Abe. All rights reserved.
// Distributed under the terms of the MIT License.
//

// opcode
`define	OPC_LEN		6
`define	OPC_NOP		6'b00_0000
`define	OPC_CMP		6'b00_0001
`define	OPC_LD		6'b00_0010
`define	OPC_ST		6'b00_0011
`define	OPC_TFR		6'b00_0100
`define	OPC_BCC		6'b00_0101
`define	OPC_JMP		6'b00_0110
`define	OPC_LEA		6'b00_0111
`define	OPC_LEAS	6'b00_1000
`define	OPC_EXG		6'b00_1001
`define	OPC_LOP		6'b00_1010
`define	OPC_ABX		6'b00_1011
`define	OPC_DAA		6'b00_1100
`define	OPC_LOPCC	6'b00_1101
`define	OPC_MUL		6'b00_1110
`define	OPC_BIT		6'b00_1111
`define	OPC_TSTR	6'b01_0000
`define	OPC_TST		6'b01_0001
`define	OPC_CLRR	6'b01_0010
`define	OPC_CLR		6'b01_0011
`define	OPC_COMR	6'b01_0100
`define	OPC_COM		6'b01_0101
`define	OPC_SEX		6'b01_0110
`define	OPC_AOP		6'b01_0111
`define	OPC_INDCR	6'b01_1000
`define	OPC_INDC	6'b01_1001
`define	OPC_NEGR	6'b01_1010
`define	OPC_NEG		6'b01_1011
`define	OPC_SHFR	6'b01_1100
`define	OPC_SHF		6'b01_1101
`define	OPC_JSR		6'b01_1110
`define	OPC_BSR		6'b01_1111
`define	OPC_RTS		6'b10_0000
`define	OPC_PUSH	6'b10_0001
`define	OPC_PULL	6'b10_0010
`define	OPC_RTI		6'b10_0011
`define	OPC_SWI		6'b10_0100
`define	OPC_SWI2	6'b10_0101
`define	OPC_SWI3	6'b10_0110
`define	OPC_SYNC	6'b10_0111
`define	OPC_CWAI	6'b10_1000

`define	OPC_UNDEF	6'b11_1111

// register number
`define	REG_LEN		4
`define	REG_ACCD	4'b0000
`define	REG_IX		4'b0001
`define	REG_IY		4'b0010
`define	REG_USP		4'b0011
`define	REG_SSP		4'b0100
`define	REG_PC		4'b0101
`define	REG_ACCA	4'b1000
`define	REG_ACCB	4'b1001
`define	REG_CCR		4'b1010
`define	REG_DPR		4'b1011

// amode
`define	AMODE_LEN	3
`define	AMODE_NONE	3'b000
`define	AMODE_IMM	3'b001
`define	AMODE_DIR	3'b010
`define	AMODE_IDX	3'b011
`define	AMODE_EXT	3'b100
`define	AMODE_REL8	3'b101
`define	AMODE_REL16	3'b110
`define	AMODE_PB	3'b111

// cfg_mux
`define	CFGMUX_LEN	2
`define	CFGMUX_NULL	2'b00
`define	CFGMUX_FIQ	2'b01
`define	CFGMUX_IRQ	2'b10
`define	CFGMUX_RTI	2'b11

// ea_mux
`define	EAMUX_LEN	2
`define	EAMUX_NULL	2'b00
`define	EAMUX_OUTA	2'b01
`define	EAMUX_DDAT	2'b10
`define	EAMUX_IBASE	2'b11

// pc_mux
`define	PCMUX_LEN	3
`define	PCMUX_ZERO	3'b000
`define	PCMUX_TMP	3'b001
`define	PCMUX_OUTA	3'b010
`define	PCMUX_EA	3'b011
`define	PCMUX_PCO	3'b100

// cpc_mux
`define	CPCMUX_LEN	2
`define	CPCMUX_NULL	2'b00
`define	CPCMUX_PCN	2'b01
`define	CPCMUX_PCR	2'b10

// tmp_mux
`define	TMUX_LEN	3
`define	TMUX_NULL	3'b000
`define	TMUX_DDAT	3'b001
`define	TMUX_RDAT	3'b010
`define	TMUX_PSHINI	3'b011
`define	TMUX_PSHNXT	3'b100
`define	TMUX_PULINI	3'b101
`define	TMUX_PULNXT	3'b110
`define	TMUX_ZERO	3'b111

// op_sel
`define	ALUOP_LEN	5
`define	ALUOP_NONE	5'b0_0000
`define	ALUOP_THRU	5'b0_0001
`define	ALUOP_ADD	5'b0_0010
`define	ALUOP_SUB	5'b0_0011
`define	ALUOP_ADD16	5'b0_0100
`define	ALUOP_SUB16	5'b0_0101
`define	ALUOP_AND	5'b0_0110
`define	ALUOP_EOR	5'b0_0111
`define	ALUOP_OR	5'b0_1000
`define	ALUOP_COM	5'b0_1001
`define	ALUOP_SEX	5'b0_1010
`define	ALUOP_ADC	5'b0_1011
`define	ALUOP_SBC	5'b0_1100
`define	ALUOP_DAA	5'b0_1101
`define	ALUOP_SUBR	5'b0_1110
`define	ALUOP_ASR	5'b0_1111
`define	ALUOP_LSR	5'b1_0000
`define	ALUOP_LSL	5'b1_0001
`define	ALUOP_ROR	5'b1_0010
`define	ALUOP_ROL	5'b1_0011
`define	ALUOP_MUL	5'b1_0100
`define	ALUOP_PSH	5'b1_0101
`define	ALUOP_PUL	5'b1_0110

`define	ALUOP_MAIN	5'b1_1111

// ina_mux
`define	AMUX_LEN	3
`define	AMUX_ZERO	3'b000
`define	AMUX_OPRND	3'b001
`define	AMUX_RDAT	3'b010
`define	AMUX_PC		3'b011
`define	AMUX_DDAT	3'b100
`define	AMUX_EA		3'b101
`define	AMUX_IBASE	3'b110

// inb_mux
`define	BMUX_LEN		4
`define	BMUX_ZERO		4'b0000
`define	BMUX_OPRND		4'b0001
`define	BMUX_OPRND8SE	4'b0010
`define	BMUX_DDAT		4'b0011
`define	BMUX_OFF5		4'b0100
`define	BMUX_ACCA		4'b0101
`define	BMUX_ACCB		4'b0110
`define	BMUX_ACCD		4'b0111
`define	BMUX_ONE		4'b1000
`define	BMUX_TWO		4'b1001
`define	BMUX_ACCBZE		4'b1010
`define	BMUX_TMP		4'b1011

// cc_mux
`define	CCMUX_LEN	4
`define	CCMUX_NULL	4'b0000
`define	CCMUX_LOP	4'b0001
`define	CCMUX_AOP	4'b0010
`define	CCMUX_AOP2	4'b0011
`define	CCMUX_ZBIT	4'b0100
`define	CCMUX_AOP3	4'b0101
`define	CCMUX_MSKF	4'b0110
`define	CCMUX_MSKI	4'b0111
`define	CCMUX_SETE	4'b1000
`define	CCMUX_CLRE	4'b1001

// rbus_mux
`define	RMUX_LEN	2
`define	RMUX_NULL	2'b00
`define	RMUX_WR		2'b01
`define	RMUX_RD		2'b10

// rnum_mux
`define	RNUM_LEN	3
`define	RNUM_ZERO	3'b000
`define	RNUM_OPREG	3'b001
`define	RNUM_REG1	3'b010
`define	RNUM_REG2	3'b011
`define	RNUM_IBASE	3'b100
`define	RNUM_RLST	3'b101

// rwd_mux
`define	RWDMUX_LEN	3
`define	RWDMUX_ZERO	3'b000
`define	RWDMUX_OUTA	3'b001
`define	RWDMUX_RDAT	3'b010
`define	RWDMUX_TMP	3'b011
`define	RWDMUX_EA	3'b100
`define	RWDMUX_DDAT	3'b101

// dbus_mux
`define	DMUX_LEN	3
`define	DMUX_NULL	3'b000
`define	DMUX_RD16	3'b001
`define	DMUX_RD		3'b010
`define	DMUX_WR		3'b011
`define	DMUX_WR16	3'b100
`define	DMUX_WRT	3'b101
`define	DMUX_RDT	3'b110

// da_mux
`define	DAMUX_LEN	4
`define	DAMUX_ZERO	4'b0000
`define	DAMUX_RSTV	4'b0001
`define	DAMUX_EA	4'b0010
`define	DAMUX_OUTA	4'b0011
`define	DAMUX_RDAT	4'b0100
`define	DAMUX_NMIV	4'b0101
`define	DAMUX_FIQV	4'b0110
`define	DAMUX_IRQV	4'b0111
`define	DAMUX_SWIV	4'b1000
`define	DAMUX_SWI2V	4'b1001
`define	DAMUX_SWI3V	4'b1010

// dwd_mux
`define	DWDMUX_LEN	3
`define	DWDMUX_ZERO	3'b000
`define	DWDMUX_OUTA	3'b001
`define	DWDMUX_PC	3'b010
`define	DWDMUX_RDAT	3'b011
`define	DWDMUX_CPC	3'b100

// End of ac09_defs.v
