//
// ac09_addsub.v
//
// ac09 processor core
//
// Version 0.6
//
// Copyright 2008, Hideyuki Abe. All rights reserved.
// Distributed under the terms of the MIT License.
//

`include "ac09_defs.v"

module ac09_addsub(
	op,
	opsize,
	ina,
	inb,
	c_bit,
	h_bit,
	out,
	new_c,
	new_h,
	new_v
);

input [1:0]	op;	// 00 - ADD, 01 - ADC, 10 - SUB, 11 - SBC
input	opsize;
input [15:0]	ina;
input [15:0]	inb;
input	c_bit;
input	h_bit;
output [15:0]	out;
output	new_c;
output	new_h;
output	new_v;

reg	new_c;
reg	new_h;
reg	new_v;

wire	cinll;
wire [3:0]	inbll;
wire [3:0]	outll;
wire	coutll;
wire	cinlh;
wire [3:0]	inblh;
wire [3:0]	outlh;
wire	coutlh;
wire	cinhl;
wire [3:0]	inbhl;
wire [3:0]	outhl;
wire	couthl;
wire	cinhh;
wire [3:0]	inbhh;
wire [3:0]	outhh;
wire	couthh;

assign	cinll = (op[1]) ^ ((op[0]) & c_bit);
assign	inbll = op[1] ? (~inb[3:0]) : inb[3:0];

`ifdef	ALTERA_FPGA
add4 add4ll(
	.cin(cinll),
	.dataa(ina[3:0]),
	.datab(inbll),
	.cout(coutll),
	.result(outll)
);
`else
adder4 add4ll(
	.ina(ina[3:0]),
	.inb(inbll),
	.cy_in(cinll),
	.out(outll),
	.cy_out(coutll)
);
`endif

assign	cinlh = coutll;
assign	inblh = op[1] ? (~inb[7:4]) : inb[7:4];

`ifdef	ALTERA_FPGA
add4 add4lh(
	.cin(cinlh),
	.dataa(ina[7:4]),
	.datab(inblh),
	.cout(coutlh),
	.result(outlh)
);
`else
adder4 add4lh(
	.ina(ina[7:4]),
	.inb(inblh),
	.cy_in(cinlh),
	.out(outlh),
	.cy_out(coutlh)
);
`endif

assign	cinhl = coutlh;
assign	inbhl = op[1] ? (~inb[11:8]) : inb[11:8];

`ifdef	ALTERA_FPGA
add4 add4hl(
	.cin(cinhl),
	.dataa(ina[11:8]),
	.datab(inbhl),
	.cout(couthl),
	.result(outhl)
);
`else
adder4 add4hl(
	.ina(ina[11:8]),
	.inb(inbhl),
	.cy_in(cinhl),
	.out(outhl),
	.cy_out(couthl)
);
`endif

assign	cinhh = couthl;
assign	inbhh = op[1] ? (~inb[15:12]) : (inb[15:12]);

`ifdef	ALTERA_FPGA
add4 add4hh(
	.cin(cinhh),
	.dataa(ina[15:12]),
	.datab(inbhh),
	.cout(couthh),
	.result(outhh)
);
`else
adder4 add4hh(
	.ina(ina[15:12]),
	.inb(inbhh),
	.cy_in(cinhh),
	.out(outhh),
	.cy_out(couthh)
);
`endif

assign	out = {outhh, outhl, outlh, outll};

// half carry bit
always @(op or opsize or coutll or h_bit) begin
	if(opsize) begin	// 16bit
		new_h = h_bit;
	end
	else begin			// 8bit
		new_h = op[1] ? (~coutll) : coutll;
	end
end	// always comb

// carry bit
always @(op or opsize or coutlh or couthh) begin
	if(opsize) begin	// 16bit
		new_c = op[1] ? (~couthh) : couthh;
	end
	else begin			// 8bit
		new_c = op[1] ? (~coutlh) : coutlh;
	end
end	// always comb

// overflow bit
always @(opsize or ina or inblh or inbhh or out) begin
	if(opsize) begin	// 16bit
		new_v = (ina[15] & inbhh[3] & ~out[15])
					| ((~ina[15]) & (~inbhh[3]) & out[15]);
	end
	else begin			// 8bit
		new_v = (ina[7] & inblh[3] & ~out[7])
					| ((~ina[7]) & (~inblh[3]) & out[7]);
	end
end	// always comb

endmodule

// End of ac09_addsub.v
